/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.cosmosdb;

import com.azure.data.cosmos.CosmosClient;
import com.microsoft.azure.spring.autoconfigure.cosmosdb.CosmosAutoConfiguration;
import com.microsoft.azure.spring.autoconfigure.cosmosdb.CosmosHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(value={CosmosClient.class, HealthIndicator.class})
@PropertySource(value={"classpath:/azure-spring-actuator.properties"})
@AutoConfigureAfter(value={CosmosAutoConfiguration.class})
public class CosmosHealthConfiguration {
    @Bean
    @ConditionalOnEnabledHealthIndicator(value="azure-cosmos")
    public HealthIndicator cosmosHealthContributor(CosmosClient cosmosClient) {
        return new CosmosHealthIndicator(cosmosClient);
    }
}

