/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.table.CloudTableClient;
import com.microsoft.azure.storage.table.EdmType;
import com.microsoft.azure.storage.table.TablePayloadFormat;

public class TableRequestOptions
extends RequestOptions {
    private PropertyResolver propertyResolver;
    private TablePayloadFormat payloadFormat;

    public TableRequestOptions() {
    }

    public TableRequestOptions(TableRequestOptions other) {
        super(other);
        if (other != null) {
            this.setTablePayloadFormat(other.getTablePayloadFormat());
            this.setPropertyResolver(other.getPropertyResolver());
        }
    }

    protected static final TableRequestOptions applyDefaults(TableRequestOptions options, CloudTableClient client) {
        TableRequestOptions modifiedOptions = new TableRequestOptions(options);
        TableRequestOptions.populateRequestOptions(modifiedOptions, client.getDefaultRequestOptions());
        return TableRequestOptions.applyDefaultsInternal(modifiedOptions, client);
    }

    private static final TableRequestOptions applyDefaultsInternal(TableRequestOptions modifiedOptions, CloudTableClient client) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(TablePayloadFormat.Json);
        }
        return modifiedOptions;
    }

    private static final RequestOptions populateRequestOptions(TableRequestOptions modifiedOptions, TableRequestOptions clientOptions) {
        RequestOptions.populateRequestOptions(modifiedOptions, clientOptions, false);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(clientOptions.getTablePayloadFormat());
        }
        if (modifiedOptions.getPropertyResolver() == null) {
            modifiedOptions.setPropertyResolver(clientOptions.getPropertyResolver());
        }
        return modifiedOptions;
    }

    public TablePayloadFormat getTablePayloadFormat() {
        return this.payloadFormat;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setTablePayloadFormat(TablePayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public static interface PropertyResolver {
        public EdmType propertyResolver(String var1, String var2, String var3, String var4);
    }
}

