/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.table;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.table.DeserializationHelper;
import com.microsoft.azure.storage.table.EdmType;
import com.microsoft.azure.storage.table.EntityProperty;
import com.microsoft.azure.storage.table.EntityResolver;
import com.microsoft.azure.storage.table.ODataPayload;
import com.microsoft.azure.storage.table.ODataUtilities;
import com.microsoft.azure.storage.table.PropertyPair;
import com.microsoft.azure.storage.table.TableEntity;
import com.microsoft.azure.storage.table.TablePayloadFormat;
import com.microsoft.azure.storage.table.TableRequestOptions;
import com.microsoft.azure.storage.table.TableResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class TableDeserializer {
    private static JsonFactory jsonFactory = new JsonFactory();

    TableDeserializer() {
    }

    static <T extends TableEntity, R> ODataPayload<?> parseQueryResponse(InputStream inStream, TableRequestOptions options, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws InstantiationException, IllegalAccessException, XMLStreamException, StorageException, JsonParseException, IOException {
        ODataPayload<?> payload = options.getTablePayloadFormat() == TablePayloadFormat.AtomPub ? TableDeserializer.parseAtomQueryResponse(inStream, clazzType, resolver, options, opContext) : TableDeserializer.parseJsonQueryResponse(inStream, clazzType, resolver, options, opContext);
        return payload;
    }

    static <T extends TableEntity, R> TableResult parseSingleOpResponse(InputStream inStream, TableRequestOptions options, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, OperationContext opContext) throws InstantiationException, IllegalAccessException, XMLStreamException, StorageException, IOException, JsonParseException {
        TableResult res = options.getTablePayloadFormat() == TablePayloadFormat.AtomPub ? TableDeserializer.parseSingleOpAtomResponse(inStream, httpStatusCode, clazzType, resolver, options, opContext) : TableDeserializer.parseSingleOpJsonResponse(inStream, httpStatusCode, clazzType, resolver, options, opContext);
        return res;
    }

    private static <T extends TableEntity, R> TableResult parseJsonEntity(JsonParser parser, Class<T> clazzType, HashMap<String, PropertyPair> classProperties, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws JsonParseException, IOException, StorageException, InstantiationException, IllegalAccessException {
        TableResult res = new TableResult();
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        if (!parser.hasCurrentToken()) {
            parser.nextToken();
        }
        ODataUtilities.assertIsStartObjectJsonToken(parser);
        parser.nextToken();
        while (parser.getCurrentName().startsWith("odata.")) {
            String name = parser.getCurrentName().substring("odata.".length());
            parser.nextToken();
            if (name.equals("etag")) {
                String etag = parser.getValueAsString();
                res.setEtag(etag);
            }
            parser.nextToken();
        }
        if (resolver == null && clazzType == null) {
            return res;
        }
        while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
            String key = "";
            String val = "";
            EdmType edmType = null;
            if (options.getTablePayloadFormat() != TablePayloadFormat.JsonNoMetadata && parser.getCurrentName().endsWith("@odata.type")) {
                parser.nextToken();
                edmType = EdmType.parse(parser.getValueAsString());
                parser.nextValue();
                key = parser.getCurrentName();
                val = parser.getValueAsString();
            } else {
                key = parser.getCurrentName();
                parser.nextToken();
                val = parser.getValueAsString();
                edmType = TableDeserializer.evaluateEdmType(parser.getCurrentToken(), parser.getValueAsString());
            }
            EntityProperty newProp = new EntityProperty(val, edmType);
            newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
            properties.put(key, newProp);
            parser.nextToken();
        }
        String partitionKey = null;
        String rowKey = null;
        Date timestamp = null;
        String etag = null;
        EntityProperty tempProp = (EntityProperty)properties.remove("PartitionKey");
        if (tempProp != null) {
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("RowKey")) != null) {
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = (EntityProperty)properties.remove("Timestamp")) != null) {
            tempProp.setDateBackwardCompatibility(false);
            timestamp = tempProp.getValueAsDate();
            if (res.getEtag() == null) {
                etag = TableDeserializer.getETagFromTimestamp(tempProp.getValueAsString());
                res.setEtag(etag);
            }
        }
        if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && (options.getPropertyResolver() != null || clazzType != null)) {
            if (options.getPropertyResolver() != null) {
                for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
                    EdmType edmType;
                    String key = p.getKey();
                    String value = p.getValue().getValueAsString();
                    try {
                        edmType = options.getPropertyResolver().propertyResolver(partitionKey, rowKey, key, value);
                    }
                    catch (Exception e) {
                        throw new StorageException("InternalError", "The custom property resolver delegate threw an exception. Check the inner exception for more details.", 306, null, e);
                    }
                    try {
                        EntityProperty newProp = new EntityProperty(value, edmType);
                        newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                        properties.put(p.getKey(), newProp);
                    }
                    catch (IllegalArgumentException e) {
                        throw new StorageException("InvalidType", String.format("Failed to parse property '%s' with value '%s' as type '%s'", new Object[]{key, value, edmType}), 306, null, e);
                    }
                }
            } else if (clazzType != null) {
                if (classProperties == null) {
                    classProperties = PropertyPair.generatePropertyPairs(clazzType);
                }
                for (Map.Entry<String, EntityProperty> p : properties.entrySet()) {
                    PropertyPair propPair = classProperties.get(p.getKey());
                    if (propPair == null) continue;
                    EntityProperty newProp = new EntityProperty(p.getValue().getValueAsString(), propPair.type);
                    newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                    properties.put(p.getKey(), newProp);
                }
            }
        }
        res.setProperties(properties);
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, res.getProperties(), res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(res.getProperties(), opContext);
            res.setResult(entity);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TableEntity, R> ODataPayload<?> parseJsonQueryResponse(InputStream inStream, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws InstantiationException, IllegalAccessException, StorageException, JsonParseException, IOException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        JsonParser parser = TableDeserializer.createJsonParserFromStream(inStream);
        try {
            if (resolver != null) {
                commonPayload = resolvedPayload = new ODataPayload();
            } else {
                corePayload = new ODataPayload();
                commonPayload = corePayload;
            }
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            ODataUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            HashMap<String, PropertyPair> classProperties = null;
            if (options.getTablePayloadFormat() == TablePayloadFormat.JsonNoMetadata && clazzType != null) {
                classProperties = PropertyPair.generatePropertyPairs(clazzType);
            }
            while (parser.getCurrentToken() != null) {
                if (parser.getCurrentToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("value")) {
                    parser.nextToken();
                    ODataUtilities.assertIsStartArrayJsonToken(parser);
                    parser.nextToken();
                    while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                        TableResult res = TableDeserializer.parseJsonEntity(parser, clazzType, classProperties, resolver, options, opContext);
                        if (corePayload != null) {
                            corePayload.tableResults.add(res);
                        }
                        if (resolver != null) {
                            resolvedPayload.results.add(res.getResult());
                        } else {
                            corePayload.results.add((TableEntity)res.getResult());
                        }
                        parser.nextToken();
                    }
                    ODataUtilities.assertIsEndArrayJsonToken(parser);
                }
                parser.nextToken();
            }
        }
        finally {
            parser.close();
        }
        return commonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TableEntity, R> TableResult parseSingleOpJsonResponse(InputStream inStream, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws InstantiationException, IllegalAccessException, StorageException, JsonParseException, IOException {
        JsonParser parser = TableDeserializer.createJsonParserFromStream(inStream);
        try {
            TableResult res = TableDeserializer.parseJsonEntity(parser, clazzType, null, resolver, options, opContext);
            res.setHttpStatusCode(httpStatusCode);
            TableResult tableResult = res;
            return tableResult;
        }
        finally {
            parser.close();
        }
    }

    private static <T extends TableEntity, R> TableResult parseAtomEntity(XMLStreamReader xmlr, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws XMLStreamException, InstantiationException, IllegalAccessException, StorageException {
        int eventType = xmlr.getEventType();
        TableResult res = new TableResult();
        xmlr.require(1, null, "entry");
        String etag = xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag");
        res.setEtag(etag);
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            String name = xmlr.getName().toString();
            if (eventType != 1) continue;
            if (name.equals("{http://www.w3.org/2005/Atom}id")) {
                DeserializationHelper.readElementFromXMLReader(xmlr, "id");
                continue;
            }
            if (!name.equals("{http://schemas.microsoft.com/ado/2007/08/dataservices/metadata}properties")) continue;
            if (resolver == null && clazzType == null) {
                return res;
            }
            res.setProperties(TableDeserializer.readAtomProperties(xmlr, options, opContext));
            break;
        }
        if ((eventType = xmlr.next()) == 4) {
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "content");
        eventType = xmlr.next();
        if (eventType == 4) {
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "entry");
        String rowKey = null;
        String partitionKey = null;
        Date timestamp = null;
        EntityProperty tempProp = res.getProperties().remove("PartitionKey");
        if (tempProp != null) {
            partitionKey = tempProp.getValueAsString();
        }
        if ((tempProp = res.getProperties().remove("RowKey")) != null) {
            rowKey = tempProp.getValueAsString();
        }
        if ((tempProp = res.getProperties().remove("Timestamp")) != null) {
            tempProp.setDateBackwardCompatibility(false);
            timestamp = tempProp.getValueAsDate();
        }
        if (resolver != null) {
            res.setResult(resolver.resolve(partitionKey, rowKey, timestamp, res.getProperties(), res.getEtag()));
        } else if (clazzType != null) {
            TableEntity entity = (TableEntity)clazzType.newInstance();
            entity.setEtag(res.getEtag());
            entity.setPartitionKey(partitionKey);
            entity.setRowKey(rowKey);
            entity.setTimestamp(timestamp);
            entity.readEntity(res.getProperties(), opContext);
            res.setResult(entity);
        }
        return res;
    }

    private static <T extends TableEntity, R> ODataPayload<?> parseAtomQueryResponse(InputStream inStream, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws XMLStreamException, InstantiationException, IllegalAccessException, StorageException {
        ODataPayload corePayload = null;
        ODataPayload resolvedPayload = null;
        ODataPayload commonPayload = null;
        if (resolver != null) {
            commonPayload = resolvedPayload = new ODataPayload();
        } else {
            corePayload = new ODataPayload();
            commonPayload = corePayload;
        }
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(inStream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "feed");
        eventType = xmlr.next();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (!name.equals("{http://www.w3.org/2005/Atom}entry")) continue;
                TableResult res = TableDeserializer.parseAtomEntity(xmlr, clazzType, resolver, options, opContext);
                if (corePayload != null) {
                    corePayload.tableResults.add(res);
                }
                if (resolver != null) {
                    resolvedPayload.results.add(res.getResult());
                    continue;
                }
                corePayload.results.add((TableEntity)res.getResult());
                continue;
            }
            if (eventType != 2 || !name.equals("{http://www.w3.org/2005/Atom}feed")) continue;
            break;
        }
        xmlr.require(2, null, "feed");
        return commonPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends TableEntity, R> TableResult parseSingleOpAtomResponse(InputStream inStream, int httpStatusCode, Class<T> clazzType, EntityResolver<R> resolver, TableRequestOptions options, OperationContext opContext) throws XMLStreamException, InstantiationException, IllegalAccessException, StorageException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(inStream);
        try {
            xmlr.require(7, null, null);
            xmlr.next();
            TableResult res = TableDeserializer.parseAtomEntity(xmlr, clazzType, resolver, options, opContext);
            res.setHttpStatusCode(httpStatusCode);
            TableResult tableResult = res;
            return tableResult;
        }
        finally {
            xmlr.close();
        }
    }

    private static HashMap<String, EntityProperty> readAtomProperties(XMLStreamReader xmlr, TableRequestOptions options, OperationContext opContext) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "properties");
        HashMap<String, EntityProperty> properties = new HashMap<String, EntityProperty>();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) {
                xmlr.getText();
                continue;
            }
            if (eventType == 1 && xmlr.getNamespaceURI().equals("http://schemas.microsoft.com/ado/2007/08/dataservices")) {
                String key = xmlr.getLocalName();
                String val = "";
                String edmType = null;
                if (xmlr.getAttributeCount() > 0) {
                    edmType = xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "type");
                    if (xmlr.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "null") != null) {
                        val = null;
                    }
                }
                if ((eventType = xmlr.next()) == 4) {
                    val = xmlr.getText();
                    eventType = xmlr.next();
                }
                xmlr.require(2, null, key);
                EntityProperty newProp = new EntityProperty(val, EdmType.parse(edmType));
                newProp.setDateBackwardCompatibility(options.getDateBackwardCompatibility());
                properties.put(key, newProp);
                continue;
            }
            if (eventType != 2 || !xmlr.getName().toString().equals("{http://schemas.microsoft.com/ado/2007/08/dataservices/metadata}properties")) continue;
        }
        xmlr.require(2, null, "properties");
        return properties;
    }

    private static String getETagFromTimestamp(String timestampString) throws UnsupportedEncodingException {
        timestampString = URLEncoder.encode(timestampString, "UTF-8");
        return "W/\"datetime'" + timestampString + "'\"";
    }

    private static EdmType evaluateEdmType(JsonToken token, String value) {
        EdmType edmType = null;
        edmType = token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE ? EdmType.BOOLEAN : (token == JsonToken.VALUE_NUMBER_FLOAT ? EdmType.DOUBLE : (token == JsonToken.VALUE_NUMBER_INT ? EdmType.INT32 : EdmType.STRING));
        return edmType;
    }

    private static JsonParser createJsonParserFromStream(InputStream streamRef) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createParser(streamRef);
        return parser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }
}

