/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.microsoft.azure.storage.IPRange;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.SharedAccessAccountPolicy;
import com.microsoft.azure.storage.SharedAccessHeaders;
import com.microsoft.azure.storage.SharedAccessPolicy;
import com.microsoft.azure.storage.SharedAccessProtocols;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.UserDelegationKey;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.SharedAccessBlobHeaders;
import com.microsoft.azure.storage.blob.SharedAccessBlobPolicy;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.queue.SharedAccessQueuePolicy;
import com.microsoft.azure.storage.table.SharedAccessTablePolicy;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SharedAccessSignatureHelper {
    public static UriQueryBuilder generateSharedAccessSignatureForAccount(SharedAccessAccountPolicy policy, String signature) throws StorageException {
        Utility.assertNotNull("policy", policy);
        Utility.assertNotNull("signature", signature);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        IPRange ipRange = null;
        SharedAccessProtocols protocols = null;
        String services = null;
        String resourceTypes = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
            ipRange = policy.getRange();
            protocols = policy.getProtocols();
            services = policy.servicesToString();
            resourceTypes = policy.resourceTypesToString();
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2018-11-09");
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "ss", services);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "srt", resourceTypes);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sp", permissions);
        String startString = Utility.getUTCTimeOrEmpty(startTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "st", startString);
        String stopString = Utility.getUTCTimeOrEmpty(expiryTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "se", stopString);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sr", resourceTypes);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sip", ipRange != null ? ipRange.toString() : null);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "spr", protocols != null ? protocols.toString() : null);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sig", signature);
        return builder;
    }

    public static UriQueryBuilder generateSharedAccessSignatureForBlobAndFile(SharedAccessPolicy policy, SharedAccessHeaders headers, String groupPolicyIdentifier, String resourceType, IPRange ipRange, SharedAccessProtocols protocols, String signature) throws StorageException {
        Utility.assertNotNullOrEmpty("resourceType", resourceType);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, resourceType, ipRange, protocols, null, signature, headers);
    }

    public static UriQueryBuilder generateUserDelegationSharedAccessSignatureForBlob(SharedAccessPolicy policy, SharedAccessHeaders headers, String resourceType, IPRange ipRange, SharedAccessProtocols protocols, String signature, UserDelegationKey delegationKey) throws StorageException {
        Utility.assertNotNullOrEmpty("resourceType", resourceType);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, null, resourceType, ipRange, protocols, null, signature, headers);
        builder.add("skoid", delegationKey.getSignedOid().toString());
        builder.add("sktid", delegationKey.getSignedTid().toString());
        builder.add("skt", Utility.getUTCTimeOrEmpty(delegationKey.getSignedStart()));
        builder.add("ske", Utility.getUTCTimeOrEmpty(delegationKey.getSignedExpiry()));
        builder.add("skv", delegationKey.getSignedVersion());
        builder.add("sks", delegationKey.getSignedService());
        return builder;
    }

    public static UriQueryBuilder generateSharedAccessSignatureForQueue(SharedAccessQueuePolicy policy, String groupPolicyIdentifier, IPRange ipRange, SharedAccessProtocols protocols, String signature) throws StorageException {
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, null, null, null, null, groupPolicyIdentifier, null, ipRange, protocols, null, signature, null);
    }

    public static UriQueryBuilder generateSharedAccessSignatureForTable(SharedAccessTablePolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, IPRange ipRange, SharedAccessProtocols protocols, String tableName, String signature) throws StorageException {
        Utility.assertNotNull("tableName", tableName);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHelper(policy, startPartitionKey, startRowKey, endPartitionKey, endRowKey, accessPolicyIdentifier, null, ipRange, protocols, tableName, signature, null);
    }

    public static String generateSharedAccessSignatureHashForAccount(String accountName, SharedAccessAccountPolicy policy, StorageCredentials creds) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resource", accountName);
        Utility.assertNotNull("credentials", creds);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        IPRange ipRange = null;
        SharedAccessProtocols protocols = null;
        String services = null;
        String resourceTypes = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
            ipRange = policy.getRange();
            protocols = policy.getProtocols();
            services = policy.servicesToString();
            resourceTypes = policy.resourceTypesToString();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n", accountName, permissions == null ? "" : permissions, services, resourceTypes, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), ipRange == null ? "" : ipRange.toString(), protocols == null ? "" : protocols.toString(), "2018-11-09");
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashHelper(stringToSign, creds);
    }

    public static String generateSharedAccessSignatureHashForBlobAndFile(SharedAccessPolicy policy, SharedAccessHeaders headers, String accessPolicyIdentifier, String resourceName, IPRange ipRange, SharedAccessProtocols protocols, ServiceClient client, String service, String snapshotId) throws InvalidKeyException, StorageException {
        String stringToSign = SharedAccessSignatureHelper.generateSharedAccessSignatureStringToSign(policy, resourceName, ipRange, protocols, accessPolicyIdentifier);
        if (client instanceof CloudBlobClient) {
            stringToSign = String.format("%s\n%s\n%s", stringToSign, service == null ? "" : service, snapshotId == null ? "" : snapshotId);
        }
        String cacheControl = null;
        String contentDisposition = null;
        String contentEncoding = null;
        String contentLanguage = null;
        String contentType = null;
        if (headers != null) {
            cacheControl = headers.getCacheControl();
            contentDisposition = headers.getContentDisposition();
            contentEncoding = headers.getContentEncoding();
            contentLanguage = headers.getContentLanguage();
            contentType = headers.getContentType();
        }
        stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s", stringToSign, cacheControl == null ? "" : cacheControl, contentDisposition == null ? "" : contentDisposition, contentEncoding == null ? "" : contentEncoding, contentLanguage == null ? "" : contentLanguage, contentType == null ? "" : contentType);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashHelper(stringToSign, client.getCredentials());
    }

    public static String generateUserDelegationSharedAccessSignatureHashForBlob(SharedAccessBlobPolicy policy, SharedAccessBlobHeaders headers, String resourceName, IPRange ipRange, SharedAccessProtocols protocols, UserDelegationKey delegationKey) {
        Utility.assertNotNullOrEmpty("resourceName", resourceName);
        Utility.assertNotNull("delegationKey", delegationKey);
        Utility.assertNotNull("delegationKey.SignedOid", delegationKey.getSignedOid());
        Utility.assertNotNull("delegationKey.SignedTid", delegationKey.getSignedTid());
        Utility.assertNotNull("delegationKey.SignedStart", delegationKey.getSignedStart());
        Utility.assertNotNull("delegationKey.SignedExpiry", delegationKey.getSignedExpiry());
        Utility.assertNotNullOrEmpty("delegationKey.SignedService", delegationKey.getSignedService());
        Utility.assertNotNullOrEmpty("delegationKey.SignedVersion", delegationKey.getSignedVersion());
        Utility.assertNotNullOrEmpty("delegationKey.Value", delegationKey.getValue());
        String cacheControl = "";
        String contentDisposition = "";
        String contentEncoding = "";
        String contentLanguage = "";
        String contentType = "";
        if (headers != null) {
            cacheControl = headers.getCacheControl();
            contentDisposition = headers.getContentDisposition();
            contentEncoding = headers.getContentEncoding();
            contentLanguage = headers.getContentLanguage();
            contentType = headers.getContentType();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", policy == null ? "" : policy.permissionsToString(), policy == null ? "" : Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()), policy == null ? "" : Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()), resourceName, delegationKey.getSignedOid(), delegationKey.getSignedTid(), Utility.getUTCTimeOrEmpty(delegationKey.getSignedStart()), Utility.getUTCTimeOrEmpty(delegationKey.getSignedExpiry()), delegationKey.getSignedService(), delegationKey.getSignedVersion(), ipRange == null ? "" : ipRange.toString(), protocols == null ? "" : protocols.toString(), "2018-11-09", "b", "", cacheControl, contentDisposition, contentEncoding, contentLanguage, contentType);
        try {
            return Base64.encode(StorageCredentialsHelper.computeHmac256(stringToSign.getBytes("UTF-8"), Base64.decode(delegationKey.getValue())));
        }
        catch (UnsupportedEncodingException | InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String generateSharedAccessSignatureHashForQueue(SharedAccessQueuePolicy policy, String accessPolicyIdentifier, String resourceName, IPRange ipRange, SharedAccessProtocols protocols, ServiceClient client) throws InvalidKeyException, StorageException {
        String stringToSign = SharedAccessSignatureHelper.generateSharedAccessSignatureStringToSign(policy, resourceName, ipRange, protocols, accessPolicyIdentifier);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashHelper(stringToSign, client.getCredentials());
    }

    public static String generateSharedAccessSignatureHashForTable(SharedAccessTablePolicy policy, String accessPolicyIdentifier, String resourceName, IPRange ipRange, SharedAccessProtocols protocols, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, ServiceClient client) throws InvalidKeyException, StorageException {
        String stringToSign = SharedAccessSignatureHelper.generateSharedAccessSignatureStringToSign(policy, resourceName, ipRange, protocols, accessPolicyIdentifier);
        stringToSign = String.format("%s\n%s\n%s\n%s\n%s", stringToSign, startPartitionKey == null ? "" : startPartitionKey, startRowKey == null ? "" : startRowKey, endPartitionKey == null ? "" : endPartitionKey, endRowKey == null ? "" : endRowKey);
        return SharedAccessSignatureHelper.generateSharedAccessSignatureHashHelper(stringToSign, client.getCredentials());
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(StorageUri completeUri) throws StorageException {
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        return SharedAccessSignatureHelper.parseQuery(queryParameters);
    }

    public static StorageCredentialsSharedAccessSignature parseQuery(HashMap<String, String[]> queryParams) throws StorageException {
        boolean sasParameterFound = false;
        ArrayList<String> removeList = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            String lowerKey = entry.getKey().toLowerCase(Utility.LOCALE_US);
            if (lowerKey.equals("sig")) {
                sasParameterFound = true;
                continue;
            }
            if (lowerKey.equals("comp")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (lowerKey.equals("restype")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (lowerKey.equals("snapshot")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (lowerKey.equals("api-version")) {
                removeList.add(entry.getKey());
                continue;
            }
            if (!lowerKey.equals("sharesnapshot")) continue;
            removeList.add(entry.getKey());
        }
        for (String removeParam : removeList) {
            queryParams.remove(removeParam);
        }
        if (sasParameterFound) {
            UriQueryBuilder builder = new UriQueryBuilder();
            StringBuilder values = new StringBuilder();
            for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
                values.setLength(0);
                for (int i = 0; i < entry.getValue().length; ++i) {
                    values.append(entry.getValue()[i]);
                    values.append(',');
                }
                values.deleteCharAt(values.length() - 1);
                SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, entry.getKey().toLowerCase(), values.toString());
            }
            return new StorageCredentialsSharedAccessSignature(builder.toString());
        }
        return null;
    }

    private static void addIfNotNullOrEmpty(UriQueryBuilder builder, String name, String val) throws StorageException {
        if (!Utility.isNullOrEmpty(val)) {
            builder.add(name, val);
        }
    }

    private static UriQueryBuilder generateSharedAccessSignatureHelper(SharedAccessPolicy policy, String startPartitionKey, String startRowKey, String endPartitionKey, String endRowKey, String accessPolicyIdentifier, String resourceType, IPRange ipRange, SharedAccessProtocols protocols, String tableName, String signature, SharedAccessHeaders headers) throws StorageException {
        Utility.assertNotNull("signature", signature);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        UriQueryBuilder builder = new UriQueryBuilder();
        builder.add("sv", "2018-11-09");
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sp", permissions);
        String startString = Utility.getUTCTimeOrEmpty(startTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "st", startString);
        String stopString = Utility.getUTCTimeOrEmpty(expiryTime);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "se", stopString);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "spk", startPartitionKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "srk", startRowKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "epk", endPartitionKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "erk", endRowKey);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "si", accessPolicyIdentifier);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sr", resourceType);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sip", ipRange != null ? ipRange.toString() : null);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "spr", protocols != null ? protocols.toString() : null);
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "tn", tableName);
        if (headers != null) {
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscc", headers.getCacheControl());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsct", headers.getContentType());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rsce", headers.getContentEncoding());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscl", headers.getContentLanguage());
            SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "rscd", headers.getContentDisposition());
        }
        SharedAccessSignatureHelper.addIfNotNullOrEmpty(builder, "sig", signature);
        return builder;
    }

    private static String generateSharedAccessSignatureHashHelper(String stringToSign, StorageCredentials creds) throws StorageException, InvalidKeyException {
        Utility.assertNotNull("credentials", creds);
        Logger.trace(null, "Signing %s", (Object)stringToSign);
        stringToSign = Utility.safeDecode(stringToSign);
        return StorageCredentialsHelper.computeHmac256(creds, stringToSign);
    }

    private static String generateSharedAccessSignatureStringToSign(SharedAccessPolicy policy, String resource, IPRange ipRange, SharedAccessProtocols protocols, String accessPolicyIdentifier) throws InvalidKeyException, StorageException {
        Utility.assertNotNullOrEmpty("resource", resource);
        String permissions = null;
        Date startTime = null;
        Date expiryTime = null;
        if (policy != null) {
            permissions = policy.permissionsToString();
            startTime = policy.getSharedAccessStartTime();
            expiryTime = policy.getSharedAccessExpiryTime();
        }
        String stringToSign = String.format("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s", permissions == null ? "" : permissions, Utility.getUTCTimeOrEmpty(startTime), Utility.getUTCTimeOrEmpty(expiryTime), resource, accessPolicyIdentifier == null ? "" : accessPolicyIdentifier, ipRange == null ? "" : ipRange.toString(), protocols == null ? "" : protocols.toString(), "2018-11-09");
        return stringToSign;
    }

    private SharedAccessSignatureHelper() {
    }
}

