/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.Constants;
import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.IPRange;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.SharedAccessProtocols;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.StorageErrorCode;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageLocation;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.BaseResponse;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.NetworkInputStream;
import com.microsoft.azure.storage.core.PathUtility;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import com.microsoft.azure.storage.core.StorageCredentialsHelper;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.StreamMd5AndLength;
import com.microsoft.azure.storage.core.UriQueryBuilder;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.core.WrappedByteArrayOutputStream;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileDirectory;
import com.microsoft.azure.storage.file.CloudFileShare;
import com.microsoft.azure.storage.file.CopyState;
import com.microsoft.azure.storage.file.FileAttributes;
import com.microsoft.azure.storage.file.FileHandle;
import com.microsoft.azure.storage.file.FileInputStream;
import com.microsoft.azure.storage.file.FileOutputStream;
import com.microsoft.azure.storage.file.FileProperties;
import com.microsoft.azure.storage.file.FileRange;
import com.microsoft.azure.storage.file.FileRangeHandler;
import com.microsoft.azure.storage.file.FileRangeOperationType;
import com.microsoft.azure.storage.file.FileRequest;
import com.microsoft.azure.storage.file.FileRequestOptions;
import com.microsoft.azure.storage.file.FileResponse;
import com.microsoft.azure.storage.file.HandleListHandler;
import com.microsoft.azure.storage.file.ListFileItem;
import com.microsoft.azure.storage.file.SharedAccessFileHeaders;
import com.microsoft.azure.storage.file.SharedAccessFilePolicy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public final class CloudFile
implements ListFileItem {
    protected int streamWriteSizeInBytes = 0x400000;
    protected int streamMinimumReadSizeInBytes = 0x400000;
    private CloudFileShare share;
    protected CloudFileDirectory parent;
    private String name;
    protected CloudFileClient fileServiceClient;
    private HashMap<String, String> metadata = new HashMap();
    private FileProperties properties = new FileProperties();
    private StorageUri storageUri;

    public CloudFile(URI fileAbsoluteUri) throws StorageException, URISyntaxException {
        this(new StorageUri(fileAbsoluteUri));
    }

    public CloudFile(StorageUri fileAbsoluteUri) throws StorageException, URISyntaxException {
        this(fileAbsoluteUri, null);
    }

    public CloudFile(URI fileAbsoluteUri, StorageCredentials credentials) throws StorageException, URISyntaxException {
        this(new StorageUri(fileAbsoluteUri), credentials);
    }

    public CloudFile(StorageUri fileAbsoluteUri, StorageCredentials credentials) throws StorageException, URISyntaxException {
        this.parseQueryAndVerify(fileAbsoluteUri, credentials);
    }

    public CloudFile(CloudFile otherFile) {
        this.metadata = new HashMap();
        this.properties = new FileProperties(otherFile.properties);
        if (otherFile.metadata != null) {
            for (String key : otherFile.metadata.keySet()) {
                this.metadata.put(key, otherFile.metadata.get(key));
            }
        }
        this.storageUri = otherFile.storageUri;
        this.share = otherFile.share;
        this.parent = otherFile.parent;
        this.fileServiceClient = otherFile.fileServiceClient;
        this.name = otherFile.name;
        this.setStreamMinimumReadSizeInBytes(otherFile.getStreamMinimumReadSizeInBytes());
        this.setStreamWriteSizeInBytes(otherFile.getStreamWriteSizeInBytes());
    }

    protected CloudFile(StorageUri uri, String fileName, CloudFileShare share) {
        Utility.assertNotNull("uri", uri);
        Utility.assertNotNull("fileName", fileName);
        Utility.assertNotNull("share", share);
        this.name = fileName;
        this.fileServiceClient = share.getServiceClient();
        this.share = share;
        this.storageUri = uri;
    }

    @DoesServiceRequest
    public final void abortCopy(String copyId) throws StorageException, URISyntaxException {
        this.abortCopy(copyId, null, null, null);
    }

    @DoesServiceRequest
    public final void abortCopy(String copyId, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.abortCopyImpl(copyId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> abortCopyImpl(final String copyId, final AccessCondition accessCondition, final FileRequestOptions options) {
        Utility.assertNotNull("copyId", copyId);
        StorageRequest<CloudFileClient, CloudFile, Void> putRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.abortCopy(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, copyId);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile parentObject, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final String startCopy(CloudBlob sourceBlob) throws StorageException, URISyntaxException {
        return this.startCopy(sourceBlob, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(CloudBlob sourceBlob, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceBlob", sourceBlob);
        URI source = sourceBlob.getSnapshotQualifiedUri();
        if (sourceBlob.getServiceClient() != null && sourceBlob.getServiceClient().getCredentials() != null) {
            source = sourceBlob.getServiceClient().getCredentials().transformUri(sourceBlob.getSnapshotQualifiedUri());
        }
        return this.startCopy(source, sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final String startCopy(CloudFile sourceFile) throws StorageException, URISyntaxException {
        return this.startCopy(sourceFile, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(CloudFile sourceFile, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceFile", sourceFile);
        return this.startCopy(sourceFile.getTransformedAddress(opContext).getPrimaryUri(), sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final String startCopy(URI source) throws StorageException, URISyntaxException {
        return this.startCopy(source, null, null, null, null);
    }

    @DoesServiceRequest
    public final String startCopy(URI source, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.startCopyImpl(source, sourceAccessCondition, destinationAccessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, String> startCopyImpl(final URI source, final AccessCondition sourceAccessCondition, final AccessCondition destinationAccessCondition, final FileRequestOptions options) {
        if (sourceAccessCondition != null && !Utility.isNullOrEmpty(sourceAccessCondition.getLeaseID())) {
            throw new IllegalArgumentException("A lease condition cannot be specified on the source of a copy.");
        }
        StorageRequest<CloudFileClient, CloudFile, String> putRequest = new StorageRequest<CloudFileClient, CloudFile, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.copyFrom(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, sourceAccessCondition, destinationAccessCondition, source.toASCIIString());
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFile file, OperationContext context) {
                FileRequest.addMetadata(connection, file.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public String preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                file.properties.setCopyState(FileResponse.getCopyState(this.getConnection()));
                return file.properties.getCopyState().getCopyId();
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void clearRange(long offset, long length) throws StorageException, URISyntaxException {
        this.clearRange(offset, length, null, null, null);
    }

    @DoesServiceRequest
    public void clearRange(long offset, long length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        FileRange range = new FileRange(offset, offset + length - 1L);
        this.putRangeInternal(range, FileRangeOperationType.CLEAR, null, length, null, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void create(long size) throws StorageException, URISyntaxException {
        this.create(size, null, null, null);
    }

    @DoesServiceRequest
    public void create(long size, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.createImpl(size, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> createImpl(final long size, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Void> putRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.putFile(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, file.properties, size);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFile file, OperationContext context) {
                FileRequest.addMetadata(connection, file.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void delete() throws StorageException, URISyntaxException {
        this.delete(null, null, null);
    }

    @DoesServiceRequest
    public final void delete(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.deleteImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final boolean deleteIfExists() throws StorageException, URISyntaxException {
        return this.deleteIfExists(null, null, null);
    }

    @DoesServiceRequest
    public final boolean deleteIfExists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        this.getShare().assertNoSnapshot();
        boolean exists = this.exists(true, accessCondition, options, opContext);
        if (exists) {
            try {
                this.delete(accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "ResourceNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> deleteImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Void> deleteRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.deleteFile(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        return deleteRequest;
    }

    @DoesServiceRequest
    public final void download(OutputStream outStream) throws StorageException {
        this.download(outStream, null, null, null);
    }

    @DoesServiceRequest
    public final void download(OutputStream outStream, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadToStreamImpl(null, null, outStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public final void downloadRange(long offset, Long length, OutputStream outStream) throws StorageException {
        this.downloadRange(offset, length, outStream, null, null, null);
    }

    @DoesServiceRequest
    public final void downloadRange(long offset, Long length, OutputStream outStream, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (offset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadToStreamImpl(offset, length, outStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    protected final int downloadRangeInternal(long fileOffset, Long length, byte[] buffer, int bufferOffset, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (bufferOffset < 0 || fileOffset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        WrappedByteArrayOutputStream outputStream = new WrappedByteArrayOutputStream(buffer, bufferOffset);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadToStreamImpl(fileOffset, length, outputStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
        return outputStream.getPosition();
    }

    @DoesServiceRequest
    public final int downloadRangeToByteArray(long offset, Long length, byte[] buffer, int bufferOffset) throws StorageException {
        return this.downloadRangeToByteArray(offset, length, buffer, bufferOffset, null, null, null);
    }

    @DoesServiceRequest
    public final int downloadRangeToByteArray(long offset, Long length, byte[] buffer, int bufferOffset, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("buffer", buffer);
        if (length != null && length + (long)bufferOffset > (long)buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        return this.downloadRangeInternal(offset, length, buffer, bufferOffset, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public final int downloadToByteArray(byte[] buffer, int bufferOffset) throws StorageException {
        return this.downloadToByteArray(buffer, bufferOffset, null, null, null);
    }

    @DoesServiceRequest
    public final int downloadToByteArray(byte[] buffer, int bufferOffset, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("buffer", buffer);
        if (bufferOffset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferOffset >= buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        WrappedByteArrayOutputStream outputStream = new WrappedByteArrayOutputStream(buffer, bufferOffset);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadToStreamImpl(null, null, outputStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
        return outputStream.getPosition();
    }

    public void downloadToFile(String path) throws StorageException, IOException {
        this.downloadToFile(path, null, null, null);
    }

    public void downloadToFile(String path, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new java.io.FileOutputStream(path));
        try {
            this.download(outputStream, accessCondition, options, opContext);
            ((OutputStream)outputStream).close();
        }
        catch (StorageException e) {
            this.deleteEmptyFileOnException(outputStream, path);
            throw e;
        }
        catch (IOException e) {
            this.deleteEmptyFileOnException(outputStream, path);
            throw e;
        }
    }

    private void deleteEmptyFileOnException(OutputStream outputStream, String path) {
        try {
            outputStream.close();
            File fileToDelete = new File(path);
            fileToDelete.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String downloadText() throws StorageException, IOException {
        return this.downloadText(null, null, null, null);
    }

    public String downloadText(String charsetName, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.download(baos, accessCondition, options, opContext);
        return charsetName == null ? baos.toString() : baos.toString(charsetName);
    }

    @DoesServiceRequest
    public ArrayList<FileRange> downloadFileRanges() throws StorageException {
        return this.downloadFileRanges(null, null, null);
    }

    @DoesServiceRequest
    public ArrayList<FileRange> downloadFileRanges(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadFileRangesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, ArrayList<FileRange>> downloadFileRangesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, ArrayList<FileRange>> getRequest = new StorageRequest<CloudFileClient, CloudFile, ArrayList<FileRange>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.getFileRanges(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, file.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ArrayList<FileRange> preProcessResponse(CloudFile parentObject, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ArrayList<FileRange> postProcessResponse(HttpURLConnection connection, CloudFile file, CloudFileClient client, OperationContext context, ArrayList<FileRange> storageObject) throws Exception {
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                file.updateLengthFromResponse(this.getConnection());
                return FileRangeHandler.getFileRanges(this.getConnection().getInputStream());
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    private final StorageRequest<CloudFileClient, CloudFile, Integer> downloadToStreamImpl(final Long fileOffset, final Long length, final OutputStream outStream, final AccessCondition accessCondition, final FileRequestOptions options, OperationContext opContext) {
        final long startingOffset = fileOffset == null ? 0L : fileOffset;
        StorageRequest<CloudFileClient, CloudFile, Integer> getRequest = new StorageRequest<CloudFileClient, CloudFile, Integer>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                if (this.getOffset() == null) {
                    this.setOffset(fileOffset);
                }
                if (this.getLength() == null) {
                    this.setLength(length);
                }
                return FileRequest.getFile(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, file.getShare().snapshotID, this.getOffset(), this.getLength(), options.getUseTransactionalContentMD5() != false && !this.getArePropertiesPopulated());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Integer preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 206 && this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                if (!this.getArePropertiesPopulated()) {
                    FileAttributes retrievedAttributes = FileResponse.getFileAttributes(this.getConnection(), file.getStorageUri());
                    file.properties = retrievedAttributes.getProperties();
                    file.metadata = retrievedAttributes.getMetadata();
                    this.setContentMD5(this.getConnection().getHeaderField("Content-MD5"));
                    if (!options.getDisableContentMD5Validation().booleanValue() && options.getUseTransactionalContentMD5().booleanValue() && Utility.isNullOrEmpty(this.getContentMD5())) {
                        throw new StorageException("MissingContentMD5Header", "ContentMD5 header is missing in the response.", 306, null, null);
                    }
                    this.setLockedETag(file.properties.getEtag());
                    this.setArePropertiesPopulated(true);
                } else if (this.getLockedETag() != null && !this.getLockedETag().equals(file.properties.getEtag())) {
                    throw new StorageException(StorageErrorCode.CONDITION_FAILED.toString(), "The conditionals specified for this operation did not match server.", 412, null, null);
                }
                this.setRequestLocationMode(this.getResult().getTargetLocation() == StorageLocation.PRIMARY ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.SECONDARY_ONLY);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer postProcessResponse(HttpURLConnection connection, CloudFile file, CloudFileClient client, OperationContext context, Integer storageObject) throws Exception {
                Boolean validateMD5 = options.getDisableContentMD5Validation() == false && !Utility.isNullOrEmpty(this.getContentMD5());
                String contentLength = connection.getHeaderField("Content-Length");
                long expectedLength = Long.parseLong(contentLength);
                Logger.info(context, String.format("Creating a NetworkInputStream and expecting to read %s bytes.", expectedLength));
                try (NetworkInputStream streamRef = new NetworkInputStream(connection.getInputStream(), expectedLength);){
                    StreamMd5AndLength descriptor = Utility.writeToOutputStream(streamRef, outStream, -1L, false, validateMD5, context, options, true, this, this.getCurrentDescriptor());
                    if (validateMD5.booleanValue() && !this.getContentMD5().equals(descriptor.getMd5())) {
                        throw new StorageException("InvalidMd5", String.format("File hash mismatch (integrity check failed), Expected value is %s, retrieved %s.", this.getContentMD5(), descriptor.getMd5()), 306, null, null);
                    }
                }
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                if (this.getETagLockCondition() == null && !Utility.isNullOrEmpty(this.getLockedETag())) {
                    AccessCondition etagLockCondition = new AccessCondition();
                    etagLockCondition.setIfMatch(this.getLockedETag());
                    if (accessCondition != null) {
                        etagLockCondition.setLeaseID(accessCondition.getLeaseID());
                    }
                    this.setETagLockCondition(etagLockCondition);
                }
                if (this.getCurrentRequestByteCount() > 0L) {
                    this.setOffset(startingOffset + this.getCurrentRequestByteCount());
                    if (length != null) {
                        this.setLength(length - this.getCurrentRequestByteCount());
                    }
                }
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public final void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @DoesServiceRequest
    public final void downloadAttributes(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> downloadAttributesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Void> getRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.getFileProperties(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, file.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                FileAttributes retrievedAttributes = FileResponse.getFileAttributes(this.getConnection(), file.getStorageUri());
                file.properties = retrievedAttributes.getProperties();
                file.metadata = retrievedAttributes.getMetadata();
                return null;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public final boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @DoesServiceRequest
    public final boolean exists(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private final boolean exists(boolean primaryOnly, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Boolean> getRequest = new StorageRequest<CloudFileClient, CloudFile, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.getFileProperties(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, file.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public Boolean preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    FileAttributes retrievedAttributes = FileResponse.getFileAttributes(this.getConnection(), file.getStorageUri());
                    file.properties = retrievedAttributes.getProperties();
                    file.metadata = retrievedAttributes.getMetadata();
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    public String generateSharedAccessSignature(SharedAccessFilePolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, null, groupPolicyIdentifier);
    }

    public String generateSharedAccessSignature(SharedAccessFilePolicy policy, SharedAccessFileHeaders headers, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, headers, groupPolicyIdentifier, null, null);
    }

    public String generateSharedAccessSignature(SharedAccessFilePolicy policy, SharedAccessFileHeaders headers, String groupPolicyIdentifier, IPRange ipRange, SharedAccessProtocols protocols) throws InvalidKeyException, StorageException {
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.fileServiceClient.getCredentials())) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlobAndFile(policy, headers, groupPolicyIdentifier, this.getCanonicalName(), ipRange, protocols, this.fileServiceClient, "f", null);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForBlobAndFile(policy, headers, groupPolicyIdentifier, "f", ipRange, protocols, signature);
        return builder.toString();
    }

    String getCanonicalName() {
        StringBuilder canonicalName = new StringBuilder("/");
        canonicalName.append("file");
        String rawPath = this.getUri().getRawPath();
        if (this.fileServiceClient.isUsePathStyleUris()) {
            canonicalName.append(rawPath);
        } else {
            canonicalName.append(PathUtility.getCanonicalPathFromCredentials(this.getServiceClient().getCredentials(), rawPath));
        }
        return canonicalName.toString();
    }

    public CopyState getCopyState() {
        return this.properties.getCopyState();
    }

    @DoesServiceRequest
    public final FileInputStream openRead() throws StorageException {
        return this.openRead(null, null, null);
    }

    @DoesServiceRequest
    public final FileInputStream openRead(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient, false);
        return new FileInputStream(this, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public FileOutputStream openWriteExisting() throws StorageException, URISyntaxException {
        return this.openOutputStreamInternal(null, null, null, null);
    }

    @DoesServiceRequest
    public FileOutputStream openWriteExisting(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        return this.openOutputStreamInternal(null, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public FileOutputStream openWriteNew(long length) throws StorageException, URISyntaxException {
        return this.openOutputStreamInternal(length, null, null, null);
    }

    @DoesServiceRequest
    public FileOutputStream openWriteNew(long length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        return this.openOutputStreamInternal(length, accessCondition, options, opContext);
    }

    private FileOutputStream openOutputStreamInternal(Long length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient, false);
        if (length != null) {
            this.create(length, accessCondition, options, opContext);
        } else {
            if (options.getStoreFileContentMD5().booleanValue()) {
                throw new IllegalArgumentException("MD5 cannot be calculated for an existing file because it would require reading the existing data. Please disable StoreFileContentMD5.");
            }
            this.downloadAttributes(accessCondition, options, opContext);
            length = this.getProperties().getLength();
        }
        if (accessCondition != null) {
            accessCondition = AccessCondition.generateLeaseCondition(accessCondition.getLeaseID());
        }
        return new FileOutputStream(this, length, accessCondition, options, opContext);
    }

    public void uploadFromByteArray(byte[] buffer, int offset, int length) throws StorageException, IOException, URISyntaxException {
        this.uploadFromByteArray(buffer, offset, length, null, null, null);
    }

    public void uploadFromByteArray(byte[] buffer, int offset, int length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, offset, length);
        this.upload(inputStream, length, accessCondition, options, opContext);
        inputStream.close();
    }

    public void uploadFromFile(String path) throws StorageException, IOException, URISyntaxException {
        this.uploadFromFile(path, null, null, null);
    }

    public void uploadFromFile(String path, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        File file = new File(path);
        long fileLength = file.length();
        BufferedInputStream inputStream = new BufferedInputStream(new java.io.FileInputStream(file));
        this.upload(inputStream, fileLength, accessCondition, options, opContext);
        ((InputStream)inputStream).close();
    }

    public void uploadText(String content) throws StorageException, IOException, URISyntaxException {
        this.uploadText(content, null, null, null, null);
    }

    public void uploadText(String content, String charsetName, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        byte[] bytes = charsetName == null ? content.getBytes() : content.getBytes(charsetName);
        this.uploadFromByteArray(bytes, 0, bytes.length, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    public void uploadRange(InputStream sourceStream, long offset, long length) throws StorageException, IOException, URISyntaxException {
        this.uploadRange(sourceStream, offset, length, null, null, null);
    }

    @DoesServiceRequest
    public void uploadRange(InputStream sourceStream, long offset, long length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        FileRange range = new FileRange(offset, offset + length - 1L);
        byte[] data = new byte[(int)length];
        String md5 = null;
        int count = 0;
        int total = 0;
        while ((long)total < length) {
            count = sourceStream.read(data, total, (int)Math.min(length - (long)total, Integer.MAX_VALUE));
            total += count;
        }
        if (options.getUseTransactionalContentMD5().booleanValue()) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                digest.update(data, 0, data.length);
                md5 = Base64.encode(digest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.putRangeInternal(range, FileRangeOperationType.UPDATE, data, length, md5, accessCondition, options, opContext);
    }

    @DoesServiceRequest
    private void putRangeInternal(FileRange range, FileRangeOperationType operationType, byte[] data, long length, String md5, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException {
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.putRangeImpl(range, operationType, data, length, md5, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> putRangeImpl(final FileRange range, final FileRangeOperationType operationType, final byte[] data, final long length, final String md5, final AccessCondition accessCondition, final FileRequestOptions options, final OperationContext opContext) {
        StorageRequest<CloudFileClient, CloudFile, Void> putRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                if (operationType == FileRangeOperationType.UPDATE) {
                    this.setSendStream(new ByteArrayInputStream(data));
                    this.setLength(length);
                }
                return FileRequest.putRange(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, opContext, accessCondition, range, operationType);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFile file, OperationContext context) {
                if (operationType == FileRangeOperationType.UPDATE && options.getUseTransactionalContentMD5().booleanValue()) {
                    connection.setRequestProperty("Content-MD5", md5);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                if (operationType == FileRangeOperationType.UPDATE) {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, length, context);
                } else {
                    StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
                }
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void uploadMetadata() throws StorageException, URISyntaxException {
        this.uploadMetadata(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadMetadata(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadMetadataImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> uploadMetadataImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Void> putRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.setFileMetadata(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudFile file, OperationContext context) {
                FileRequest.addMetadata(connection, file.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public final void uploadProperties() throws StorageException, URISyntaxException {
        this.uploadProperties(null, null, null);
    }

    @DoesServiceRequest
    public final void uploadProperties(AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.uploadPropertiesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> uploadPropertiesImpl(final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Void> putRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.setFileProperties(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, file.properties);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    public void resize(long size) throws StorageException, URISyntaxException {
        this.resize(size, null, null, null);
    }

    public void resize(long size, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.resizeImpl(size, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, Void> resizeImpl(final long size, final AccessCondition accessCondition, final FileRequestOptions options) {
        StorageRequest<CloudFileClient, CloudFile, Void> putRequest = new StorageRequest<CloudFileClient, CloudFile, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                return FileRequest.resize(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, size);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, context);
            }

            @Override
            public Void preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                file.getProperties().setLength(size);
                file.updateEtagAndLastModifiedFromResponse(this.getConnection());
                this.getResult().setRequestServiceEncrypted(BaseResponse.isServerRequestEncrypted(this.getConnection()));
                return null;
            }
        };
        return putRequest;
    }

    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length) throws StorageException, IOException, URISyntaxException {
        this.upload(sourceStream, length, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoesServiceRequest
    public void upload(InputStream sourceStream, long length, AccessCondition accessCondition, FileRequestOptions options, OperationContext opContext) throws StorageException, IOException, URISyntaxException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.getShare().assertNoSnapshot();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        if (length < 0L) {
            throw new IllegalArgumentException("File length must be greater than or equal to 0 bytes.");
        }
        if (sourceStream.markSupported()) {
            sourceStream.mark(0x10000000);
        }
        try (FileOutputStream streamRef = this.openWriteNew(length, accessCondition, options, opContext);){
            streamRef.write(sourceStream, length);
        }
    }

    @DoesServiceRequest
    public Iterable<FileHandle> listHandles() {
        return this.listHandles(null, null);
    }

    @DoesServiceRequest
    public Iterable<FileHandle> listHandles(FileRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudFileClient, CloudFile, FileHandle>(this.listHandlesSegmentedImpl(null, options, segmentedRequest), this.fileServiceClient, this, options.getRetryPolicyFactory(), opContext);
    }

    @DoesServiceRequest
    public ResultSegment<FileHandle> listHandlesSegmented() throws StorageException {
        return this.listHandlesSegmented(null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<FileHandle> listHandlesSegmented(Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.HANDLE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.listHandlesSegmentedImpl(maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, ResultSegment<FileHandle>> listHandlesSegmentedImpl(Integer maxResults, final FileRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.HANDLE);
        final ListingContext listingContext = new ListingContext(null, maxResults);
        StorageRequest<CloudFileClient, CloudFile, ResultSegment<FileHandle>> getRequest = new StorageRequest<CloudFileClient, CloudFile, ResultSegment<FileHandle>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return FileRequest.listHandles(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, listingContext, null, file.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<FileHandle> preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<FileHandle> postProcessResponse(HttpURLConnection connection, CloudFile file, CloudFileClient client, OperationContext context, ResultSegment<FileHandle> storageObject) throws Exception {
                ListResponse<FileHandle> response = HandleListHandler.getHandleList(this.getConnection().getInputStream());
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.HANDLE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<FileHandle> resSegment = new ResultSegment<FileHandle>(response.getResults(), response.getMaxResults(), newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    public ResultSegment<Integer> closeAllHandlesSegmented() throws StorageException {
        return this.closeAllHandlesSegmented(null, null, null);
    }

    public ResultSegment<Integer> closeAllHandlesSegmented(ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.HANDLE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.closeHandlesSegmentedImpl("*", options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    public ResultSegment<Integer> closeHandleSegmented(String handleID) throws StorageException {
        return this.closeHandleSegmented(handleID, null, null, null);
    }

    public ResultSegment<Integer> closeHandleSegmented(String handleID, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("handleID", handleID);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this.fileServiceClient);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.HANDLE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this.fileServiceClient, this, this.closeHandlesSegmentedImpl(handleID, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, CloudFile, ResultSegment<Integer>> closeHandlesSegmentedImpl(final String handleID, final FileRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.HANDLE);
        final ListingContext listingContext = new ListingContext(null, null);
        StorageRequest<CloudFileClient, CloudFile, ResultSegment<Integer>> putRequest = new StorageRequest<CloudFileClient, CloudFile, ResultSegment<Integer>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, CloudFile file, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return FileRequest.closeHandles(file.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, listingContext, handleID, null, file.getShare().snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<Integer> preProcessResponse(CloudFile file, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<Integer> postProcessResponse(HttpURLConnection connection, CloudFile file, CloudFileClient client, OperationContext context, ResultSegment<Integer> storageObject) throws Exception {
                ListResponse response = new ListResponse();
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.HANDLE_CLOSE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<Integer> resSegment = new ResultSegment<Integer>(response.getResults(), response.getMaxResults(), newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                resSegment.getResults().add(Integer.getInteger(connection.getRequestProperty("x-ms-number-of-handles-closed")));
                return resSegment;
            }
        };
        return putRequest;
    }

    protected static String getParentNameFromURI(StorageUri resourceAddress, CloudFileShare share) throws URISyntaxException {
        String parentName;
        Utility.assertNotNull("resourceAddress", resourceAddress);
        Utility.assertNotNull("share", share);
        String delimiter = "/";
        String shareName = share.getName() + delimiter;
        String relativeURIString = Utility.safeRelativize(share.getStorageUri().getPrimaryUri(), resourceAddress.getPrimaryUri());
        if (relativeURIString.endsWith(delimiter)) {
            relativeURIString = relativeURIString.substring(0, relativeURIString.length() - delimiter.length());
        }
        if (Utility.isNullOrEmpty(relativeURIString)) {
            parentName = null;
        } else {
            int lastDelimiterDex = relativeURIString.lastIndexOf(delimiter);
            if (lastDelimiterDex < 0) {
                parentName = "";
            } else {
                parentName = relativeURIString.substring(0, lastDelimiterDex);
                if (parentName != null && parentName.equals(shareName)) {
                    parentName = "";
                }
            }
        }
        return parentName;
    }

    private void parseQueryAndVerify(StorageUri completeUri, StorageCredentials credentials) throws StorageException, URISyntaxException {
        Utility.assertNotNull("completeUri", completeUri);
        if (!completeUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString()));
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        StorageCredentialsSharedAccessSignature parsedCredentials = SharedAccessSignatureHelper.parseQuery(completeUri);
        if (credentials != null && parsedCredentials != null) {
            throw new IllegalArgumentException("Cannot provide credentials as part of the address and as constructor parameter. Either pass in the address or use a different constructor.");
        }
        try {
            boolean usePathStyleUris = Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri());
            this.fileServiceClient = new CloudFileClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), credentials != null ? credentials : parsedCredentials);
            this.name = PathUtility.getFileNameFromURI(this.storageUri.getPrimaryUri(), usePathStyleUris);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        String[] snapshotIDs = queryParameters.get("sharesnapshot");
        if (snapshotIDs != null && snapshotIDs.length > 0) {
            this.getShare().snapshotID = snapshotIDs[0];
        }
    }

    protected void updateEtagAndLastModifiedFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    protected void updateLengthFromResponse(HttpURLConnection request) {
        String xContentLengthHeader = request.getHeaderField("x-ms-content-length");
        if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            this.getProperties().setLength(Long.parseLong(xContentLengthHeader));
        }
    }

    @Override
    public final CloudFileShare getShare() throws StorageException, URISyntaxException {
        if (this.share == null) {
            StorageUri shareUri = PathUtility.getShareURI(this.getStorageUri(), this.fileServiceClient.isUsePathStyleUris());
            this.share = new CloudFileShare(shareUri, this.fileServiceClient.getCredentials());
        }
        return this.share;
    }

    public final HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public final CloudFileDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudFile.getParentNameFromURI(this.getStorageUri(), this.getShare())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.share.getStorageUri(), parentName);
            this.parent = new CloudFileDirectory(parentURI, this.getServiceClient().getCredentials());
        }
        return this.parent;
    }

    public final FileProperties getProperties() {
        return this.properties;
    }

    public final CloudFileClient getServiceClient() {
        return this.fileServiceClient;
    }

    public final int getStreamWriteSizeInBytes() {
        return this.streamWriteSizeInBytes;
    }

    public final int getStreamMinimumReadSizeInBytes() {
        return this.streamMinimumReadSizeInBytes;
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    @Override
    public final URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    protected final void setShare(CloudFileShare share) {
        this.share = share;
    }

    public final void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected final void setProperties(FileProperties properties) {
        this.properties = properties;
    }

    protected void setStorageUri(StorageUri storageUri) {
        this.storageUri = storageUri;
    }

    public void setStreamMinimumReadSizeInBytes(int minimumReadSize) {
        if (minimumReadSize < 16384) {
            throw new IllegalArgumentException("MinimumReadSize");
        }
        this.streamMinimumReadSizeInBytes = minimumReadSize;
    }

    public void setStreamWriteSizeInBytes(int streamWriteSizeInBytes) {
        if (streamWriteSizeInBytes > Constants.MAX_FILE_WRITE_SIZE || streamWriteSizeInBytes < Constants.MIN_PERMITTED_FILE_WRITE_SIZE) {
            throw new IllegalArgumentException("StreamWriteSizeInBytes");
        }
        this.streamWriteSizeInBytes = streamWriteSizeInBytes;
    }

    protected final StorageUri getTransformedAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        return this.fileServiceClient.getCredentials().transformUri(this.getStorageUri(), opContext);
    }
}

