/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.blob.BlobCustomerProvidedKey;
import com.microsoft.azure.storage.blob.BlobEncryptionPolicy;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.core.Utility;

public final class BlobRequestOptions
extends RequestOptions {
    private Boolean absorbConditionalErrorsOnRetry = null;
    private Integer concurrentRequestCount = null;
    private Boolean useTransactionalContentMD5 = null;
    private Boolean storeBlobContentMD5 = null;
    private Boolean disableContentMD5Validation = null;
    private Integer singleBlobPutThresholdInBytes = null;
    private BlobEncryptionPolicy encryptionPolicy;
    private BlobCustomerProvidedKey customerProvidedKey;
    private boolean validateEncryptionPolicy = true;
    private boolean skipEtagLocking = false;

    public BlobRequestOptions() {
    }

    public BlobRequestOptions(BlobRequestOptions other) {
        super(other);
        if (other != null) {
            this.setAbsorbConditionalErrorsOnRetry(other.getAbsorbConditionalErrorsOnRetry());
            this.setConcurrentRequestCount(other.getConcurrentRequestCount());
            this.setUseTransactionalContentMD5(other.getUseTransactionalContentMD5());
            this.setStoreBlobContentMD5(other.getStoreBlobContentMD5());
            this.setDisableContentMD5Validation(other.getDisableContentMD5Validation());
            this.setSingleBlobPutThresholdInBytes(other.getSingleBlobPutThresholdInBytes());
            this.setEncryptionPolicy(other.getEncryptionPolicy());
            this.setCustomerProvidedKey(other.getCustomerProvidedKey());
            this.setValidateEncryptionPolicy(other.getValidateEncryptionPolicy());
            this.setSkipEtagLocking(other.getSkipEtagLocking());
        }
    }

    protected static final BlobRequestOptions populateAndApplyDefaults(BlobRequestOptions options, BlobType blobType, CloudBlobClient client) {
        return BlobRequestOptions.populateAndApplyDefaults(options, blobType, client, true);
    }

    protected static final BlobRequestOptions populateAndApplyDefaults(BlobRequestOptions options, BlobType blobType, CloudBlobClient client, boolean setStartTime) {
        BlobRequestOptions modifiedOptions = new BlobRequestOptions(options);
        BlobRequestOptions.populateRequestOptions(modifiedOptions, client.getDefaultRequestOptions(), setStartTime);
        BlobRequestOptions.applyDefaults(modifiedOptions, blobType);
        return modifiedOptions;
    }

    protected static void applyDefaults(BlobRequestOptions modifiedOptions, BlobType blobtype) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions);
        if (modifiedOptions.getAbsorbConditionalErrorsOnRetry() == null) {
            modifiedOptions.setAbsorbConditionalErrorsOnRetry(false);
        }
        if (blobtype == BlobType.APPEND_BLOB) {
            modifiedOptions.setConcurrentRequestCount(1);
        } else if (modifiedOptions.getConcurrentRequestCount() == null) {
            modifiedOptions.setConcurrentRequestCount(1);
        }
        if (modifiedOptions.getSingleBlobPutThresholdInBytes() == null) {
            modifiedOptions.setSingleBlobPutThresholdInBytes(0x8000000);
        }
        if (modifiedOptions.getUseTransactionalContentMD5() == null) {
            modifiedOptions.setUseTransactionalContentMD5(false);
        }
        if (modifiedOptions.getStoreBlobContentMD5() == null && blobtype != BlobType.UNSPECIFIED) {
            modifiedOptions.setStoreBlobContentMD5(blobtype == BlobType.BLOCK_BLOB);
        }
        if (modifiedOptions.getDisableContentMD5Validation() == null) {
            modifiedOptions.setDisableContentMD5Validation(false);
        }
    }

    private static void populateRequestOptions(BlobRequestOptions modifiedOptions, BlobRequestOptions clientOptions, boolean setStartTime) {
        RequestOptions.populateRequestOptions(modifiedOptions, clientOptions, setStartTime);
        if (modifiedOptions.getAbsorbConditionalErrorsOnRetry() == null) {
            modifiedOptions.setAbsorbConditionalErrorsOnRetry(clientOptions.getAbsorbConditionalErrorsOnRetry());
        }
        if (modifiedOptions.getConcurrentRequestCount() == null) {
            modifiedOptions.setConcurrentRequestCount(clientOptions.getConcurrentRequestCount());
        }
        if (modifiedOptions.getSingleBlobPutThresholdInBytes() == null) {
            modifiedOptions.setSingleBlobPutThresholdInBytes(clientOptions.getSingleBlobPutThresholdInBytes());
        }
        if (modifiedOptions.getUseTransactionalContentMD5() == null) {
            modifiedOptions.setUseTransactionalContentMD5(clientOptions.getUseTransactionalContentMD5());
        }
        if (modifiedOptions.getStoreBlobContentMD5() == null) {
            modifiedOptions.setStoreBlobContentMD5(clientOptions.getStoreBlobContentMD5());
        }
        if (modifiedOptions.getDisableContentMD5Validation() == null) {
            modifiedOptions.setDisableContentMD5Validation(clientOptions.getDisableContentMD5Validation());
        }
        if (modifiedOptions.getEncryptionPolicy() == null) {
            modifiedOptions.setEncryptionPolicy(clientOptions.getEncryptionPolicy());
        }
        if (modifiedOptions.getCustomerProvidedKey() == null) {
            modifiedOptions.setCustomerProvidedKey(clientOptions.getCustomerProvidedKey());
        }
    }

    public Boolean getAbsorbConditionalErrorsOnRetry() {
        return this.absorbConditionalErrorsOnRetry;
    }

    public Integer getConcurrentRequestCount() {
        return this.concurrentRequestCount;
    }

    public Boolean getUseTransactionalContentMD5() {
        return this.useTransactionalContentMD5;
    }

    public Boolean getStoreBlobContentMD5() {
        return this.storeBlobContentMD5;
    }

    public Boolean getDisableContentMD5Validation() {
        return this.disableContentMD5Validation;
    }

    public Integer getSingleBlobPutThresholdInBytes() {
        return this.singleBlobPutThresholdInBytes;
    }

    public BlobEncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public BlobCustomerProvidedKey getCustomerProvidedKey() {
        return this.customerProvidedKey;
    }

    protected boolean getValidateEncryptionPolicy() {
        return this.validateEncryptionPolicy;
    }

    public boolean getSkipEtagLocking() {
        return this.skipEtagLocking;
    }

    public void setAbsorbConditionalErrorsOnRetry(Boolean absorbConditionalErrorsOnRetry) {
        this.absorbConditionalErrorsOnRetry = absorbConditionalErrorsOnRetry;
    }

    public void setConcurrentRequestCount(Integer concurrentRequestCount) {
        this.concurrentRequestCount = concurrentRequestCount;
    }

    public void setUseTransactionalContentMD5(Boolean useTransactionalContentMD5) {
        this.useTransactionalContentMD5 = useTransactionalContentMD5;
    }

    public void setStoreBlobContentMD5(Boolean storeBlobContentMD5) {
        this.storeBlobContentMD5 = storeBlobContentMD5;
    }

    public void setDisableContentMD5Validation(Boolean disableContentMD5Validation) {
        this.disableContentMD5Validation = disableContentMD5Validation;
    }

    public void setSingleBlobPutThresholdInBytes(Integer singleBlobPutThresholdInBytes) {
        if (singleBlobPutThresholdInBytes != null && (singleBlobPutThresholdInBytes > 0x10000000 || singleBlobPutThresholdInBytes < 0x100000)) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "The argument is out of range. Argument name: %s, Value passed: %s.", "singleBlobPutThresholdInBytes", singleBlobPutThresholdInBytes.toString()));
        }
        this.singleBlobPutThresholdInBytes = singleBlobPutThresholdInBytes;
    }

    public void setEncryptionPolicy(BlobEncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public void setCustomerProvidedKey(BlobCustomerProvidedKey key) {
        this.customerProvidedKey = key;
    }

    protected void setValidateEncryptionPolicy(boolean validateEncryptionPolicy) {
        this.validateEncryptionPolicy = validateEncryptionPolicy;
    }

    public void setSkipEtagLocking(boolean skipEtagLocking) {
        this.skipEtagLocking = skipEtagLocking;
    }

    protected void assertNoEncryptionPolicyOrStrictMode() {
        if (this.getEncryptionPolicy() != null && this.getValidateEncryptionPolicy()) {
            throw new IllegalArgumentException("Encryption is not supported for the current operation. Please ensure that EncryptionPolicy is not set on RequestOptions.");
        }
        this.assertPolicyIfRequired();
    }

    protected void assertPolicyIfRequired() {
        if (this.requireEncryption() != null && this.requireEncryption().booleanValue() && this.getEncryptionPolicy() == null) {
            throw new IllegalArgumentException("Encryption Policy is mandatory when RequireEncryption is set to true. If you do not want to encrypt/decrypt data, please set RequireEncryption to false in request options.");
        }
    }
}

