/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.IProgressReceiver;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;

public final class ProgressReporter {
    public static Flowable<ByteBuffer> addProgressReporting(Flowable<ByteBuffer> data, IProgressReceiver progressReceiver) {
        if (progressReceiver == null) {
            return data;
        }
        SequentialProgressReporter tracker = new SequentialProgressReporter(progressReceiver);
        return tracker.addProgressReporting(data);
    }

    static Flowable<ByteBuffer> addParallelProgressReporting(Flowable<ByteBuffer> data, IProgressReceiver progressReceiver, Lock lock, AtomicLong totalProgress) {
        if (progressReceiver == null) {
            return data;
        }
        ParallelProgressReporter tracker = new ParallelProgressReporter(progressReceiver, lock, totalProgress);
        return tracker.addProgressReporting(data);
    }

    private static class ParallelProgressReporter
    extends ProgressReporterImpl {
        private final Lock transferLock;
        private AtomicLong totalProgress;

        ParallelProgressReporter(IProgressReceiver progressReceiver, Lock lock, AtomicLong totalProgress) {
            super(progressReceiver);
            this.transferLock = lock;
            this.totalProgress = totalProgress;
        }

        @Override
        public void reportProgress(long bytesTransferred) {
            super.reportProgress(bytesTransferred);
            this.transferLock.lock();
            this.progressReceiver.reportProgress(this.totalProgress.addAndGet(bytesTransferred));
            this.transferLock.unlock();
        }

        @Override
        public void rewindProgress() {
            this.totalProgress.addAndGet(-1L * this.blockProgress);
            super.rewindProgress();
        }
    }

    private static abstract class ProgressReporterImpl
    implements IProgressReceiver {
        long blockProgress = 0L;
        final IProgressReceiver progressReceiver;

        ProgressReporterImpl(IProgressReceiver progressReceiver) {
            this.progressReceiver = progressReceiver;
        }

        @Override
        public void reportProgress(long bytesTransferred) {
            this.blockProgress += bytesTransferred;
        }

        void rewindProgress() {
            this.blockProgress = 0L;
        }

        Flowable<ByteBuffer> addProgressReporting(Flowable<ByteBuffer> data) {
            return Single.just((Object)this).flatMapPublisher(progressReporter -> {
                progressReporter.rewindProgress();
                return data.doOnNext(buffer -> progressReporter.reportProgress(buffer.remaining()));
            });
        }
    }

    private static class SequentialProgressReporter
    extends ProgressReporterImpl {
        SequentialProgressReporter(IProgressReceiver progressReceiver) {
            super(progressReceiver);
        }

        @Override
        public void reportProgress(long bytesTransferred) {
            super.reportProgress(bytesTransferred);
            this.progressReceiver.reportProgress(this.blockProgress);
        }
    }
}

