/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.CommonRestResponse;
import com.microsoft.azure.storage.blob.DownloadResponse;
import com.microsoft.azure.storage.blob.ProgressReporter;
import com.microsoft.azure.storage.blob.StorageException;
import com.microsoft.azure.storage.blob.TransferManagerDownloadFromBlobOptions;
import com.microsoft.azure.storage.blob.TransferManagerUploadToBlockBlobOptions;
import com.microsoft.azure.storage.blob.UploadFromNRFBufferPool;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobDownloadHeaders;
import com.microsoft.azure.storage.blob.models.BlockBlobCommitBlockListResponse;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.StorageErrorCode;
import com.microsoft.rest.v2.util.FlowableUtil;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Publisher;

public final class TransferManager {
    public static final int BLOB_DEFAULT_DOWNLOAD_BLOCK_SIZE = 0x400000;

    public static Single<CommonRestResponse> uploadFileToBlockBlob(AsynchronousFileChannel file, BlockBlobURL blockBlobURL, int blockLength, Integer maxSingleShotSize, TransferManagerUploadToBlockBlobOptions options) throws IOException {
        Utility.assertNotNull("file", file);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        Utility.assertInBounds("blockLength", blockLength, 1L, 0x6400000L);
        if (maxSingleShotSize != null) {
            Utility.assertInBounds("maxSingleShotSize", maxSingleShotSize.intValue(), 0L, 0x10000000L);
        } else {
            maxSingleShotSize = 0x10000000;
        }
        TransferManagerUploadToBlockBlobOptions optionsReal = options == null ? new TransferManagerUploadToBlockBlobOptions() : options;
        AtomicLong totalProgress = new AtomicLong(0L);
        ReentrantLock progressLock = new ReentrantLock();
        if (file.size() < (long)maxSingleShotSize.intValue()) {
            Flowable<ByteBuffer> data = FlowableUtil.readFile((AsynchronousFileChannel)file);
            data = ProgressReporter.addProgressReporting(data, optionsReal.progressReceiver());
            return blockBlobURL.upload(data, file.size(), optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null).map(CommonRestResponse::createFromPutBlobResponse);
        }
        int numBlocks = TransferManager.calculateNumBlocks(file.size(), blockLength);
        if (numBlocks > 50000) {
            throw new IllegalArgumentException("The total blocks for this upload exceeds the maximum allowable limit.");
        }
        return Observable.range((int)0, (int)numBlocks).concatMapEager(i -> {
            int count = (int)Math.min((long)blockLength, file.size() - (long)i.intValue() * (long)blockLength);
            Flowable<ByteBuffer> data = FlowableUtil.readFile((AsynchronousFileChannel)file, (long)((long)i.intValue() * (long)blockLength), (long)count);
            data = ProgressReporter.addParallelProgressReporting(data, optionsReal.progressReceiver(), progressLock, totalProgress);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            return blockBlobURL.stageBlock(blockId, data, count, optionsReal.accessConditions().leaseAccessConditions(), null).map(x -> blockId).toObservable();
        }, optionsReal.parallelism(), 1).collectInto(new ArrayList(numBlocks), ArrayList::add).flatMap(ids -> blockBlobURL.commitBlockList((List<String>)ids, optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null)).map(CommonRestResponse::createFromPutBlockListResponse);
    }

    private static int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    public static Single<BlobDownloadHeaders> downloadBlobToFile(AsynchronousFileChannel file, BlobURL blobURL, BlobRange range, TransferManagerDownloadFromBlobOptions options) {
        BlobRange rangeReal = range == null ? new BlobRange() : range;
        TransferManagerDownloadFromBlobOptions optionsReal = options == null ? new TransferManagerDownloadFromBlobOptions() : options;
        Utility.assertNotNull("blobURL", blobURL);
        Utility.assertNotNull("file", file);
        ReentrantLock progressLock = new ReentrantLock();
        AtomicLong totalProgress = new AtomicLong(0L);
        Single<DownloadHelper> setupSingle = TransferManager.getSetupSingle(blobURL, rangeReal, optionsReal);
        return setupSingle.flatMap(helper -> {
            long newCount = helper.newCount;
            BlobAccessConditions realConditions = helper.realConditions;
            int numChunks = TransferManager.calculateNumBlocks(newCount, optionsReal.chunkSize());
            numChunks = numChunks == 0 ? 1 : numChunks;
            DownloadResponse initialResponse = helper.initialResponse;
            return Flowable.range((int)0, (int)numChunks).flatMapSingle(chunkNum -> {
                if (chunkNum == 0) {
                    return TransferManager.writeBodyToFile(initialResponse, file, 0L, optionsReal, progressLock, totalProgress);
                }
                long chunkSizeActual = Math.min(optionsReal.chunkSize(), newCount - (long)chunkNum.intValue() * optionsReal.chunkSize());
                BlobRange chunkRange = new BlobRange().withOffset(rangeReal.offset() + (long)chunkNum.intValue() * optionsReal.chunkSize()).withCount(chunkSizeActual);
                return blobURL.download(chunkRange, realConditions, false, null).flatMap(response -> TransferManager.writeBodyToFile(response, file, chunkNum.intValue(), optionsReal, progressLock, totalProgress));
            }, false, optionsReal.parallelism()).lastOrError();
        });
    }

    private static Single<DownloadHelper> getSetupSingle(BlobURL blobURL, BlobRange r, TransferManagerDownloadFromBlobOptions o) {
        long initialChunkSize = r.count() != null && r.count() < o.chunkSize() ? r.count().longValue() : o.chunkSize();
        return blobURL.download(new BlobRange().withOffset(r.offset()).withCount(initialChunkSize), o.accessConditions(), false, null).map(response -> {
            BlobAccessConditions newConditions = TransferManager.setEtag(o.accessConditions(), response.headers().eTag());
            long totalLength = TransferManager.extractTotalBlobLength(response.headers().contentRange());
            long newCount = r.count() == null || r.count() > totalLength - r.offset() ? totalLength - r.offset() : r.count();
            return new DownloadHelper(newCount, newConditions, (DownloadResponse)response);
        }).onErrorResumeNext(throwable -> {
            if (throwable instanceof StorageException && ((StorageException)((Object)((Object)throwable))).errorCode() == StorageErrorCode.INVALID_RANGE && TransferManager.extractTotalBlobLength(((StorageException)((Object)((Object)throwable))).response().headers().value("Content-Range")) == 0L) {
                return blobURL.download(new BlobRange().withOffset(0L).withCount(0L), o.accessConditions(), false, null).map(response -> {
                    if (response.statusCode() != 200) {
                        throw new IllegalStateException("Blob was modified mid download. It was originally 0 bytes and is now larger.");
                    }
                    return new DownloadHelper(0L, o.accessConditions(), (DownloadResponse)response);
                });
            }
            return Single.error((Throwable)throwable);
        });
    }

    private static BlobAccessConditions setEtag(BlobAccessConditions accessConditions, String etag) {
        return new BlobAccessConditions().withModifiedAccessConditions(new ModifiedAccessConditions().withIfModifiedSince(accessConditions.modifiedAccessConditions().ifModifiedSince()).withIfUnmodifiedSince(accessConditions.modifiedAccessConditions().ifUnmodifiedSince()).withIfMatch(etag).withIfNoneMatch(accessConditions.modifiedAccessConditions().ifNoneMatch())).withLeaseAccessConditions(accessConditions.leaseAccessConditions());
    }

    private static Single<BlobDownloadHeaders> writeBodyToFile(DownloadResponse response, AsynchronousFileChannel file, long chunkNum, TransferManagerDownloadFromBlobOptions optionsReal, Lock progressLock, AtomicLong totalProgress) {
        Flowable<ByteBuffer> data = response.body(optionsReal.reliableDownloadOptionsPerBlock());
        data = ProgressReporter.addParallelProgressReporting(data, optionsReal.progressReceiver(), progressLock, totalProgress);
        return FlowableUtil.writeFile(data, (AsynchronousFileChannel)file, (long)(chunkNum * optionsReal.chunkSize())).andThen((SingleSource)Single.just((Object)response.headers()));
    }

    private static long extractTotalBlobLength(String contentRange) {
        return Long.parseLong(contentRange.split("/")[1]);
    }

    public static Single<BlockBlobCommitBlockListResponse> uploadFromNonReplayableFlowable(Flowable<ByteBuffer> source, BlockBlobURL blockBlobURL, int blockSize, int numBuffers, TransferManagerUploadToBlockBlobOptions options) {
        Utility.assertNotNull("source", source);
        Utility.assertNotNull("blockBlobURL", blockBlobURL);
        TransferManagerUploadToBlockBlobOptions optionsReal = options == null ? new TransferManagerUploadToBlockBlobOptions() : options;
        AtomicLong totalProgress = new AtomicLong(0L);
        ReentrantLock progressLock = new ReentrantLock();
        UploadFromNRFBufferPool pool = new UploadFromNRFBufferPool(numBuffers, blockSize);
        Flowable chunkedSource = source.flatMap(buffer -> {
            if (buffer.remaining() <= blockSize) {
                return Flowable.just((Object)buffer);
            }
            ArrayList<ByteBuffer> smallerChunks = new ArrayList<ByteBuffer>();
            int i = 0;
            while ((double)i < Math.ceil((double)buffer.remaining() / (double)blockSize)) {
                ByteBuffer duplicate = buffer.duplicate();
                duplicate.position(i * blockSize);
                duplicate.limit(Math.min(duplicate.limit(), (i + 1) * blockSize));
                smallerChunks.add(duplicate);
                ++i;
            }
            return Flowable.fromIterable(smallerChunks);
        }, false, 1);
        return chunkedSource.flatMap(pool::write, false, 1).concatWith((Publisher)Flowable.defer(pool::flush)).concatMapEager(buffer -> {
            Flowable<ByteBuffer> data = ProgressReporter.addParallelProgressReporting((Flowable<ByteBuffer>)Flowable.just((Object)buffer), optionsReal.progressReceiver(), progressLock, totalProgress);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes());
            return blockBlobURL.stageBlock(blockId, data, buffer.remaining(), optionsReal.accessConditions().leaseAccessConditions(), null).map(x -> {
                pool.returnBuffer((ByteBuffer)buffer);
                return blockId;
            }).toFlowable();
        }, optionsReal.parallelism(), 1).collectInto(new ArrayList(), ArrayList::add).flatMap(ids -> blockBlobURL.commitBlockList((List<String>)ids, optionsReal.httpHeaders(), optionsReal.metadata(), optionsReal.accessConditions(), null));
    }

    private static final class DownloadHelper {
        final long newCount;
        final BlobAccessConditions realConditions;
        final DownloadResponse initialResponse;

        DownloadHelper(long newCount, BlobAccessConditions realConditions, DownloadResponse initialResponse) {
            this.newCount = newCount;
            this.realConditions = realConditions;
            this.initialResponse = initialResponse;
        }
    }
}

