/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.config;

import com.microsoft.azure.toolkit.lib.appservice.config.AppServiceConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ApplicationInsightsConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.ContainerAppFunctionConfiguration;
import com.microsoft.azure.toolkit.lib.appservice.model.FlexConsumptionConfiguration;
import com.microsoft.azure.toolkit.lib.containerapps.environment.ContainerAppsEnvironmentDraft;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspaceConfig;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;

public class FunctionAppConfig
extends AppServiceConfig {
    private String storageAccountName;
    private String storageAccountResourceGroup;
    private String environment;
    private ContainerAppsEnvironmentDraft.Config environmentConfig;
    private ContainerAppFunctionConfiguration containerConfiguration;
    private LogAnalyticsWorkspaceConfig workspaceConfig;
    private Boolean enableDistributedTracing;
    private ApplicationInsightsConfig applicationInsightsConfig;
    private FlexConsumptionConfiguration flexConsumptionConfiguration;

    public String environment() {
        return Optional.ofNullable(this.environmentConfig).map(ContainerAppsEnvironmentDraft.Config::getName).orElse(this.environment);
    }

    public FunctionAppConfig environment(String environment) {
        this.environment = environment;
        this.environmentConfig = new ContainerAppsEnvironmentDraft.Config();
        this.environmentConfig.setName(environment);
        return this;
    }

    public boolean disableAppInsights() {
        return Optional.ofNullable(this.applicationInsightsConfig).map(c -> BooleanUtils.isTrue((Boolean)c.getDisableAppInsights())).orElse(false);
    }

    @Nullable
    public String appInsightsInstance() {
        return Optional.ofNullable(this.applicationInsightsConfig).filter(c -> BooleanUtils.isNotTrue((Boolean)c.getDisableAppInsights())).map(ApplicationInsightsConfig::getName).orElse(null);
    }

    @Nullable
    public String appInsightsKey() {
        return Optional.ofNullable(this.applicationInsightsConfig).filter(c -> BooleanUtils.isNotTrue((Boolean)c.getDisableAppInsights())).map(ApplicationInsightsConfig::getInstrumentationKey).orElse(null);
    }

    @Nullable
    public LogAnalyticsWorkspaceConfig workspaceConfig() {
        return Optional.ofNullable(this.applicationInsightsConfig).filter(c -> BooleanUtils.isNotTrue((Boolean)c.getDisableAppInsights())).map(ApplicationInsightsConfig::getWorkspaceConfig).orElse(null);
    }

    public FunctionAppConfig disableAppInsights(Boolean disableAppInsights) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setDisableAppInsights(disableAppInsights);
        return this;
    }

    @Nonnull
    public FunctionAppConfig appInsightsInstance(String appInsightsInstance) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setName(appInsightsInstance);
        return this;
    }

    @Nonnull
    public FunctionAppConfig appInsightsKey(String key) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setInstrumentationKey(key);
        return this;
    }

    @Nonnull
    public FunctionAppConfig workspaceConfig(LogAnalyticsWorkspaceConfig workspaceConfig) {
        this.applicationInsightsConfig = Optional.ofNullable(this.applicationInsightsConfig).orElseGet(ApplicationInsightsConfig::new);
        this.applicationInsightsConfig.setWorkspaceConfig(workspaceConfig);
        return this;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public String getStorageAccountResourceGroup() {
        return this.storageAccountResourceGroup;
    }

    public Boolean getEnableDistributedTracing() {
        return this.enableDistributedTracing;
    }

    public ApplicationInsightsConfig getApplicationInsightsConfig() {
        return this.applicationInsightsConfig;
    }

    public FlexConsumptionConfiguration getFlexConsumptionConfiguration() {
        return this.flexConsumptionConfiguration;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public void setStorageAccountResourceGroup(String storageAccountResourceGroup) {
        this.storageAccountResourceGroup = storageAccountResourceGroup;
    }

    public void setEnableDistributedTracing(Boolean enableDistributedTracing) {
        this.enableDistributedTracing = enableDistributedTracing;
    }

    public void setApplicationInsightsConfig(ApplicationInsightsConfig applicationInsightsConfig) {
        this.applicationInsightsConfig = applicationInsightsConfig;
    }

    public void setFlexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.flexConsumptionConfiguration = flexConsumptionConfiguration;
    }

    protected FunctionAppConfig(FunctionAppConfigBuilder<?, ?> b) {
        super(b);
        this.storageAccountName = ((FunctionAppConfigBuilder)b).storageAccountName;
        this.storageAccountResourceGroup = ((FunctionAppConfigBuilder)b).storageAccountResourceGroup;
        this.environment = ((FunctionAppConfigBuilder)b).environment;
        this.environmentConfig = ((FunctionAppConfigBuilder)b).environmentConfig;
        this.containerConfiguration = ((FunctionAppConfigBuilder)b).containerConfiguration;
        this.workspaceConfig = ((FunctionAppConfigBuilder)b).workspaceConfig;
        this.enableDistributedTracing = ((FunctionAppConfigBuilder)b).enableDistributedTracing;
        this.applicationInsightsConfig = ((FunctionAppConfigBuilder)b).applicationInsightsConfig;
        this.flexConsumptionConfiguration = ((FunctionAppConfigBuilder)b).flexConsumptionConfiguration;
    }

    public static FunctionAppConfigBuilder<?, ?> builder() {
        return new FunctionAppConfigBuilderImpl();
    }

    public FunctionAppConfigBuilder<?, ?> toBuilder() {
        return new FunctionAppConfigBuilderImpl().$fillValuesFrom(this);
    }

    public String storageAccountName() {
        return this.storageAccountName;
    }

    public String storageAccountResourceGroup() {
        return this.storageAccountResourceGroup;
    }

    public ContainerAppsEnvironmentDraft.Config environmentConfig() {
        return this.environmentConfig;
    }

    public ContainerAppFunctionConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    public Boolean enableDistributedTracing() {
        return this.enableDistributedTracing;
    }

    public ApplicationInsightsConfig applicationInsightsConfig() {
        return this.applicationInsightsConfig;
    }

    public FlexConsumptionConfiguration flexConsumptionConfiguration() {
        return this.flexConsumptionConfiguration;
    }

    public FunctionAppConfig storageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
        return this;
    }

    public FunctionAppConfig storageAccountResourceGroup(String storageAccountResourceGroup) {
        this.storageAccountResourceGroup = storageAccountResourceGroup;
        return this;
    }

    public FunctionAppConfig environmentConfig(ContainerAppsEnvironmentDraft.Config environmentConfig) {
        this.environmentConfig = environmentConfig;
        return this;
    }

    public FunctionAppConfig containerConfiguration(ContainerAppFunctionConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    public FunctionAppConfig enableDistributedTracing(Boolean enableDistributedTracing) {
        this.enableDistributedTracing = enableDistributedTracing;
        return this;
    }

    public FunctionAppConfig applicationInsightsConfig(ApplicationInsightsConfig applicationInsightsConfig) {
        this.applicationInsightsConfig = applicationInsightsConfig;
        return this;
    }

    public FunctionAppConfig flexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.flexConsumptionConfiguration = flexConsumptionConfiguration;
        return this;
    }

    public FunctionAppConfig() {
    }

    public FunctionAppConfig(String storageAccountName, String storageAccountResourceGroup, String environment, ContainerAppsEnvironmentDraft.Config environmentConfig, ContainerAppFunctionConfiguration containerConfiguration, LogAnalyticsWorkspaceConfig workspaceConfig, Boolean enableDistributedTracing, ApplicationInsightsConfig applicationInsightsConfig, FlexConsumptionConfiguration flexConsumptionConfiguration) {
        this.storageAccountName = storageAccountName;
        this.storageAccountResourceGroup = storageAccountResourceGroup;
        this.environment = environment;
        this.environmentConfig = environmentConfig;
        this.containerConfiguration = containerConfiguration;
        this.workspaceConfig = workspaceConfig;
        this.enableDistributedTracing = enableDistributedTracing;
        this.applicationInsightsConfig = applicationInsightsConfig;
        this.flexConsumptionConfiguration = flexConsumptionConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionAppConfig)) {
            return false;
        }
        FunctionAppConfig other = (FunctionAppConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enableDistributedTracing = this.enableDistributedTracing();
        Boolean other$enableDistributedTracing = other.enableDistributedTracing();
        if (this$enableDistributedTracing == null ? other$enableDistributedTracing != null : !((Object)this$enableDistributedTracing).equals(other$enableDistributedTracing)) {
            return false;
        }
        String this$storageAccountName = this.storageAccountName();
        String other$storageAccountName = other.storageAccountName();
        if (this$storageAccountName == null ? other$storageAccountName != null : !this$storageAccountName.equals(other$storageAccountName)) {
            return false;
        }
        String this$storageAccountResourceGroup = this.storageAccountResourceGroup();
        String other$storageAccountResourceGroup = other.storageAccountResourceGroup();
        if (this$storageAccountResourceGroup == null ? other$storageAccountResourceGroup != null : !this$storageAccountResourceGroup.equals(other$storageAccountResourceGroup)) {
            return false;
        }
        String this$environment = this.environment();
        String other$environment = other.environment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        ContainerAppsEnvironmentDraft.Config this$environmentConfig = this.environmentConfig();
        ContainerAppsEnvironmentDraft.Config other$environmentConfig = other.environmentConfig();
        if (this$environmentConfig == null ? other$environmentConfig != null : !this$environmentConfig.equals(other$environmentConfig)) {
            return false;
        }
        ContainerAppFunctionConfiguration this$containerConfiguration = this.containerConfiguration();
        ContainerAppFunctionConfiguration other$containerConfiguration = other.containerConfiguration();
        if (this$containerConfiguration == null ? other$containerConfiguration != null : !((Object)this$containerConfiguration).equals(other$containerConfiguration)) {
            return false;
        }
        LogAnalyticsWorkspaceConfig this$workspaceConfig = this.workspaceConfig();
        LogAnalyticsWorkspaceConfig other$workspaceConfig = other.workspaceConfig();
        if (this$workspaceConfig == null ? other$workspaceConfig != null : !this$workspaceConfig.equals(other$workspaceConfig)) {
            return false;
        }
        ApplicationInsightsConfig this$applicationInsightsConfig = this.applicationInsightsConfig();
        ApplicationInsightsConfig other$applicationInsightsConfig = other.applicationInsightsConfig();
        if (this$applicationInsightsConfig == null ? other$applicationInsightsConfig != null : !this$applicationInsightsConfig.equals(other$applicationInsightsConfig)) {
            return false;
        }
        FlexConsumptionConfiguration this$flexConsumptionConfiguration = this.flexConsumptionConfiguration();
        FlexConsumptionConfiguration other$flexConsumptionConfiguration = other.flexConsumptionConfiguration();
        return !(this$flexConsumptionConfiguration == null ? other$flexConsumptionConfiguration != null : !((Object)this$flexConsumptionConfiguration).equals(other$flexConsumptionConfiguration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FunctionAppConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enableDistributedTracing = this.enableDistributedTracing();
        result = result * 59 + ($enableDistributedTracing == null ? 43 : ((Object)$enableDistributedTracing).hashCode());
        String $storageAccountName = this.storageAccountName();
        result = result * 59 + ($storageAccountName == null ? 43 : $storageAccountName.hashCode());
        String $storageAccountResourceGroup = this.storageAccountResourceGroup();
        result = result * 59 + ($storageAccountResourceGroup == null ? 43 : $storageAccountResourceGroup.hashCode());
        String $environment = this.environment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        ContainerAppsEnvironmentDraft.Config $environmentConfig = this.environmentConfig();
        result = result * 59 + ($environmentConfig == null ? 43 : $environmentConfig.hashCode());
        ContainerAppFunctionConfiguration $containerConfiguration = this.containerConfiguration();
        result = result * 59 + ($containerConfiguration == null ? 43 : ((Object)$containerConfiguration).hashCode());
        LogAnalyticsWorkspaceConfig $workspaceConfig = this.workspaceConfig();
        result = result * 59 + ($workspaceConfig == null ? 43 : $workspaceConfig.hashCode());
        ApplicationInsightsConfig $applicationInsightsConfig = this.applicationInsightsConfig();
        result = result * 59 + ($applicationInsightsConfig == null ? 43 : $applicationInsightsConfig.hashCode());
        FlexConsumptionConfiguration $flexConsumptionConfiguration = this.flexConsumptionConfiguration();
        result = result * 59 + ($flexConsumptionConfiguration == null ? 43 : ((Object)$flexConsumptionConfiguration).hashCode());
        return result;
    }

    private static final class FunctionAppConfigBuilderImpl
    extends FunctionAppConfigBuilder<FunctionAppConfig, FunctionAppConfigBuilderImpl> {
        private FunctionAppConfigBuilderImpl() {
        }

        @Override
        protected FunctionAppConfigBuilderImpl self() {
            return this;
        }

        @Override
        public FunctionAppConfig build() {
            return new FunctionAppConfig(this);
        }
    }

    public static abstract class FunctionAppConfigBuilder<C extends FunctionAppConfig, B extends FunctionAppConfigBuilder<C, B>>
    extends AppServiceConfig.AppServiceConfigBuilder<C, B> {
        private String storageAccountName;
        private String storageAccountResourceGroup;
        private String environment;
        private ContainerAppsEnvironmentDraft.Config environmentConfig;
        private ContainerAppFunctionConfiguration containerConfiguration;
        private LogAnalyticsWorkspaceConfig workspaceConfig;
        private Boolean enableDistributedTracing;
        private ApplicationInsightsConfig applicationInsightsConfig;
        private FlexConsumptionConfiguration flexConsumptionConfiguration;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FunctionAppConfigBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FunctionAppConfig instance, FunctionAppConfigBuilder<?, ?> b) {
            b.storageAccountName(instance.storageAccountName);
            b.storageAccountResourceGroup(instance.storageAccountResourceGroup);
            b.environment(instance.environment);
            b.environmentConfig(instance.environmentConfig);
            b.containerConfiguration(instance.containerConfiguration);
            b.workspaceConfig(instance.workspaceConfig);
            b.enableDistributedTracing(instance.enableDistributedTracing);
            b.applicationInsightsConfig(instance.applicationInsightsConfig);
            b.flexConsumptionConfiguration(instance.flexConsumptionConfiguration);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B storageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
            return (B)this.self();
        }

        public B storageAccountResourceGroup(String storageAccountResourceGroup) {
            this.storageAccountResourceGroup = storageAccountResourceGroup;
            return (B)this.self();
        }

        public B environment(String environment) {
            this.environment = environment;
            return (B)this.self();
        }

        public B environmentConfig(ContainerAppsEnvironmentDraft.Config environmentConfig) {
            this.environmentConfig = environmentConfig;
            return (B)this.self();
        }

        public B containerConfiguration(ContainerAppFunctionConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return (B)this.self();
        }

        public B workspaceConfig(LogAnalyticsWorkspaceConfig workspaceConfig) {
            this.workspaceConfig = workspaceConfig;
            return (B)this.self();
        }

        public B enableDistributedTracing(Boolean enableDistributedTracing) {
            this.enableDistributedTracing = enableDistributedTracing;
            return (B)this.self();
        }

        public B applicationInsightsConfig(ApplicationInsightsConfig applicationInsightsConfig) {
            this.applicationInsightsConfig = applicationInsightsConfig;
            return (B)this.self();
        }

        public B flexConsumptionConfiguration(FlexConsumptionConfiguration flexConsumptionConfiguration) {
            this.flexConsumptionConfiguration = flexConsumptionConfiguration;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FunctionAppConfig.FunctionAppConfigBuilder(super=" + super.toString() + ", storageAccountName=" + this.storageAccountName + ", storageAccountResourceGroup=" + this.storageAccountResourceGroup + ", environment=" + this.environment + ", environmentConfig=" + this.environmentConfig + ", containerConfiguration=" + this.containerConfiguration + ", workspaceConfig=" + this.workspaceConfig + ", enableDistributedTracing=" + this.enableDistributedTracing + ", applicationInsightsConfig=" + this.applicationInsightsConfig + ", flexConsumptionConfiguration=" + this.flexConsumptionConfiguration + ")";
        }
    }
}

