/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.deploy;

import com.microsoft.azure.toolkit.lib.appservice.model.CsmDeploymentStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployOptions;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppArtifact;
import com.microsoft.azure.toolkit.lib.appservice.utils.Utils;
import java.io.File;

public interface IOneDeploy {
    default public void deploy(File targetFile) {
        this.deploy(Utils.getDeployTypeByFileExtension(targetFile), targetFile);
    }

    default public void deploy(DeployType deployType, File targetFile) {
        this.deploy(deployType, targetFile, (String)null);
    }

    default public void deploy(WebAppArtifact webAppArtifact) {
        this.deploy(webAppArtifact.getDeployType(), webAppArtifact.getFile(), webAppArtifact.getPath());
    }

    default public void deploy(DeployType deployType, File targetFile, String targetPath) {
        this.deploy(deployType, targetFile, DeployOptions.builder().path(targetPath).build());
    }

    public void deploy(DeployType var1, File var2, DeployOptions var3);

    public KuduDeploymentResult pushDeploy(DeployType var1, File var2, DeployOptions var3);

    public CsmDeploymentStatus getDeploymentStatus(String var1);
}

