/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.file;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.file.IFileClient;
import com.microsoft.azure.toolkit.lib.appservice.file.IProcessClient;
import com.microsoft.azure.toolkit.lib.appservice.model.AppServiceFile;
import com.microsoft.azure.toolkit.lib.appservice.model.CommandOutput;
import com.microsoft.azure.toolkit.lib.appservice.model.ProcessInfo;
import com.microsoft.azure.toolkit.lib.appservice.model.TunnelStatus;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.utils.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class AppServiceKuduClient
implements IFileClient,
IProcessClient {
    public static final String DEFAULT_TOOL_NAME = "Azure-Java-Toolkit";
    public static final String DEPLOYMENT_STATUS_TIMEOUT = "Timeout reached by the command, however, the deployment operation is still on-going. Navigate to your scm site to check the deployment status";
    private final String host;
    private final KuduService kuduService;
    private final AppServiceAppBase<?, ?, ?> app;
    private static final String HOME_PREFIX = "/home";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    private AppServiceKuduClient(String host, KuduService kuduService, AppServiceAppBase<?, ?, ?> app) {
        this.host = host;
        this.app = app;
        this.kuduService = kuduService;
    }

    public static AppServiceKuduClient getClient(@Nonnull WebAppBase webAppBase, @Nonnull AppServiceAppBase<?, ?, ?> appService) {
        if (webAppBase.defaultHostname() == null) {
            throw new AzureToolkitRuntimeException("Cannot initialize kudu client before web app is created");
        }
        String host = webAppBase.defaultHostname().toLowerCase(Locale.ROOT).replace("http://", "").replace("https://", "");
        String[] parts = host.split("\\.", 2);
        host = parts[0] + ".scm." + parts[1];
        host = "https://" + host;
        KuduService kuduService = (KuduService)RestProxy.create(KuduService.class, (HttpPipeline)((AppServiceManager)webAppBase.manager()).httpPipeline());
        return new AppServiceKuduClient(host, kuduService, appService);
    }

    @Override
    public Flux<ByteBuffer> getFileContent(String path) {
        String fixedPath = StringUtils.removeStart((String)path, (String)HOME_PREFIX);
        return this.kuduService.getFileContent(this.host, fixedPath).flatMapMany(StreamResponse::getValue);
    }

    @Override
    public List<? extends AppServiceFile> getFilesInDirectory(String dir) {
        String fixedDir = StringUtils.removeStart((String)dir, (String)HOME_PREFIX);
        return ((List)((Response)Objects.requireNonNull(this.kuduService.getFilesInDirectory(this.host, fixedDir).block())).getValue()).stream().filter(file -> !"text/xml".equals(file.getMime()) || !file.getName().contains("LogFiles-kudu-trace_pending.xml")).map(file -> file.withApp(this.app).withPath(Paths.get(fixedDir, file.getName()).toString())).collect(Collectors.toList());
    }

    @Override
    public AppServiceFile getFileByPath(String path) {
        String fixedPath = StringUtils.removeStart((String)path, (String)HOME_PREFIX);
        File file = new File(fixedPath);
        List<? extends AppServiceFile> result = this.getFilesInDirectory(file.getParent());
        return result.stream().filter(appServiceFile -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)appServiceFile.getName())).findFirst().orElse(null);
    }

    @Override
    public void uploadFileToPath(String content, String path) {
        this.kuduService.saveFile(this.host, path, content).block();
    }

    @Override
    public void createDirectory(String path) {
        this.kuduService.createDirectory(this.host, path).block();
    }

    @Override
    public void deleteFile(String path) {
        this.kuduService.deleteFile(this.host, path).block();
    }

    @Override
    public List<ProcessInfo> listProcess() {
        return (List)((Response)Objects.requireNonNull(this.kuduService.listProcess(this.host).block())).getValue();
    }

    @Override
    public CommandOutput execute(String command, String dir) {
        Object commandRequest = ((CommandRequest.CommandRequestBuilder)((CommandRequest.CommandRequestBuilder)CommandRequest.builder().command(command)).dir(dir)).build();
        return (CommandOutput)((Response)Objects.requireNonNull(this.kuduService.execute(this.host, JsonUtils.toJson(commandRequest)).block())).getValue();
    }

    public void flexZipDeploy(@Nonnull File zipFile) throws IOException {
        try (AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(zipFile.toPath(), StandardOpenOption.READ);){
            Flux byteBuffer = FluxUtil.readFile((AsynchronousFileChannel)fileChannel);
            String product = Azure.az().config().getProduct();
            String version = Azure.az().config().getVersion();
            String tool = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{product, version}) ? DEFAULT_TOOL_NAME : String.format("%s/%s", product, version);
            this.kuduService.flexZipDeploy(this.host, (Flux<ByteBuffer>)byteBuffer, fileChannel.size(), tool).block();
        }
    }

    @Override
    public TunnelStatus getAppServiceTunnelStatus() {
        return (TunnelStatus)((Response)Objects.requireNonNull(this.kuduService.getAppServiceTunnelStatus(this.host).block())).getValue();
    }

    public void checkLatestDeploymentStatus(Duration duration, int repeatTimes) {
        AtomicBoolean hasResponse = new AtomicBoolean(false);
        Integer finalStatus = (Integer)Mono.fromCallable(() -> this.getLatestDeploymentStatus(hasResponse)).delayElement(duration).subscribeOn(Schedulers.boundedElastic()).repeat((long)repeatTimes).takeUntil(AppServiceKuduClient::isSuccessStatusCode).blockLast();
        if (!AppServiceKuduClient.isSuccessStatusCode(finalStatus)) {
            throw new AzureToolkitRuntimeException(DEPLOYMENT_STATUS_TIMEOUT);
        }
    }

    private static boolean isSuccessStatusCode(@Nullable Integer integer) {
        return integer != null && integer == 4;
    }

    @Nonnull
    @AzureOperation(name="azure/function.get_deployment_status.function", params={"this.app.getName()"})
    private Integer getLatestDeploymentStatus(AtomicBoolean hasResponseBefore) {
        AtomicBoolean atomicBoolean = hasResponseBefore;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)atomicBoolean);
        try {
            Integer n;
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            Response response = (Response)this.kuduService.latestDeployment(this.host).block();
            if (Objects.isNull(response)) {
                n = 0;
            } else {
                String string = Optional.ofNullable(response.getValue()).map(BinaryData::toString).orElse("");
                Object value = StringUtils.isBlank((CharSequence)string) ? NullNode.getInstance() : this.tryParseJson(string, (JsonNode)NullNode.getInstance());
                String status = Optional.ofNullable(value.get("status")).map(JsonNode::asText).orElse(null);
                if ((StringUtils.isEmpty((CharSequence)status) || response.getStatusCode() == 404) && hasResponseBefore.get()) {
                    throw new AzureToolkitRuntimeException("Failed to retrieve deployment status. Please try again in a few minutes.");
                }
                if (StringUtils.isNotBlank((CharSequence)status) && response.getStatusCode() != 404) {
                    hasResponseBefore.compareAndSet(false, true);
                }
                Integer statusCode = StringUtils.isNotBlank((CharSequence)status) ? Integer.parseInt(status) : 0;
                switch (statusCode) {
                    case -1: {
                        throw new AzureToolkitRuntimeException("Deployment was cancelled.");
                    }
                    case 3: {
                        String message = String.format("Deployment failed. %s. These are the deployment logs: \\n%s", JsonUtils.toJson((Object)value), this.getDeploymentLog());
                        throw new AzureToolkitRuntimeException(message);
                    }
                    case 5: {
                        throw new AzureToolkitRuntimeException("Deployment was cancelled and another deployment is in progress.");
                    }
                    case 6: {
                        String partSuccessMessage = String.format("Deployment was partially successful. These are the deployment logs:\\n%s", this.getDeploymentLog());
                        throw new AzureToolkitRuntimeException(partSuccessMessage);
                    }
                    default: {
                        Optional.ofNullable(value.get("progress")).map(JsonNode::asText).filter(StringUtils::isNotBlank).ifPresent(progress -> AzureMessager.getMessager().debug(progress));
                    }
                    case 4: 
                }
                n = statusCode;
            }
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return n;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private JsonNode tryParseJson(String string, JsonNode fallback) {
        try {
            return (JsonNode)JsonUtils.fromJson((String)string, JsonNode.class);
        }
        catch (Exception e) {
            AzureMessager.getMessager().debug("Failed to parse json string: " + string, new Object[]{e});
            return fallback;
        }
    }

    public String getDeploymentLog() {
        JsonNode value = Optional.ofNullable(this.kuduService.getDeploymentsLog(this.host).block()).map(Response::getValue).orElse((JsonNode)NullNode.getInstance());
        return value.isArray() && !value.isEmpty() ? value.get(0).toPrettyString() : value.toPrettyString();
    }

    static {
        AppServiceKuduClient.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppServiceKuduClient.java", AppServiceKuduClient.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getLatestDeploymentStatus", "com.microsoft.azure.toolkit.lib.appservice.file.AppServiceKuduClient", "java.util.concurrent.atomic.AtomicBoolean", "hasResponseBefore", "", "java.lang.Integer"), 172);
    }

    public static class CommandRequest {
        private String command;
        private String dir;

        protected CommandRequest(CommandRequestBuilder<?, ?> b) {
            this.command = ((CommandRequestBuilder)b).command;
            this.dir = ((CommandRequestBuilder)b).dir;
        }

        public static CommandRequestBuilder<?, ?> builder() {
            return new CommandRequestBuilderImpl();
        }

        public CommandRequestBuilder<?, ?> toBuilder() {
            return new CommandRequestBuilderImpl().$fillValuesFrom(this);
        }

        public String getCommand() {
            return this.command;
        }

        public String getDir() {
            return this.dir;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CommandRequest)) {
                return false;
            }
            CommandRequest other = (CommandRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            String this$dir = this.getDir();
            String other$dir = other.getDir();
            return !(this$dir == null ? other$dir != null : !this$dir.equals(other$dir));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CommandRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            String $dir = this.getDir();
            result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
            return result;
        }

        public String toString() {
            return "AppServiceKuduClient.CommandRequest(command=" + this.getCommand() + ", dir=" + this.getDir() + ")";
        }

        private static final class CommandRequestBuilderImpl
        extends CommandRequestBuilder<CommandRequest, CommandRequestBuilderImpl> {
            private CommandRequestBuilderImpl() {
            }

            @Override
            protected CommandRequestBuilderImpl self() {
                return this;
            }

            @Override
            public CommandRequest build() {
                return new CommandRequest(this);
            }
        }

        public static abstract class CommandRequestBuilder<C extends CommandRequest, B extends CommandRequestBuilder<C, B>> {
            private String command;
            private String dir;

            protected B $fillValuesFrom(C instance) {
                CommandRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            private static void $fillValuesFromInstanceIntoBuilder(CommandRequest instance, CommandRequestBuilder<?, ?> b) {
                b.command(instance.command);
                b.dir(instance.dir);
            }

            protected abstract B self();

            public abstract C build();

            public B command(String command) {
                this.command = command;
                return this.self();
            }

            public B dir(String dir) {
                this.dir = dir;
                return this.self();
            }

            public String toString() {
                return "AppServiceKuduClient.CommandRequest.CommandRequestBuilder(command=" + this.command + ", dir=" + this.dir + ")";
            }
        }
    }

    @Host(value="{$host}")
    @ServiceInterface(name="KuduService")
    private static interface KuduService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="api/vfs/{path}")
        public Mono<StreamResponse> getFileContent(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Get(value="api/vfs/{path}/")
        public Mono<Response<List<AppServiceFile>>> getFilesInDirectory(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/octet-stream; charset=utf-8", "If-Match: *"})
        @Put(value="api/vfs/{path}")
        public Mono<Void> saveFile(@HostParam(value="$host") String var1, @PathParam(value="path") String var2, @BodyParam(value="application/octet-stream") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @Put(value="api/vfs/{path}/")
        public Mono<Void> createDirectory(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "If-Match: *"})
        @Delete(value="api/vfs/{path}")
        public Mono<Void> deleteFile(@HostParam(value="$host") String var1, @PathParam(value="path") String var2);

        @Headers(value={"x-ms-body-logging: false"})
        @Get(value="api/processes")
        public Mono<Response<List<ProcessInfo>>> listProcess(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-body-logging: false"})
        @Post(value="api/command")
        public Mono<Response<CommandOutput>> execute(@HostParam(value="$host") String var1, @BodyParam(value="json") String var2);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-body-logging: false"})
        @Get(value="api/deployments/latest")
        @ExpectedResponses(value={200, 202, 204, 404})
        public Mono<Response<BinaryData>> latestDeployment(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-body-logging: false"})
        @Get(value="api/deployments/")
        public Mono<Response<JsonNode>> getDeploymentsLog(@HostParam(value="$host") String var1);

        @Headers(value={"Content-Type: application/zip"})
        @Post(value="api/publish?Deployer={tool}")
        public Mono<Void> flexZipDeploy(@HostParam(value="$host") String var1, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var2, @HeaderParam(value="content-length") long var3, @PathParam(value="tool") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-body-logging: false"})
        @Get(value="AppServiceTunnel/Tunnel.ashx?GetStatus&GetStatusAPIVer=2")
        public Mono<Response<TunnelStatus>> getAppServiceTunnelStatus(@HostParam(value="$host") String var1);
    }
}

