/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.function;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.AzureAppService;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionsServiceSubscription;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureFunctions
extends AzureAppService {
    @Nonnull
    public FunctionAppModule functionApps(@Nonnull String subscriptionId) {
        AppServiceServiceSubscription rm = (AppServiceServiceSubscription)this.get(subscriptionId, null);
        assert (rm != null);
        return rm.getFunctionAppModule();
    }

    @Nonnull
    public List<FunctionApp> functionApps() {
        return this.list().stream().flatMap(m -> m.functionApps().list().stream()).collect(Collectors.toList());
    }

    @Nullable
    public FunctionApp functionApp(String resourceId) {
        ResourceId id = ResourceId.fromString((String)resourceId);
        return (FunctionApp)this.functionApps(id.subscriptionId()).get(id.name(), id.resourceGroupName());
    }

    @Override
    @Nonnull
    protected AppServiceServiceSubscription newResource(@Nonnull AppServiceManager remote) {
        return new FunctionsServiceSubscription(remote, (AzureAppService)this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Function Apps";
    }

    @Override
    public String getServiceNameForTelemetry() {
        return "function";
    }
}

