/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.plan;

import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceServiceSubscription;
import com.microsoft.azure.toolkit.lib.appservice.config.AppServicePlanConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.PricingTier;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanModule;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.validator.SchemaValidator;
import com.microsoft.azure.toolkit.lib.resource.AzureResources;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroupDraft;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class AppServicePlanDraft
extends AppServicePlan
implements AzResource.Draft<AppServicePlan, com.azure.resourcemanager.appservice.models.AppServicePlan> {
    private static final String CREATE_NEW_APP_SERVICE_PLAN = "createNewAppServicePlan";
    @Nullable
    private final AppServicePlan origin;
    @Nullable
    private Config config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    AppServicePlanDraft(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AppServicePlanModule module) {
        super(name, resourceGroupName, module);
        this.origin = null;
    }

    AppServicePlanDraft(@Nonnull AppServicePlan origin) {
        super(origin);
        this.origin = origin;
    }

    public void reset() {
        this.config = null;
    }

    @Nonnull
    private synchronized Config ensureConfig() {
        this.config = Optional.ofNullable(this.config).orElseGet(Config::new);
        return this.config;
    }

    public void setPlanConfig(@Nonnull AppServicePlanConfig config) {
        this.setPricingTier(config.getPricingTier());
        this.setOperatingSystem(config.getOs());
        this.setRegion(config.getRegion());
    }

    @Nonnull
    public AppServicePlanConfig getPlanConfig() {
        AppServicePlanConfig servicePlanConfig = new AppServicePlanConfig();
        servicePlanConfig.setSubscriptionId(this.getSubscriptionId());
        servicePlanConfig.setName(this.getName());
        servicePlanConfig.setResourceGroupName(this.getResourceGroupName());
        servicePlanConfig.setPricingTier(this.getPricingTier());
        servicePlanConfig.setOs(this.getOperatingSystem());
        servicePlanConfig.setRegion(this.getRegion());
        return servicePlanConfig;
    }

    @Nonnull
    @AzureOperation(name="azure/$appservice.create_plan.plan", params={"this.getName()"})
    public com.azure.resourcemanager.appservice.models.AppServicePlan createResourceInAzure() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            SchemaValidator.getInstance().validateAndThrow("appservice/CreateAppServicePlan", (Object)this.getPlanConfig());
            OperationContext.action().setTelemetryProperty(CREATE_NEW_APP_SERVICE_PLAN, String.valueOf(true));
            Optional.ofNullable(this.getPricingTier()).ifPresent(pricingTier -> OperationContext.action().setTelemetryProperty("pricingTier", pricingTier.getSize()));
            String name = this.getName();
            com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem newOs = Objects.requireNonNull(this.getOperatingSystem(), "'operating system' is required to create App Service plan.");
            PricingTier newTier = Objects.requireNonNull(this.getPricingTier(), "'pricing tier' is required to create App Service plan.");
            Region newRegion = Objects.requireNonNull(this.getRegion(), "'region' is required to create App Service plan.");
            Optional.ofNullable(this.getResourceGroup()).filter(AbstractAzResource::isDraftForCreating).ifPresent(rg -> {
                ResourceGroup cfr_ignored_0 = (ResourceGroup)((ResourceGroupDraft)rg).createIfNotExist();
            });
            AppServiceManager manager = (AppServiceManager)Objects.requireNonNull(((AppServiceServiceSubscription)this.getParent()).getRemote());
            AppServicePlan.DefinitionStages.WithCreate withCreate = ((AppServicePlan.DefinitionStages.WithPricingTier)((AppServicePlan.DefinitionStages.WithGroup)((AppServicePlan.DefinitionStages.Blank)manager.appServicePlans().define(name)).withRegion(newRegion.getName())).withExistingResourceGroup(this.getResourceGroupName())).withPricingTier(AppServiceUtils.toPricingTier(newTier)).withOperatingSystem(this.convertOS(newOs));
            IAzureMessager messager = AzureMessager.getMessager();
            messager.info(AzureString.format((String)"Start creating App Service plan ({0})...", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.AppServicePlan plan = (com.azure.resourcemanager.appservice.models.AppServicePlan)Objects.requireNonNull(withCreate.create());
            messager.success(AzureString.format((String)"App Service plan ({0}) is successfully created", (Object[])new Object[]{name}));
            com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan = plan;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServicePlan;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    private OperatingSystem convertOS(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem) {
        return operatingSystem == com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem.WINDOWS ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    @Nonnull
    @AzureOperation(name="azure/$appservice.update_plan.plan", params={"this.getName()"})
    public com.azure.resourcemanager.appservice.models.AppServicePlan updateResourceInAzure(@Nonnull com.azure.resourcemanager.appservice.models.AppServicePlan remote) {
        com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan = remote;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)appServicePlan);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            assert (this.origin != null) : "updating target is not specified.";
            PricingTier newTier = this.getPricingTier();
            PricingTier oldTier = this.origin.getPricingTier();
            boolean modified = Objects.nonNull(newTier) && !Objects.equals(newTier, oldTier);
            AppServicePlan.Update update = (AppServicePlan.Update)remote.update();
            if (!Objects.equals(this.getRegion(), this.origin.getRegion())) {
                AzureMessager.getMessager().warning(AzureString.format((String)"Skip region update for existing service plan ({0}) since it is not allowed.", (Object[])new Object[]{remote.name()}));
            }
            com.azure.resourcemanager.appservice.models.AppServicePlan result = remote;
            if (modified) {
                update = update.withPricingTier(AppServiceUtils.toPricingTier(newTier));
                IAzureMessager messager = AzureMessager.getMessager();
                messager.info(AzureString.format((String)"Start updating App Service plan ({0})...", (Object[])new Object[]{remote.name()}));
                result = (com.azure.resourcemanager.appservice.models.AppServicePlan)update.apply();
                messager.success(AzureString.format((String)"App Service plan ({0}) is successfully updated", (Object[])new Object[]{remote.name()}));
            }
            com.azure.resourcemanager.appservice.models.AppServicePlan appServicePlan2 = result;
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return appServicePlan2;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Override
    @Nullable
    public Region getRegion() {
        return Optional.ofNullable(this.config).map(Config::getRegion).orElseGet(() -> super.getRegion());
    }

    public AppServicePlanDraft setRegion(Region region) {
        this.ensureConfig().setRegion(region);
        return this;
    }

    @Override
    @Nullable
    public PricingTier getPricingTier() {
        return Optional.ofNullable(this.config).map(Config::getPricingTier).orElseGet(() -> super.getPricingTier());
    }

    public AppServicePlanDraft setPricingTier(PricingTier tier) {
        this.ensureConfig().setPricingTier(tier);
        return this;
    }

    @Override
    @Nullable
    public com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem getOperatingSystem() {
        return Optional.ofNullable(this.config).map(Config::getOperatingSystem).orElseGet(() -> super.getOperatingSystem());
    }

    public AppServicePlanDraft setOperatingSystem(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem os) {
        this.ensureConfig().setOperatingSystem(os);
        return this;
    }

    public ResourceGroup getResourceGroup() {
        ResourceGroup rg = (ResourceGroup)((AzureResources)Azure.az(AzureResources.class)).groups(this.getSubscriptionId()).getOrDraft(this.getResourceGroupName(), this.getResourceGroupName());
        if (rg.isDraftForCreating()) {
            Optional.ofNullable(this.getRegion()).ifPresent(r -> ((ResourceGroupDraft)rg).setRegion(r));
        }
        return rg;
    }

    public boolean isModified() {
        boolean notModified = Objects.isNull(this.config) || Objects.isNull(this.config.getRegion()) || Objects.equals(this.config.getRegion(), super.getRegion()) || Objects.isNull(this.config.getPricingTier()) || Objects.equals(this.config.getPricingTier(), super.getPricingTier()) || Objects.isNull((Object)this.config.getOperatingSystem()) || Objects.equals((Object)this.config.getOperatingSystem(), (Object)super.getOperatingSystem());
        return !notModified;
    }

    @Nullable
    public AppServicePlan getOrigin() {
        return this.origin;
    }

    static {
        AppServicePlanDraft.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AppServicePlanDraft.java", AppServicePlanDraft.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanDraft", "", "", "", "com.azure.resourcemanager.appservice.models.AppServicePlan"), 89);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateResourceInAzure", "com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlanDraft", "com.azure.resourcemanager.appservice.models.AppServicePlan", "remote", "", "com.azure.resourcemanager.appservice.models.AppServicePlan"), 124);
    }

    private static class Config {
        private Region region;
        private PricingTier pricingTier;
        private com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem;

        public Region getRegion() {
            return this.region;
        }

        public PricingTier getPricingTier() {
            return this.pricingTier;
        }

        public com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem getOperatingSystem() {
            return this.operatingSystem;
        }

        public void setRegion(Region region) {
            this.region = region;
        }

        public void setPricingTier(PricingTier pricingTier) {
            this.pricingTier = pricingTier;
        }

        public void setOperatingSystem(com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Region this$region = this.getRegion();
            Region other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            PricingTier this$pricingTier = this.getPricingTier();
            PricingTier other$pricingTier = other.getPricingTier();
            if (this$pricingTier == null ? other$pricingTier != null : !((Object)this$pricingTier).equals(other$pricingTier)) {
                return false;
            }
            com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem this$operatingSystem = this.getOperatingSystem();
            com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem other$operatingSystem = other.getOperatingSystem();
            return !(this$operatingSystem == null ? other$operatingSystem != null : !((Object)((Object)this$operatingSystem)).equals((Object)other$operatingSystem));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Region $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            PricingTier $pricingTier = this.getPricingTier();
            result = result * 59 + ($pricingTier == null ? 43 : ((Object)$pricingTier).hashCode());
            com.microsoft.azure.toolkit.lib.appservice.model.OperatingSystem $operatingSystem = this.getOperatingSystem();
            result = result * 59 + ($operatingSystem == null ? 43 : ((Object)((Object)$operatingSystem)).hashCode());
            return result;
        }

        public String toString() {
            return "AppServicePlanDraft.Config(region=" + this.getRegion() + ", pricingTier=" + this.getPricingTier() + ", operatingSystem=" + (Object)((Object)this.getOperatingSystem()) + ")";
        }
    }
}

