/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.task;

import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.entity.FunctionEntity;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionApp;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppBase;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppDeploymentSlot;
import com.microsoft.azure.toolkit.lib.appservice.model.FunctionDeployType;
import com.microsoft.azure.toolkit.lib.appservice.model.Runtime;
import com.microsoft.azure.toolkit.lib.appservice.plan.AppServicePlan;
import com.microsoft.azure.toolkit.lib.appservice.task.StreamingLogTask;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import com.microsoft.azure.toolkit.lib.common.task.AzureTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.zeroturnaround.zip.ZipUtil;
import reactor.core.Disposable;

public class DeployFunctionAppTask
extends AzureTask<FunctionAppBase<?, ?, ?>> {
    private static final String RUNNING = "Running";
    private static final String LOCAL_SETTINGS_FILE = "local.settings.json";
    private static final String DEPLOY_START = "Starting deployment...";
    private static final String DEPLOY_FINISH = "Deployment succeed";
    private static final String SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE = "Skip deployment for docker app service";
    private static final String FAILED_TO_LIST_TRIGGERS = "Deployment succeeded, but failed to list http trigger urls.";
    private final FunctionAppBase<?, ?, ?> target;
    private final File stagingDirectory;
    private final FunctionDeployType deployType;
    private final IAzureMessager messager;
    private Disposable subscription;
    private final boolean openStreamingLogOnFailure;

    public DeployFunctionAppTask(@Nonnull FunctionAppBase<?, ?, ?> target, @Nonnull File stagingFolder, @Nullable FunctionDeployType deployType) {
        this(target, stagingFolder, deployType, false);
    }

    public DeployFunctionAppTask(@Nonnull FunctionAppBase<?, ?, ?> target, @Nonnull File stagingFolder, @Nullable FunctionDeployType deployType, boolean openStreamingLogOnFailure) {
        this.target = target;
        this.stagingDirectory = stagingFolder;
        this.deployType = deployType;
        this.messager = AzureMessager.getMessager();
        this.openStreamingLogOnFailure = openStreamingLogOnFailure;
    }

    public AzureString getDescription() {
        return AzureString.format((String)"Deploy artifact to function app %s", (Object[])new Object[]{this.target.getName()});
    }

    public FunctionAppBase<?, ?, ?> doExecute() {
        Boolean isDockerRuntime = Optional.ofNullable(this.target.getRuntime()).map(Runtime::isDocker).orElse(false);
        if (isDockerRuntime.booleanValue()) {
            this.messager.info(SKIP_DEPLOYMENT_FOR_DOCKER_APP_SERVICE);
            return this.target;
        }
        this.deployArtifact();
        if (this.target instanceof FunctionApp && this.openStreamingLogOnFailure) {
            try {
                ((FunctionApp)this.target).listHTTPTriggerUrls();
            }
            catch (Exception e) {
                this.messager.warning(FAILED_TO_LIST_TRIGGERS);
                new StreamingLogTask(this.target).doExecute();
            }
        }
        return this.target;
    }

    private void deployArtifact() {
        this.messager.info(DEPLOY_START);
        OperationContext.action().setTelemetryProperty("subscriptionId", this.target.getSubscriptionId());
        OperationContext.action().setTelemetryProperty("deployType", Optional.ofNullable(this.deployType).map(Enum::toString).orElse("empty"));
        OperationContext.action().setTelemetryProperty("deployToSlot", String.valueOf(this.target instanceof FunctionAppDeploymentSlot));
        Optional.ofNullable(this.target.getRuntime()).ifPresent(runtime -> OperationContext.action().setTelemetryProperty("runtime", runtime.getDisplayName()));
        Optional.ofNullable(this.target.getRuntime()).map(Runtime::getOperatingSystem).ifPresent(os -> OperationContext.action().setTelemetryProperty("os", os.getValue()));
        Optional.ofNullable(this.target.getRuntime()).map(Runtime::getJavaVersionUserText).ifPresent(javaVersion -> OperationContext.action().setTelemetryProperty("javaVersion", javaVersion));
        Optional.ofNullable(this.target.getAppServicePlan()).map(AppServicePlan::getPricingTier).ifPresent(pricingTier -> OperationContext.action().setTelemetryProperty("pricingTier", pricingTier.getSize()));
        File file = this.deployType == FunctionDeployType.FTP ? this.stagingDirectory : this.packageStagingDirectory();
        long startTime = System.currentTimeMillis();
        if (this.deployType == null) {
            this.target.deploy(file);
        } else {
            this.target.deploy(file, this.deployType);
        }
        OperationContext.action().setTelemetryProperty("deploy-cost", String.valueOf(System.currentTimeMillis() - startTime));
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.target.getStatus(), (CharSequence)RUNNING)) {
            this.target.start();
        }
        if (this.target instanceof FunctionApp) {
            List<FunctionEntity> triggers = ((FunctionApp)this.target).listFunctions(true);
            Action streamingLog = Optional.ofNullable(AzureActionManager.getInstance().getAction(AppServiceAppBase.START_STREAM_LOG)).map(action -> action.bind(this.target)).orElse(null);
            List actions = triggers.stream().map(trigger -> {
                if (trigger.isHttpTrigger()) {
                    return Optional.ofNullable(AzureActionManager.getInstance().getAction(FunctionEntity.TRIGGER_FUNCTION_IN_BROWSER)).map(action -> action.bind(trigger).withLabel(String.format("Trigger \"%s\"", trigger.getName()))).orElse(null);
                }
                return Optional.ofNullable(AzureActionManager.getInstance().getAction(FunctionEntity.TRIGGER_FUNCTION)).map(action -> action.bind(trigger).withLabel(String.format("Trigger \"%s\"", trigger.getName()))).orElse(null);
            }).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
            Optional.ofNullable(streamingLog).filter(ignore -> !(this.target instanceof FunctionApp) || !this.target.isFlexConsumptionApp()).ifPresent(action -> actions.add(0, action));
            this.messager.info(String.format(DEPLOY_FINISH, new Object[0]), actions.toArray());
        } else {
            this.messager.info(String.format(DEPLOY_FINISH, new Object[0]));
        }
    }

    private File packageStagingDirectory() {
        try {
            File zipFile = Files.createTempFile("azure-functions", ".zip", new FileAttribute[0]).toFile();
            ZipUtil.pack((File)this.stagingDirectory, (File)zipFile);
            ZipUtil.removeEntry((File)zipFile, (String)LOCAL_SETTINGS_FILE);
            return zipFile;
        }
        catch (IOException e) {
            throw new AzureToolkitRuntimeException("Failed to package function to deploy", (Throwable)e);
        }
    }
}

