/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.utils;

import com.microsoft.azure.toolkit.lib.common.utils.CommandUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class FunctionCliResolver {
    private static final boolean isWindows = CommandUtils.isWindows();

    public static String resolveFunc() {
        return FunctionCliResolver.resolve().stream().findFirst().orElse(null);
    }

    public static List<String> resolve() {
        return FunctionCliResolver.resolveInner();
    }

    private static List<String> resolveInner() {
        List whichFuncDirs = CommandUtils.resolveCommandPath((String)"func");
        HashSet<String> results = new HashSet<String>();
        HashSet<String> processedDirectories = new HashSet<String>();
        for (String dir : whichFuncDirs) {
            try {
                String parentFolder;
                File canonicalFile = new File(dir).getCanonicalFile();
                if (!canonicalFile.exists() || !processedDirectories.add(parentFolder = canonicalFile.getParentFile().getAbsolutePath())) continue;
                String result = FunctionCliResolver.findFuncInFolder(parentFolder);
                if (result != null) {
                    results.add(result);
                }
                if ((result = FunctionCliResolver.findFuncInAdditionalFolder(parentFolder)) == null) continue;
                results.add(result);
            }
            catch (IOException iOException) {}
        }
        Optional.ofNullable(FunctionCliResolver.findFuncInNpm()).ifPresent(results::add);
        return new ArrayList<String>(results);
    }

    @Nullable
    private static String findFuncInFolder(String parentFolder) {
        File func;
        if (new File(parentFolder, FunctionCliResolver.getFuncFileName()).exists() && (func = new File(parentFolder, FunctionCliResolver.getFuncFileName())).exists() && new File(parentFolder, "func.dll").exists()) {
            return Paths.get(func.getAbsolutePath(), new String[0]).normalize().toString();
        }
        return null;
    }

    @Nullable
    private static String findFuncInNpm() {
        try {
            String output = StringUtils.trim((String)CommandUtils.exec((String)"npm root --global"));
            File path = new File(output, "azure-functions-core-tools/bin");
            if (FunctionCliResolver.isDirectory(path)) {
                return FunctionCliResolver.findFuncInFolder(path.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String getFuncFileName() {
        return isWindows ? "func.exe" : "func";
    }

    private static String findFuncInAdditionalFolder(String funcParentFolder) {
        return Optional.ofNullable(FunctionCliResolver.findFuncInFolder(Paths.get(funcParentFolder, "../lib/azure-functions-core-tools/tools").toString())).orElseGet(() -> FunctionCliResolver.findFuncInFolder(Paths.get(funcParentFolder, "../bin").toString()));
    }

    private static boolean isDirectory(File path) {
        return path.exists() && FileUtils.isDirectory((File)path, (LinkOption[])new LinkOption[0]);
    }
}

