/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.appservice.webapp;

import com.azure.resourcemanager.appservice.models.DeployType;
import com.azure.resourcemanager.appservice.models.JavaVersion;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.SupportsOneDeploy;
import com.azure.resourcemanager.appservice.models.WebSiteBase;
import com.microsoft.azure.toolkit.lib.appservice.AppServiceAppBase;
import com.microsoft.azure.toolkit.lib.appservice.deploy.IOneDeploy;
import com.microsoft.azure.toolkit.lib.appservice.model.CsmDeploymentStatus;
import com.microsoft.azure.toolkit.lib.appservice.model.DeployOptions;
import com.microsoft.azure.toolkit.lib.appservice.model.DiagnosticConfig;
import com.microsoft.azure.toolkit.lib.appservice.model.KuduDeploymentResult;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppDockerRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppLinuxRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppRuntime;
import com.microsoft.azure.toolkit.lib.appservice.model.WebAppWindowsRuntime;
import com.microsoft.azure.toolkit.lib.appservice.utils.AppServiceUtils;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class WebAppBase<T extends WebAppBase<T, P, F>, P extends AbstractAzResource<P, ?, ?>, F extends com.azure.resourcemanager.appservice.models.WebAppBase>
extends AppServiceAppBase<T, P, F>
implements IOneDeploy {
    protected WebAppBase(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<T, P, F> module) {
        super(name, resourceGroupName, module);
    }

    protected WebAppBase(@Nonnull String name, @Nonnull AbstractAzResourceModule<T, P, F> module) {
        super(name, module);
    }

    protected WebAppBase(@Nonnull T origin) {
        super(origin);
    }

    @Override
    public void deploy(@Nonnull com.microsoft.azure.toolkit.lib.appservice.model.DeployType deployType, @Nonnull File targetFile, @Nullable DeployOptions deployOptions) {
        WebSiteBase remote = (WebSiteBase)this.getRemote();
        if (remote instanceof SupportsOneDeploy) {
            com.azure.resourcemanager.appservice.models.DeployOptions options = deployOptions == null ? null : AppServiceUtils.toDeployOptions(deployOptions);
            AzureMessager.getMessager().info(AzureString.format((String)"Deploying (%s)[%s] %s ...", (Object[])new Object[]{targetFile.toString(), deployType.toString(), StringUtils.isBlank((CharSequence)deployOptions.getPath()) ? "" : " to " + deployOptions.getPath()}));
            DeployType type = DeployType.fromString((String)deployType.getValue());
            this.doModify(() -> Objects.requireNonNull((SupportsOneDeploy)remote).deploy(type, targetFile, options), "Deploying");
        }
    }

    @Override
    @Nullable
    public KuduDeploymentResult pushDeploy(@Nonnull com.microsoft.azure.toolkit.lib.appservice.model.DeployType deployType, @Nonnull File targetFile, @Nullable DeployOptions deployOptions) {
        WebSiteBase remote = (WebSiteBase)this.getRemote();
        if (remote instanceof SupportsOneDeploy) {
            com.azure.resourcemanager.appservice.models.DeployOptions options = deployOptions == null ? null : AppServiceUtils.toDeployOptions(deployOptions);
            AzureMessager.getMessager().info(AzureString.format((String)"Deploying (%s)[%s] %s ...", (Object[])new Object[]{targetFile.toString(), deployType.toString(), StringUtils.isBlank((CharSequence)deployOptions.getPath()) ? "" : " to " + deployOptions.getPath()}));
            DeployType type = DeployType.fromString((String)deployType.getValue());
            return AppServiceUtils.fromKuduDeploymentResult(((SupportsOneDeploy)remote).pushDeploy(type, targetFile, options));
        }
        return null;
    }

    @Override
    public WebAppRuntime getRuntime() {
        return this.remoteOptional().map(r -> {
            if (r.operatingSystem() == OperatingSystem.WINDOWS) {
                String container = r.javaContainer();
                String containerVersion = r.javaContainerVersion();
                JavaVersion javaVersion = r.javaVersion();
                return WebAppWindowsRuntime.fromContainerAndJavaVersion(container, containerVersion, javaVersion);
            }
            String fxString = r.linuxFxVersion();
            if (StringUtils.isEmpty((CharSequence)fxString)) {
                return null;
            }
            if (StringUtils.startsWithIgnoreCase((CharSequence)fxString, (CharSequence)"docker")) {
                return WebAppDockerRuntime.INSTANCE;
            }
            return WebAppLinuxRuntime.fromFxString(fxString);
        }).orElse(null);
    }

    @Override
    @Nullable
    public CsmDeploymentStatus getDeploymentStatus(@Nonnull String deploymentId) {
        WebSiteBase remote = (WebSiteBase)this.getRemote();
        if (remote instanceof SupportsOneDeploy) {
            return AppServiceUtils.fromCsmDeploymentStatus(((SupportsOneDeploy)remote).getDeploymentStatus(deploymentId));
        }
        return null;
    }

    @Override
    public boolean isStreamingLogSupported() {
        return Optional.ofNullable(this.getDiagnosticConfig()).map(DiagnosticConfig::isEnableWebServerLogging).orElse(false);
    }
}

