/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerapps.model;

import com.microsoft.azure.toolkit.lib.containerapps.model.WorkloadProfileType;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class WorkloadProfile {
    public static final String CONSUMPTION = "Consumption";
    public static final WorkloadProfile CONSUMPTION_PROFILE = WorkloadProfile.builder().name("Consumption").type(WorkloadProfileType.CONSUMPTION_TYPE).build();
    private String name;
    private WorkloadProfileType type;
    private Integer minimumCount;
    private Integer maximumCount;

    public String getWorkloadProfileType() {
        return Optional.ofNullable(this.type).map(WorkloadProfileType::getName).orElse(null);
    }

    public static com.azure.resourcemanager.appcontainers.models.WorkloadProfile toWorkloadProfile(WorkloadProfile workloadProfile) {
        return new com.azure.resourcemanager.appcontainers.models.WorkloadProfile().withName(workloadProfile.getName()).withWorkloadProfileType(workloadProfile.getWorkloadProfileType()).withMinimumCount(workloadProfile.getMinimumCount()).withMaximumCount(workloadProfile.getMaximumCount());
    }

    public static WorkloadProfile fromProfile(com.azure.resourcemanager.appcontainers.models.WorkloadProfile workloadProfile) {
        if (StringUtils.equalsIgnoreCase((CharSequence)workloadProfile.name(), (CharSequence)CONSUMPTION)) {
            return CONSUMPTION_PROFILE;
        }
        return WorkloadProfile.builder().name(workloadProfile.name()).type(WorkloadProfileType.builder().name(workloadProfile.workloadProfileType()).build()).maximumCount(workloadProfile.maximumCount()).minimumCount(workloadProfile.minimumCount()).build();
    }

    public static WorkloadProfileBuilder builder() {
        return new WorkloadProfileBuilder();
    }

    public String getName() {
        return this.name;
    }

    public WorkloadProfileType getType() {
        return this.type;
    }

    public Integer getMinimumCount() {
        return this.minimumCount;
    }

    public Integer getMaximumCount() {
        return this.maximumCount;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(WorkloadProfileType type) {
        this.type = type;
    }

    public void setMinimumCount(Integer minimumCount) {
        this.minimumCount = minimumCount;
    }

    public void setMaximumCount(Integer maximumCount) {
        this.maximumCount = maximumCount;
    }

    public String toString() {
        return "WorkloadProfile(name=" + this.getName() + ", type=" + this.getType() + ", minimumCount=" + this.getMinimumCount() + ", maximumCount=" + this.getMaximumCount() + ")";
    }

    public WorkloadProfile() {
    }

    public WorkloadProfile(String name, WorkloadProfileType type, Integer minimumCount, Integer maximumCount) {
        this.name = name;
        this.type = type;
        this.minimumCount = minimumCount;
        this.maximumCount = maximumCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkloadProfile)) {
            return false;
        }
        WorkloadProfile other = (WorkloadProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$minimumCount = this.getMinimumCount();
        Integer other$minimumCount = other.getMinimumCount();
        if (this$minimumCount == null ? other$minimumCount != null : !((Object)this$minimumCount).equals(other$minimumCount)) {
            return false;
        }
        Integer this$maximumCount = this.getMaximumCount();
        Integer other$maximumCount = other.getMaximumCount();
        if (this$maximumCount == null ? other$maximumCount != null : !((Object)this$maximumCount).equals(other$maximumCount)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        WorkloadProfileType this$type = this.getType();
        WorkloadProfileType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkloadProfile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $minimumCount = this.getMinimumCount();
        result = result * 59 + ($minimumCount == null ? 43 : ((Object)$minimumCount).hashCode());
        Integer $maximumCount = this.getMaximumCount();
        result = result * 59 + ($maximumCount == null ? 43 : ((Object)$maximumCount).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        WorkloadProfileType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public static class WorkloadProfileBuilder {
        private String name;
        private WorkloadProfileType type;
        private Integer minimumCount;
        private Integer maximumCount;

        WorkloadProfileBuilder() {
        }

        public WorkloadProfileBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WorkloadProfileBuilder type(WorkloadProfileType type) {
            this.type = type;
            return this;
        }

        public WorkloadProfileBuilder minimumCount(Integer minimumCount) {
            this.minimumCount = minimumCount;
            return this;
        }

        public WorkloadProfileBuilder maximumCount(Integer maximumCount) {
            this.maximumCount = maximumCount;
            return this;
        }

        public WorkloadProfile build() {
            return new WorkloadProfile(this.name, this.type, this.minimumCount, this.maximumCount);
        }

        public String toString() {
            return "WorkloadProfile.WorkloadProfileBuilder(name=" + this.name + ", type=" + this.type + ", minimumCount=" + this.minimumCount + ", maximumCount=" + this.maximumCount + ")";
        }
    }
}

