/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.servicelinker;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.servicelinker.models.AzureResource;
import com.azure.resourcemanager.servicelinker.models.LinkerResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.Deletable;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerConsumer;
import com.microsoft.azure.toolkit.lib.servicelinker.ServiceLinkerModule;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceLinker
extends AbstractAzResource<ServiceLinker, ServiceLinkerConsumer, LinkerResource>
implements Deletable {
    @Nullable
    private String targetServiceId = null;

    protected ServiceLinker(@Nonnull String name, @Nonnull String resourceGroupName, @Nonnull AbstractAzResourceModule<ServiceLinker, ServiceLinkerConsumer, LinkerResource> module) {
        super(name, resourceGroupName, module);
    }

    protected ServiceLinker(@Nonnull ServiceLinker origin) {
        super((AbstractAzResource)origin);
    }

    protected ServiceLinker(@Nonnull LinkerResource remote, @Nonnull ServiceLinkerModule module) {
        super(remote.name(), ResourceId.fromString((String)remote.id()).resourceGroupName(), (AbstractAzResourceModule)module);
    }

    protected void updateAdditionalProperties(@Nullable LinkerResource newRemote, @Nullable LinkerResource oldRemote) {
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
        Optional.ofNullable(newRemote).ifPresent(remote -> {
            if (remote.targetService() instanceof AzureResource) {
                this.targetServiceId = ((AzureResource)remote.targetService()).id();
            }
        });
    }

    public void invalidateCache() {
        super.invalidateCache();
        this.targetServiceId = null;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.emptyList();
    }

    @Nonnull
    protected String loadStatus(@Nonnull LinkerResource remote) {
        return remote.provisioningState();
    }

    @Nullable
    public String getTargetServiceId() {
        return this.targetServiceId;
    }
}

