/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.appservice.PricingTierEnum;
import com.microsoft.azure.maven.queryer.MavenPluginQueryer;
import com.microsoft.azure.maven.queryer.QueryFactory;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.Deployment;
import com.microsoft.azure.maven.webapp.configuration.DeploymentSlotSetting;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.configuration.SchemaVersion;
import com.microsoft.azure.maven.webapp.handlers.WebAppPomHandler;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="config")
public class ConfigMojo
extends AbstractWebAppMojo {
    public static final String NOT_EMPTY_REGEX = "[\\s\\S]+";
    public static final String BOOLEAN_REGEX = "[YyNn]";
    public static final String CONFIG_ONLY_SUPPORT_V2 = "Config only support V2 schema";
    public static final String CHANGE_OS_WARNING = "The plugin may not work if you change the os of an existing webapp.";
    public static final String CONFIGURATION_NO_RUNTIME = "No runtime configuration, skip it.";
    public static final String SAVING_TO_POM = "Saving configuration to pom.";
    private MavenPluginQueryer queryer;
    private WebAppPomHandler pomHandler;
    private static final String[] configTypes = new String[]{"Application", "Runtime", "DeploymentSlot"};

    protected void doExecute() throws Exception {
        this.queryer = QueryFactory.getQueryer((Settings)this.settings, (Log)this.getLog());
        this.pomHandler = new WebAppPomHandler("pom.xml");
        try {
            WebAppConfiguration configuration;
            WebAppConfiguration webAppConfiguration = configuration = this.pomHandler.getConfiguration() == null ? null : this.getWebAppConfiguration();
            if (this.isV1Configuration(configuration)) {
                this.warning(CONFIG_ONLY_SUPPORT_V2);
            } else {
                this.config(configuration);
            }
        }
        finally {
            this.queryer.close();
        }
    }

    private boolean isV1Configuration(WebAppConfiguration configuration) {
        return configuration != null && configuration.getSchemaVersion().equals(SchemaVersion.V1.toString());
    }

    protected void config(WebAppConfiguration configuration) throws MojoFailureException, MojoExecutionException, IOException {
        WebAppConfiguration result = null;
        while (!this.confirmConfiguration(result = configuration == null ? this.initConfig() : this.updateConfiguration(configuration.getBuilderFromConfiguration().build()))) {
        }
        this.info(SAVING_TO_POM);
        this.pomHandler.updatePluginConfiguration(result, configuration);
    }

    protected boolean confirmConfiguration(WebAppConfiguration configuration) throws MojoExecutionException, MojoFailureException {
        System.out.println("Please confirm webapp properties");
        System.out.println("AppName : " + configuration.getAppName());
        System.out.println("ResourceGroup : " + configuration.getResourceGroup());
        System.out.println("Region : " + configuration.getRegion());
        System.out.println("PricingTier : " + configuration.getPricingTier());
        if (configuration.getOs() == null) {
            System.out.println(CONFIGURATION_NO_RUNTIME);
        } else {
            System.out.println("OS : " + configuration.getOs().toString());
            switch (configuration.getOs()) {
                case Windows: {
                    System.out.println("Java : " + configuration.getJavaVersion());
                    System.out.println("WebContainer : " + configuration.getWebContainer());
                    break;
                }
                case Linux: {
                    System.out.println("RuntimeStack : " + configuration.getRuntimeStack());
                    break;
                }
                case Docker: {
                    System.out.println("Image : " + configuration.getImage());
                    System.out.println("ServerId : " + configuration.getServerId());
                    System.out.println("RegistryUrl : " + configuration.getRegistryUrl());
                    break;
                }
                default: {
                    throw new MojoExecutionException("The value of <os> is unknown.");
                }
            }
        }
        System.out.println("Deploy to slot : " + (configuration.getDeploymentSlotSetting() != null));
        if (configuration.getDeploymentSlotSetting() != null) {
            DeploymentSlotSetting slotSetting = configuration.getDeploymentSlotSetting();
            System.out.println("Slot name : " + slotSetting.getName());
            System.out.println("ConfigurationSource : " + slotSetting.getConfigurationSource());
        }
        String result = this.queryer.assureInputFromUser("confirm", "Y", BOOLEAN_REGEX, "Confirm (Y/N)? : ", null);
        return result.equalsIgnoreCase("Y");
    }

    protected WebAppConfiguration initConfig() throws MojoFailureException, MojoExecutionException {
        WebAppConfiguration result = this.getDefaultConfiguration();
        return this.getRuntimeConfiguration(result);
    }

    private WebAppConfiguration getDefaultConfiguration() throws MojoExecutionException {
        WebAppConfiguration.Builder builder = new WebAppConfiguration.Builder();
        String defaultName = this.getProject().getArtifactId() + "-" + System.currentTimeMillis();
        String resourceGroup = defaultName + "-rg";
        String defaultSchemaVersion = "V2";
        Region defaultRegion = WebAppConfiguration.DEFAULT_REGION;
        PricingTierEnum pricingTierEnum = WebAppConfiguration.DEFAULT_PRICINGTIER;
        return builder.appName(defaultName).resourceGroup(resourceGroup).region(defaultRegion).pricingTier(pricingTierEnum.toPricingTier()).resources(Deployment.getDefaultDeploymentConfiguration(this.getProject().getPackaging()).getResources()).schemaVersion("V2").build();
    }

    protected WebAppConfiguration updateConfiguration(WebAppConfiguration configuration) throws MojoFailureException, MojoExecutionException {
        String selection;
        switch (selection = this.queryer.assureInputFromUser("selection", null, Arrays.asList(configTypes), "Please choose which part to config")) {
            case "Application": {
                return this.getWebAppConfiguration(configuration);
            }
            case "Runtime": {
                return this.getRuntimeConfiguration(configuration);
            }
            case "DeploymentSlot": {
                return this.getSlotConfiguration(configuration);
            }
        }
        throw new MojoExecutionException("Unknow webapp setting");
    }

    private WebAppConfiguration getWebAppConfiguration(WebAppConfiguration configuration) throws MojoFailureException, MojoExecutionException {
        WebAppConfiguration.Builder builder = configuration.getBuilderFromConfiguration();
        String defaultAppName = this.getDefaultValue(configuration.appName, this.getProject().getArtifactId());
        String appName = this.queryer.assureInputFromUser("appName", defaultAppName, NOT_EMPTY_REGEX, null, null);
        String defaultResourceGroup = this.getDefaultValue(configuration.resourceGroup, String.format("%s-rg", appName));
        String resourceGroup = this.queryer.assureInputFromUser("resourceGroup", defaultResourceGroup, NOT_EMPTY_REGEX, null, null);
        String defaultRegion = configuration.getRegionOrDefault();
        String region = this.queryer.assureInputFromUser("region", defaultRegion, NOT_EMPTY_REGEX, null, null);
        String defaultPricingTier = configuration.getPricingTierOrDefault();
        String pricingTier = this.queryer.assureInputFromUser("pricingTier", defaultPricingTier, ConfigMojo.getAvailablePricingTierList(), null);
        return builder.appName(appName).resourceGroup(resourceGroup).region(Region.fromName((String)region)).pricingTier(PricingTierEnum.valueOf((String)pricingTier).toPricingTier()).build();
    }

    private WebAppConfiguration getSlotConfiguration(WebAppConfiguration configuration) throws MojoFailureException {
        WebAppConfiguration.Builder builder = configuration.getBuilderFromConfiguration();
        DeploymentSlotSetting deploymentSlotSetting = configuration.getDeploymentSlotSetting();
        String defaultIsSlotDeploy = deploymentSlotSetting == null ? "N" : "Y";
        String isSlotDeploy = this.queryer.assureInputFromUser("isSlotDeploy", defaultIsSlotDeploy, BOOLEAN_REGEX, "Deploy to slot?(Y/N): ", null);
        if (isSlotDeploy.toLowerCase().equals("n")) {
            return builder.deploymentSlotSetting(null).build();
        }
        String defaultSlotName = deploymentSlotSetting == null ? String.format("%s-slot", configuration.getAppName()) : deploymentSlotSetting.getName();
        String slotName = this.queryer.assureInputFromUser("slotName", defaultSlotName, NOT_EMPTY_REGEX, null, null);
        String defaultConfigurationSource = deploymentSlotSetting == null ? null : deploymentSlotSetting.getConfigurationSource();
        String configurationSource = this.queryer.assureInputFromUser("configurationSource", defaultConfigurationSource, null, null, null);
        DeploymentSlotSetting result = new DeploymentSlotSetting();
        result.setName(slotName);
        result.setConfigurationSource(configurationSource);
        return builder.deploymentSlotSetting(result).build();
    }

    private WebAppConfiguration getRuntimeConfiguration(WebAppConfiguration configuration) throws MojoFailureException, MojoExecutionException {
        WebAppConfiguration.Builder builder = configuration.getBuilderFromConfiguration();
        this.warning(CHANGE_OS_WARNING);
        OperatingSystemEnum defaultOs = configuration.getOs() == null ? OperatingSystemEnum.Linux : configuration.getOs();
        String os = this.queryer.assureInputFromUser("OS", (Enum)defaultOs, null);
        builder.os(OperatingSystemEnum.fromString(os));
        switch (os.toLowerCase()) {
            case "linux": {
                builder = this.getRuntimeConfigurationOfLinux(builder, configuration);
                break;
            }
            case "windows": {
                builder = this.getRuntimeConfigurationOfWindows(builder, configuration);
                break;
            }
            case "docker": {
                builder = this.getRuntimeConfigurationOfDocker(builder, configuration);
                break;
            }
            default: {
                throw new MojoExecutionException("The value of <os> is unknown.");
            }
        }
        return builder.build();
    }

    private WebAppConfiguration.Builder getRuntimeConfigurationOfLinux(WebAppConfiguration.Builder builder, WebAppConfiguration configuration) throws MojoFailureException {
        String defaultJavaVersion = configuration.getLinuxJavaVersionOrDefault();
        String javaVersion = this.queryer.assureInputFromUser("javaVersion", defaultJavaVersion, RuntimeStackUtils.getValidJavaVersions(), null);
        String defaultLinuxRuntimeStack = configuration.getLinuxRuntimeStackOrDefault();
        String runtimeStack = this.queryer.assureInputFromUser("runtimeStack", defaultLinuxRuntimeStack, RuntimeStackUtils.getValidWebContainer(javaVersion), null);
        return builder.runtimeStack(RuntimeStackUtils.getRuntimeStack(javaVersion, runtimeStack));
    }

    private WebAppConfiguration.Builder getRuntimeConfigurationOfWindows(WebAppConfiguration.Builder builder, WebAppConfiguration configuration) throws MojoFailureException {
        String defaultJavaVersion = configuration.getJavaVersionOrDefault();
        String javaVersion = this.queryer.assureInputFromUser("javaVersion", defaultJavaVersion, ConfigMojo.getAvailableJavaVersion(), null);
        String defaultWebContainer = configuration.getWebContainerOrDefault();
        String webContainer = this.queryer.assureInputFromUser("webContainer", defaultWebContainer, ConfigMojo.getAvailableWebContainer(), null);
        return builder.javaVersion(JavaVersion.fromString((String)javaVersion)).webContainer(WebContainer.fromString((String)webContainer));
    }

    private WebAppConfiguration.Builder getRuntimeConfigurationOfDocker(WebAppConfiguration.Builder builder, WebAppConfiguration configuration) throws MojoFailureException {
        String image = this.queryer.assureInputFromUser("image", configuration.image, NOT_EMPTY_REGEX, null, null);
        String serverId = this.queryer.assureInputFromUser("serverId", configuration.serverId, null, null, null);
        String registryUrl = this.queryer.assureInputFromUser("registryUrl", configuration.registryUrl, null, null, null);
        return builder.image(image).serverId(serverId).registryUrl(registryUrl);
    }

    private static List<String> getAvailableJavaVersion() {
        ArrayList<String> result = new ArrayList<String>();
        for (JavaVersion javaVersion : JavaVersion.values()) {
            if (javaVersion.toString().equals("null")) continue;
            result.add(javaVersion.toString());
        }
        Collections.sort(result);
        return result;
    }

    private static List<String> getAvailableWebContainer() {
        ArrayList<String> result = new ArrayList<String>();
        for (WebContainer webContainer : WebContainer.values()) {
            result.add(webContainer.toString());
        }
        Collections.sort(result);
        return result;
    }

    private static List<String> getAvailablePricingTierList() {
        HashSet<String> pricingTierSet = new HashSet<String>();
        for (PricingTierEnum pricingTierEnum : PricingTierEnum.values()) {
            pricingTierSet.add(pricingTierEnum.toString().toLowerCase());
        }
        ArrayList<String> result = new ArrayList<String>(pricingTierSet);
        Collections.sort(result);
        return result;
    }

    private String getDefaultValue(String defaultValue, String fallBack) {
        return StringUtils.isNotEmpty((String)defaultValue) ? defaultValue : fallBack;
    }
}

