/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.handlers.RuntimeHandler;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Settings;

public abstract class BaseRuntimeHandler
implements RuntimeHandler {
    protected RuntimeStack runtime;
    protected JavaVersion javaVersion;
    protected WebContainer webContainer;
    protected String appName;
    protected String resourceGroup;
    protected Region region;
    protected PricingTier pricingTier;
    protected String servicePlanName;
    protected String servicePlanResourceGroup;
    protected Azure azure;
    protected Settings settings;
    protected String image;
    protected String serverId;
    protected String registryUrl;
    protected Log log;

    protected BaseRuntimeHandler(Builder<?> builder) {
        this.runtime = ((Builder)builder).runtime;
        this.javaVersion = builder.javaVersion;
        this.webContainer = builder.webContainer;
        this.appName = ((Builder)builder).appName;
        this.resourceGroup = ((Builder)builder).resourceGroup;
        this.region = ((Builder)builder).region;
        this.pricingTier = ((Builder)builder).pricingTier;
        this.servicePlanName = ((Builder)builder).servicePlanName;
        this.servicePlanResourceGroup = ((Builder)builder).servicePlanResourceGroup;
        this.azure = ((Builder)builder).azure;
        this.settings = ((Builder)builder).settings;
        this.image = builder.image;
        this.serverId = builder.serverId;
        this.registryUrl = builder.registryUrl;
        this.log = ((Builder)builder).log;
    }

    public static abstract class Builder<T extends Builder<T>> {
        private RuntimeStack runtime;
        protected JavaVersion javaVersion;
        protected WebContainer webContainer;
        private String appName;
        private String resourceGroup;
        private Region region;
        private PricingTier pricingTier;
        private String servicePlanName;
        private String servicePlanResourceGroup;
        private Azure azure;
        private Settings settings;
        protected String image;
        protected String serverId;
        protected String registryUrl;
        private Log log;

        public T runtime(RuntimeStack value) {
            this.runtime = value;
            return this.self();
        }

        public T appName(String value) {
            this.appName = value;
            return this.self();
        }

        public T resourceGroup(String value) {
            this.resourceGroup = value;
            return this.self();
        }

        public T region(Region value) {
            this.region = value;
            return this.self();
        }

        public T pricingTier(PricingTier value) {
            this.pricingTier = value;
            return this.self();
        }

        public T servicePlanName(String value) {
            this.servicePlanName = value;
            return this.self();
        }

        public T servicePlanResourceGroup(String value) {
            this.servicePlanResourceGroup = value;
            return this.self();
        }

        public T azure(Azure value) {
            this.azure = value;
            return this.self();
        }

        public T mavenSettings(Settings value) {
            this.settings = value;
            return this.self();
        }

        public T log(Log value) {
            this.log = value;
            return this.self();
        }

        public T image(String value) {
            this.image = value;
            return this.self();
        }

        public T serverId(String value) {
            this.serverId = value;
            return this.self();
        }

        public T registryUrl(String value) {
            this.registryUrl = value;
            return this.self();
        }

        public T javaVersion(JavaVersion value) {
            this.javaVersion = value;
            return this.self();
        }

        public T webContainer(WebContainer value) {
            this.webContainer = value;
            return this.self();
        }

        public abstract BaseRuntimeHandler build();

        protected abstract T self();
    }
}

