/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.google.common.io.Files;
import com.microsoft.azure.maven.artifacthandler.ZIPArtifactHandlerImpl;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public final class JarArtifactHandlerImpl
extends ZIPArtifactHandlerImpl {
    private String linuxRuntime;
    private String jarFile;
    public static final String FILE_IS_NOT_JAR = "The deployment file is not a jar typed file.";
    public static final String FIND_JAR_FILE_FAIL = "Failed to find the jar file: '%s'";
    public static final String DEFAULT_LINUX_JAR_NAME = "app.jar";

    protected JarArtifactHandlerImpl(Builder builder) {
        super((ZIPArtifactHandlerImpl.Builder)builder);
        this.linuxRuntime = builder.linuxRuntime;
        this.jarFile = builder.jarFile;
    }

    protected boolean isResourcesPreparationRequired(DeployTarget target) {
        return false;
    }

    public void publish(DeployTarget deployTarget) throws IOException, MojoExecutionException {
        File jar = this.getJarFile();
        this.assureJarFileExisted(jar);
        this.prepareDeploymentFiles(jar);
        super.publish(deployTarget);
    }

    protected void prepareDeploymentFiles(File jar) throws IOException {
        File parent = new File(this.stagingDirectoryPath);
        parent.mkdirs();
        if (StringUtils.isNotEmpty((CharSequence)this.linuxRuntime)) {
            Files.copy((File)jar, (File)new File(parent, DEFAULT_LINUX_JAR_NAME));
        } else {
            Files.copy((File)jar, (File)new File(parent, jar.getName()));
            WebAppUtils.generateWebConfigFile(jar.getName(), this.log, this.stagingDirectoryPath, ((Object)((Object)this)).getClass());
        }
    }

    protected File getJarFile() {
        String jarFilePath = StringUtils.isNotEmpty((CharSequence)this.jarFile) ? this.jarFile : Paths.get(this.buildDirectoryAbsolutePath, this.project.getBuild().getFinalName() + ".jar").toString();
        return new File(jarFilePath);
    }

    protected void assureJarFileExisted(File jar) throws MojoExecutionException {
        if (!Files.getFileExtension((String)jar.getName()).equalsIgnoreCase("jar")) {
            throw new MojoExecutionException(FILE_IS_NOT_JAR);
        }
        if (!jar.exists() || !jar.isFile()) {
            throw new MojoExecutionException(String.format(FIND_JAR_FILE_FAIL, jar.getAbsolutePath()));
        }
    }

    public static class Builder
    extends ZIPArtifactHandlerImpl.Builder {
        private String jarFile;
        private String linuxRuntime;

        protected Builder self() {
            return this;
        }

        public JarArtifactHandlerImpl build() {
            return new JarArtifactHandlerImpl(this);
        }

        public Builder linuxRuntime(String value) {
            this.linuxRuntime = value;
            return this.self();
        }

        public Builder jarFile(String value) {
            this.jarFile = value;
            return this.self();
        }
    }
}

