/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.handlers.BaseRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public class PublicDockerHubRuntimeHandlerImpl
extends BaseRuntimeHandler {
    private PublicDockerHubRuntimeHandlerImpl(Builder builder) {
        super(builder);
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws Exception {
        AppServicePlan plan = WebAppUtils.createOrGetAppServicePlan(this.servicePlanName, this.resourceGroup, this.azure, this.servicePlanResourceGroup, this.region, this.pricingTier, this.log, OperatingSystem.LINUX);
        return WebAppUtils.defineLinuxApp(this.resourceGroup, this.appName, this.azure, plan).withPublicDockerHubImage(this.image);
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws Exception {
        WebAppUtils.assureLinuxWebApp(app);
        WebAppUtils.clearTags(app);
        return ((WebApp.Update)app.update()).withPublicDockerHubImage(this.image);
    }

    public static class Builder
    extends BaseRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PublicDockerHubRuntimeHandlerImpl build() {
            return new PublicDockerHubRuntimeHandlerImpl(this);
        }
    }
}

