/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.handlers;

import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.OperatingSystem;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.maven.webapp.handlers.BaseRuntimeHandler;
import com.microsoft.azure.maven.webapp.utils.WebAppUtils;

public class WindowsRuntimeHandlerImpl
extends BaseRuntimeHandler {
    private WindowsRuntimeHandlerImpl(Builder builder) {
        super(builder);
    }

    @Override
    public WebApp.DefinitionStages.WithCreate defineAppWithRuntime() throws Exception {
        AppServicePlan plan = WebAppUtils.createOrGetAppServicePlan(this.servicePlanName, this.resourceGroup, this.azure, this.servicePlanResourceGroup, this.region, this.pricingTier, this.log, OperatingSystem.WINDOWS);
        WebApp.DefinitionStages.WithCreate withCreate = WebAppUtils.defineWindowsApp(this.resourceGroup, this.appName, this.azure, plan);
        withCreate.withJavaVersion(this.javaVersion).withWebContainer(this.webContainer);
        return withCreate;
    }

    @Override
    public WebApp.Update updateAppRuntime(WebApp app) throws Exception {
        WebAppUtils.assureWindowsWebApp(app);
        WebAppUtils.clearTags(app);
        WebApp.Update update = (WebApp.Update)app.update();
        update.withJavaVersion(this.javaVersion).withWebContainer(this.webContainer);
        return update;
    }

    public static class Builder
    extends BaseRuntimeHandler.Builder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WindowsRuntimeHandlerImpl build() {
            return new WindowsRuntimeHandlerImpl(this);
        }
    }
}

