/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.WebAppConfiguration;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public abstract class ConfigurationParser {
    protected final AbstractWebAppMojo mojo;

    protected ConfigurationParser(AbstractWebAppMojo mojo) {
        this.mojo = mojo;
    }

    protected String getAppName() throws MojoExecutionException {
        String appName = this.mojo.getAppName();
        if (StringUtils.isEmpty((String)appName)) {
            throw new MojoExecutionException("Please config the <appName> in pom.xml.");
        }
        if (appName.startsWith("-") || !appName.matches("[a-zA-Z0-9\\-]{2,60}")) {
            throw new MojoExecutionException("The <appName> only allow alphanumeric characters, hyphens and cannot start or end in a hyphen.");
        }
        return this.mojo.getAppName();
    }

    protected String getResourceGroup() throws MojoExecutionException {
        String resourceGroupName = this.mojo.getResourceGroup();
        if (StringUtils.isEmpty((String)resourceGroupName)) {
            throw new MojoExecutionException("Please config the <resourceGroup> in pom.xml.");
        }
        if (resourceGroupName.endsWith(".") || !resourceGroupName.matches("[a-zA-Z0-9\\.\\_\\-\\(\\)]{1,90}")) {
            throw new MojoExecutionException("The <resourceGroup> only allow alphanumeric characters, periods, underscores, hyphens and parenthesis and cannot end in a period.");
        }
        return this.mojo.getResourceGroup();
    }

    protected abstract OperatingSystemEnum getOs() throws MojoExecutionException;

    protected abstract Region getRegion() throws MojoExecutionException;

    protected abstract RuntimeStack getRuntimeStack() throws MojoExecutionException;

    protected abstract String getImage() throws MojoExecutionException;

    protected abstract String getServerId() throws MojoExecutionException;

    protected abstract String getRegistryUrl();

    protected abstract String getSchemaVersion();

    protected abstract JavaVersion getJavaVersion() throws MojoExecutionException;

    protected abstract WebContainer getWebContainer() throws MojoExecutionException;

    protected abstract List<Resource> getResources() throws MojoExecutionException;

    public WebAppConfiguration getWebAppConfiguration() throws MojoExecutionException {
        WebAppConfiguration.Builder builder = new WebAppConfiguration.Builder();
        OperatingSystemEnum os = this.getOs();
        if (os == null) {
            this.mojo.getLog().debug((CharSequence)"No runtime related config is specified. It will cause error if creating a new web app.");
        } else {
            switch (os) {
                case Windows: {
                    builder = builder.javaVersion(this.getJavaVersion()).webContainer(this.getWebContainer());
                    break;
                }
                case Linux: {
                    builder = builder.runtimeStack(this.getRuntimeStack());
                    break;
                }
                case Docker: {
                    builder = builder.image(this.getImage()).serverId(this.getServerId()).registryUrl(this.getRegistryUrl());
                    break;
                }
                default: {
                    throw new MojoExecutionException("Invalid operating system from the configuration.");
                }
            }
        }
        return builder.appName(this.getAppName()).resourceGroup(this.getResourceGroup()).region(this.getRegion()).pricingTier(this.mojo.getPricingTier()).servicePlanName(this.mojo.getAppServicePlanName()).servicePlanResourceGroup(this.mojo.getAppServicePlanResourceGroup()).deploymentSlotSetting(this.mojo.getDeploymentSlotSetting()).os(this.getOs()).mavenSettings(this.mojo.getSettings()).resources(this.getResources()).stagingDirectoryPath(this.mojo.getDeploymentStagingDirectoryPath()).buildDirectoryAbsolutePath(this.mojo.getBuildDirectoryAbsolutePath()).project(this.mojo.getProject()).session(this.mojo.getSession()).filtering(this.mojo.getMavenResourcesFiltering()).schemaVersion(this.getSchemaVersion()).build();
    }
}

