/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.parser;

import com.microsoft.azure.management.appservice.JavaVersion;
import com.microsoft.azure.management.appservice.RuntimeStack;
import com.microsoft.azure.management.appservice.WebContainer;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.maven.webapp.AbstractWebAppMojo;
import com.microsoft.azure.maven.webapp.configuration.ContainerSetting;
import com.microsoft.azure.maven.webapp.configuration.OperatingSystemEnum;
import com.microsoft.azure.maven.webapp.parser.ConfigurationParser;
import com.microsoft.azure.maven.webapp.utils.RuntimeStackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class V1ConfigurationParser
extends ConfigurationParser {
    private static final String RUNTIME_CONFIG_CONFLICT = "Conflict settings found. <javaVersion>, <linuxRuntime>and <containerSettings> should not be set at the same time.";
    private static final String RUNTIME_NOT_EXIST = "The configuration of <linuxRuntime> in pom.xml is not correct. Please refer https://aka.ms/maven_webapp_runtime_v1 for more information";

    public V1ConfigurationParser(AbstractWebAppMojo mojo) {
        super(mojo);
    }

    @Override
    public OperatingSystemEnum getOs() throws MojoExecutionException {
        String linuxRuntime = this.mojo.getLinuxRuntime();
        JavaVersion javaVersion = this.mojo.getJavaVersion();
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        boolean isContainerSettingEmpty = containerSetting == null || containerSetting.isEmpty();
        ArrayList<OperatingSystemEnum> osList = new ArrayList<OperatingSystemEnum>();
        if (javaVersion != null) {
            osList.add(OperatingSystemEnum.Windows);
        }
        if (linuxRuntime != null) {
            osList.add(OperatingSystemEnum.Linux);
        }
        if (!isContainerSettingEmpty) {
            osList.add(OperatingSystemEnum.Docker);
        }
        if (osList.size() > 1) {
            throw new MojoExecutionException(RUNTIME_CONFIG_CONFLICT);
        }
        return osList.size() > 0 ? (OperatingSystemEnum)((Object)osList.get(0)) : null;
    }

    @Override
    protected Region getRegion() throws MojoExecutionException {
        if (StringUtils.isEmpty((String)this.mojo.getRegion())) {
            return Region.EUROPE_WEST;
        }
        if (!Arrays.asList(Region.values()).contains(Region.fromName((String)this.mojo.getRegion()))) {
            throw new MojoExecutionException("The value of <region> is not correct, please correct it in pom.xml.");
        }
        return Region.fromName((String)this.mojo.getRegion());
    }

    @Override
    public RuntimeStack getRuntimeStack() throws MojoExecutionException {
        if (this.mojo.getLinuxRuntime() == null) {
            throw new MojoExecutionException("Please configure the <linuxRuntime> in pom.xml.");
        }
        String linuxRuntime = this.mojo.getLinuxRuntime();
        RuntimeStack javaSERuntimeStack = RuntimeStackUtils.getRuntimeStack(linuxRuntime);
        if (javaSERuntimeStack != null) {
            return javaSERuntimeStack;
        }
        List<RuntimeStack> runtimeStacks = RuntimeStackUtils.getValidRuntimeStacks();
        for (RuntimeStack runtimeStack : runtimeStacks) {
            if (!runtimeStack.toString().equalsIgnoreCase(this.mojo.getLinuxRuntime())) continue;
            return runtimeStack;
        }
        throw new MojoExecutionException(RUNTIME_NOT_EXIST);
    }

    @Override
    public String getImage() throws MojoExecutionException {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        if (containerSetting == null) {
            throw new MojoExecutionException("Please config the <containerSettings> in pom.xml.");
        }
        if (StringUtils.isEmpty((String)containerSetting.getImageName())) {
            throw new MojoExecutionException("Please config the <imageName> of <containerSettings> in pom.xml.");
        }
        return containerSetting.getImageName();
    }

    @Override
    public String getServerId() {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        if (containerSetting == null) {
            return null;
        }
        return containerSetting.getServerId();
    }

    @Override
    public String getRegistryUrl() {
        ContainerSetting containerSetting = this.mojo.getContainerSettings();
        if (containerSetting == null) {
            return null;
        }
        return containerSetting.getRegistryUrl();
    }

    @Override
    protected String getSchemaVersion() {
        return "V1";
    }

    @Override
    public WebContainer getWebContainer() throws MojoExecutionException {
        if (this.mojo.getJavaWebContainer() == null) {
            throw new MojoExecutionException("The configuration of <javaWebContainer> in pom.xml is not correct.");
        }
        return this.mojo.getJavaWebContainer();
    }

    @Override
    public JavaVersion getJavaVersion() throws MojoExecutionException {
        if (this.mojo.getJavaVersion() == null) {
            throw new MojoExecutionException("The configuration of <javaVersion> in pom.xml is not correct.");
        }
        return this.mojo.getJavaVersion();
    }

    @Override
    public List<Resource> getResources() {
        return this.mojo.getResources();
    }
}

