/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import com.microsoft.azure.management.appservice.RuntimeStack;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

public class RuntimeStackUtils {
    private static final List<String> JAVA_STACKS = Arrays.asList("JAVA", "TOMCAT", "WILDFLY");
    private static final List<RuntimeStack> runtimeStacks = new ArrayList<RuntimeStack>();

    public static String getJavaVersionFromRuntimeStack(RuntimeStack runtimeStack) {
        return runtimeStack.version().split("-")[1];
    }

    public static String getWebContainerFromRuntimeStack(RuntimeStack runtimeStack) {
        String stack = runtimeStack.stack();
        String version = runtimeStack.version();
        return stack.equalsIgnoreCase("JAVA") ? version.split("-")[1] : stack + " " + version.split("-")[0];
    }

    public static RuntimeStack getRuntimeStack(String javaVersion) {
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!runtimeStack.stack().equals("JAVA") || !RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(javaVersion)) continue;
            return runtimeStack;
        }
        return null;
    }

    public static RuntimeStack getRuntimeStack(String javaVersion, String webContainer) {
        if (StringUtils.isEmpty((String)webContainer) || RuntimeStackUtils.getValidJavaVersions().contains(webContainer)) {
            return RuntimeStackUtils.getRuntimeStack(javaVersion);
        }
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(javaVersion) || !RuntimeStackUtils.getWebContainerFromRuntimeStack(runtimeStack).equalsIgnoreCase(webContainer)) continue;
            return runtimeStack;
        }
        return null;
    }

    public static List<RuntimeStack> getValidRuntimeStacks() {
        return new ArrayList<RuntimeStack>(runtimeStacks);
    }

    public static List<String> getValidWebContainer(String javaVersion) {
        HashSet<String> result = new HashSet<String>();
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            if (!RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack).equalsIgnoreCase(javaVersion) || runtimeStack.stack().equals("JAVA")) continue;
            result.add(RuntimeStackUtils.getWebContainerFromRuntimeStack(runtimeStack));
        }
        result.add(javaVersion);
        return new ArrayList<String>(result);
    }

    public static List<String> getValidJavaVersions() {
        HashSet<String> result = new HashSet<String>();
        for (RuntimeStack runtimeStack : RuntimeStackUtils.getValidRuntimeStacks()) {
            result.add(RuntimeStackUtils.getJavaVersionFromRuntimeStack(runtimeStack));
        }
        return new ArrayList<String>(result);
    }

    static {
        for (Field field : RuntimeStack.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                RuntimeStack runtimeStack = (RuntimeStack)field.get(null);
                if (!JAVA_STACKS.contains(runtimeStack.stack())) continue;
                runtimeStacks.add(runtimeStack);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

