/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.webapp.utils;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.dom.DOMElement;
import org.dom4j.tree.AbstractElement;

public class XMLUtils {
    public static void setNamespace(Element element, Namespace nameSpace) {
        if (element instanceof AbstractElement) {
            ((AbstractElement)element).setNamespace(nameSpace);
        }
        for (Element child : element.elements()) {
            XMLUtils.setNamespace(child, nameSpace);
        }
    }

    public static Element getChild(Element parent, String ... paths) {
        Element result = parent;
        for (String childName : paths) {
            if (result == null) {
                return null;
            }
            result = result.element(childName);
        }
        return result;
    }

    public static List<String> getListValue(Element domNode) {
        if (domNode == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element child : domNode.elements()) {
            result.add(child.getText());
        }
        return result;
    }

    public static String getChildValue(String attribute, Element element) {
        Element child = element.element(attribute);
        return child == null ? null : child.getText();
    }

    public static void setChildValue(String attribute, String value, Element element) {
        Element child = element.element(attribute);
        if (child == null) {
            element.add((Element)XMLUtils.createSimpleElement(attribute, value));
        } else {
            element.element(attribute).setText(value);
        }
    }

    public static Element getOrCreateSubElement(String name, Element element) {
        Element result = element.element(name);
        if (result == null) {
            result = new DOMElement(name);
            ((DOMElement)result).setNamespace(element.getNamespace());
            element.add(result);
        }
        return result;
    }

    public static DOMElement createSimpleElement(String name, String value) {
        DOMElement result = new DOMElement(name);
        result.setText(value);
        return result;
    }

    public static void removeNode(Element element, String attribute) {
        Element aim = element.element(attribute);
        if (aim != null) {
            element.remove(aim);
        }
    }

    public static void addNotEmptyElement(Element element, String attribute, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            element.add((Element)XMLUtils.createSimpleElement(attribute, value));
        }
    }

    public static void addNotEmptyListElement(Element element, String attribute, String subAttribute, List<String> values) {
        if (values != null && values.size() > 0) {
            DOMElement resultNode = new DOMElement(attribute);
            for (String value : values) {
                resultNode.add((Element)XMLUtils.createSimpleElement(subAttribute, value));
            }
            element.add((Element)resultNode);
        }
    }
}

