/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.AsyncHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.sun.jna.Callback;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsalRuntimeFuture
extends CompletableFuture<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(MsalRuntimeFuture.class);
    static HashMap<Integer, MsalRuntimeFuture> msalRuntimeFutures = new HashMap();
    static AtomicInteger asyncHandleCounter = new AtomicInteger();
    AsyncHandle handle = new AsyncHandle();
    Callback callback;
    final Integer msalRuntimeFuturesKey = asyncHandleCounter.incrementAndGet();

    public MsalRuntimeFuture(Callback callback) {
        this.callback = callback;
        msalRuntimeFutures.putIfAbsent(this.msalRuntimeFuturesKey, this);
    }

    public void cancelAsyncOperation() {
        if (this.handle.isHandleValid()) {
            try {
                LOG.info("Canceling async operation.");
                MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(MsalRuntimeInterop.MSALRUNTIME_LIBRARY.MSALRUNTIME_CancelAsyncOperation(this.handle));
            }
            catch (MsalInteropException msalInteropEx) {
                throw msalInteropEx;
            }
            catch (Exception e) {
                MsalRuntimeInterop.ERROR_HELPER.logUnknownErrorReleasingHandle(e);
            }
            finally {
                this.handle.release();
                this.handle = null;
            }
        }
    }
}

