/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import com.microsoft.aad.msal4j.AppServiceManagedIdentitySource;
import com.microsoft.aad.msal4j.CloudShellManagedIdentitySource;
import com.microsoft.aad.msal4j.IMDSManagedIdentitySource;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityIdType;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentityResponse;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.ServiceBundle;

class ManagedIdentityClient {
    private AbstractManagedIdentitySource managedIdentitySource;

    ManagedIdentityClient(MsalRequest msalRequest, ServiceBundle serviceBundle) throws Exception {
        this.managedIdentitySource = ManagedIdentityClient.createManagedIdentitySource(msalRequest, serviceBundle);
        ManagedIdentityApplication managedIdentityApplication = (ManagedIdentityApplication)msalRequest.application();
        ManagedIdentityIdType identityIdType = managedIdentityApplication.getManagedIdentityId().getIdType();
        if (!identityIdType.equals((Object)ManagedIdentityIdType.SYSTEM_ASSIGNED)) {
            this.managedIdentitySource.setUserAssignedManagedIdentity(true);
            String userAssignedId = managedIdentityApplication.getManagedIdentityId().getUserAssignedId();
            if (identityIdType.equals((Object)ManagedIdentityIdType.CLIENT_ID)) {
                this.managedIdentitySource.setManagedIdentityUserAssignedClientId(userAssignedId);
            } else if (identityIdType.equals((Object)ManagedIdentityIdType.RESOURCE_ID)) {
                this.managedIdentitySource.setManagedIdentityUserAssignedResourceId(userAssignedId);
            }
        }
    }

    ManagedIdentityResponse getManagedIdentityResponse(ManagedIdentityParameters parameters) {
        return this.managedIdentitySource.getManagedIdentityResponse(parameters);
    }

    private static AbstractManagedIdentitySource createManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        AbstractManagedIdentitySource managedIdentitySource = AppServiceManagedIdentitySource.create(msalRequest, serviceBundle);
        if (managedIdentitySource != null) {
            return managedIdentitySource;
        }
        managedIdentitySource = CloudShellManagedIdentitySource.create(msalRequest, serviceBundle);
        if (managedIdentitySource != null) {
            return managedIdentitySource;
        }
        return new IMDSManagedIdentitySource(msalRequest, serviceBundle);
    }
}

