/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityClient;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentityResponse;
import com.microsoft.aad.msal4j.MsalClientException;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.PublicApi;
import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.SilentRequest;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TokenRequestExecutor;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AcquireTokenByManagedIdentitySupplier
extends AuthenticationResultSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireTokenByManagedIdentitySupplier.class);
    private ManagedIdentityParameters managedIdentityParameters;

    AcquireTokenByManagedIdentitySupplier(ManagedIdentityApplication managedIdentityApplication, MsalRequest msalRequest) {
        super(managedIdentityApplication, msalRequest);
        this.managedIdentityParameters = (ManagedIdentityParameters)msalRequest.requestContext().apiParameters();
    }

    @Override
    AuthenticationResult execute() throws Exception {
        if (StringHelper.isNullOrBlank(this.managedIdentityParameters.resource)) {
            throw new MsalClientException("resource_required_managed_identity", "At least one scope needs to be requested for this authentication flow. ");
        }
        TokenRequestExecutor tokenRequestExecutor = new TokenRequestExecutor(this.clientApplication.authenticationAuthority, this.msalRequest, this.clientApplication.serviceBundle());
        if (!this.managedIdentityParameters.forceRefresh) {
            LOG.debug("ForceRefresh set to false. Attempting cache lookup");
            try {
                HashSet<String> scopes = new HashSet<String>();
                scopes.add(this.managedIdentityParameters.resource);
                SilentParameters parameters = SilentParameters.builder(scopes).tenant(this.managedIdentityParameters.tenant()).build();
                RequestContext context = new RequestContext(this.clientApplication, PublicApi.ACQUIRE_TOKEN_SILENTLY, parameters);
                SilentRequest silentRequest = new SilentRequest(parameters, this.clientApplication, context, null);
                AcquireTokenSilentSupplier supplier = new AcquireTokenSilentSupplier(this.clientApplication, silentRequest);
                return supplier.execute();
            }
            catch (MsalClientException ex) {
                if (ex.errorCode().equals("cache_miss")) {
                    LOG.debug(String.format("Cache lookup failed: %s", ex.getMessage()));
                    return this.fetchNewAccessTokenAndSaveToCache(tokenRequestExecutor, this.clientApplication.authenticationAuthority.host);
                }
                LOG.error("Error occurred while cache lookup. " + ex.getMessage());
                throw ex;
            }
        }
        LOG.info("Skipped looking for an Access Token in the cache because forceRefresh or Claims were set. ");
        return this.fetchNewAccessTokenAndSaveToCache(tokenRequestExecutor, this.clientApplication.authenticationAuthority.host);
    }

    private AuthenticationResult fetchNewAccessTokenAndSaveToCache(TokenRequestExecutor tokenRequestExecutor, String host) throws Exception {
        ManagedIdentityClient managedIdentityClient = new ManagedIdentityClient(this.msalRequest, tokenRequestExecutor.getServiceBundle());
        ManagedIdentityResponse managedIdentityResponse = managedIdentityClient.getManagedIdentityResponse(this.managedIdentityParameters);
        AuthenticationResult authenticationResult = this.createFromManagedIdentityResponse(managedIdentityResponse);
        this.clientApplication.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, this.clientApplication.authenticationAuthority.host);
        return authenticationResult;
    }

    private AuthenticationResult createFromManagedIdentityResponse(ManagedIdentityResponse managedIdentityResponse) {
        long expiresOn = Long.valueOf(managedIdentityResponse.expiresOn);
        long refreshOn = expiresOn > 7200L ? expiresOn / 2L : 0L;
        return AuthenticationResult.builder().accessToken(managedIdentityResponse.getAccessToken()).scopes(this.managedIdentityParameters.resource()).expiresOn(expiresOn).extExpiresOn(0L).refreshOn(refreshOn).build();
    }
}

