/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.IEnvironmentVariables;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityIdType;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.microsoft.aad.msal4j.MsalManagedIdentityException;
import com.microsoft.aad.msal4j.MsalRequest;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceFabricManagedIdentitySource
extends AbstractManagedIdentitySource {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFabricManagedIdentitySource.class);
    private static final String SERVICE_FABRIC_MSI_API_VERSION = "2019-07-01-preview";
    private final URI msiEndpoint;
    private final String identityHeader;
    private final ManagedIdentityIdType idType;
    private final String userAssignedId;

    @Override
    public void createManagedIdentityRequest(String resource) {
        this.managedIdentityRequest.baseEndpoint = this.msiEndpoint;
        this.managedIdentityRequest.method = HttpMethod.GET;
        this.managedIdentityRequest.headers = new HashMap<String, String>();
        this.managedIdentityRequest.headers.put("secret", this.identityHeader);
        this.managedIdentityRequest.queryParameters = new HashMap<String, List<String>>();
        this.managedIdentityRequest.queryParameters.put("resource", Collections.singletonList(resource));
        this.managedIdentityRequest.queryParameters.put("api-version", Collections.singletonList(SERVICE_FABRIC_MSI_API_VERSION));
        if (this.idType == ManagedIdentityIdType.CLIENT_ID) {
            LOG.info("[Managed Identity] Adding user assigned client id to the request for Service Fabric Managed Identity.");
            this.managedIdentityRequest.queryParameters.put("client_id", Collections.singletonList(this.userAssignedId));
        } else if (this.idType == ManagedIdentityIdType.RESOURCE_ID) {
            LOG.info("[Managed Identity] Adding user assigned resource id to the request for Service Fabric Managed Identity.");
            this.managedIdentityRequest.queryParameters.put("mi_res_id", Collections.singletonList(this.userAssignedId));
        }
    }

    private ServiceFabricManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, URI msiEndpoint, String identityHeader) {
        super(msalRequest, serviceBundle, ManagedIdentitySourceType.SERVICE_FABRIC);
        this.msiEndpoint = msiEndpoint;
        this.identityHeader = identityHeader;
        this.idType = ((ManagedIdentityApplication)msalRequest.application()).getManagedIdentityId().getIdType();
        this.userAssignedId = ((ManagedIdentityApplication)msalRequest.application()).getManagedIdentityId().getUserAssignedId();
    }

    static AbstractManagedIdentitySource create(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        IEnvironmentVariables environmentVariables = ServiceFabricManagedIdentitySource.getEnvironmentVariables((ManagedIdentityParameters)msalRequest.requestContext().apiParameters());
        String msiEndpoint = environmentVariables.getEnvironmentVariable("MSI_ENDPOINT");
        String identityHeader = environmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT");
        String identityServerThumbprint = environmentVariables.getEnvironmentVariable("IDENTITY_SERVER_THUMBPRINT");
        if (StringHelper.isNullOrBlank(msiEndpoint) || StringHelper.isNullOrBlank(identityHeader) || StringHelper.isNullOrBlank(identityServerThumbprint)) {
            LOG.info("[Managed Identity] Service fabric managed identity is unavailable.");
            return null;
        }
        return new ServiceFabricManagedIdentitySource(msalRequest, serviceBundle, ServiceFabricManagedIdentitySource.validateAndGetUri(msiEndpoint), identityHeader);
    }

    private static URI validateAndGetUri(String msiEndpoint) {
        try {
            URI endpointUri = new URI(msiEndpoint);
            LOG.info("[Managed Identity] Environment variables validation passed for Service Fabric Managed Identity. Endpoint URI: " + endpointUri);
            return endpointUri;
        }
        catch (URISyntaxException ex) {
            throw new MsalManagedIdentityException("invalid_managed_identity_endpoint", String.format("[Managed Identity] The environment variable %s contains an invalid Uri %s in %s managed identity source.", "MSI_ENDPOINT", msiEndpoint, "Service Fabric"), ManagedIdentitySourceType.SERVICE_FABRIC);
        }
    }
}

