// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for device code flow. Can be used as parameter to
 * {@link PublicClientApplication#acquireToken(DeviceCodeFlowParameters)}. For more details,
 * see https://aka.ms/msal4j-device-code
 */
public class DeviceCodeFlowParameters implements IAcquireTokenParameters {
    /**
     * Scopes to which the application is requesting access to.
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Receives the device code returned from the first step of Oauth2.0 device code flow. The
     * {@link DeviceCode#verificationUri} and the {@link DeviceCode#userCode} should be shown
     * to the end user.
     * <p>
     * For more details, see https://aka.ms/msal4j-device-code
     */
    @NonNull
    private Consumer<DeviceCode> deviceCodeConsumer;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    private ClaimsRequest claims;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional query parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;

    private static DeviceCodeFlowParametersBuilder builder() {
        return new DeviceCodeFlowParametersBuilder();
    }

    /**
     * Builder for {@link DeviceCodeFlowParameters}
     *
     * @param scopes             scopes application is requesting access to
     * @param deviceCodeConsumer {@link Consumer} of {@link DeviceCode}
     * @return builder that can be used to construct DeviceCodeFlowParameters
     */
    public static DeviceCodeFlowParametersBuilder builder(Set<String> scopes, Consumer<DeviceCode> deviceCodeConsumer) {
        validateNotNull("scopes", scopes);
        return builder().scopes(scopes).deviceCodeConsumer(deviceCodeConsumer);
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class DeviceCodeFlowParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Consumer<DeviceCode> deviceCodeConsumer;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        DeviceCodeFlowParametersBuilder() {
        }

        /**
         * Scopes to which the application is requesting access to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder scopes(@NonNull final Set<String> scopes) {
            if (scopes == null) {
                throw new java.lang.NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        /**
         * Receives the device code returned from the first step of Oauth2.0 device code flow. The
         * {@link DeviceCode#verificationUri} and the {@link DeviceCode#userCode} should be shown
         * to the end user.
         * <p>
         * For more details, see https://aka.ms/msal4j-device-code
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder deviceCodeConsumer(@NonNull final Consumer<DeviceCode> deviceCodeConsumer) {
            if (deviceCodeConsumer == null) {
                throw new java.lang.NullPointerException("deviceCodeConsumer is marked non-null but is null");
            }
            this.deviceCodeConsumer = deviceCodeConsumer;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional query parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public DeviceCodeFlowParameters build() {
            return new DeviceCodeFlowParameters(this.scopes, this.deviceCodeConsumer, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder(scopes=" + this.scopes + ", deviceCodeConsumer=" + this.deviceCodeConsumer + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }

    /**
     * Scopes to which the application is requesting access to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Receives the device code returned from the first step of Oauth2.0 device code flow. The
     * {@link DeviceCode#verificationUri} and the {@link DeviceCode#userCode} should be shown
     * to the end user.
     * <p>
     * For more details, see https://aka.ms/msal4j-device-code
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Consumer<DeviceCode> deviceCodeConsumer() {
        return this.deviceCodeConsumer;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional query parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    /**
     * Creates a new {@code DeviceCodeFlowParameters} instance.
     *
     * @param scopes Scopes to which the application is requesting access to.
     * @param deviceCodeConsumer Receives the device code returned from the first step of Oauth2.0 device code flow. The
     * {@link DeviceCode#verificationUri} and the {@link DeviceCode#userCode} should be shown
     * to the end user.
     * <p>
     * For more details, see https://aka.ms/msal4j-device-code
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional query parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private DeviceCodeFlowParameters(@NonNull final Set<String> scopes, @NonNull final Consumer<DeviceCode> deviceCodeConsumer, final ClaimsRequest claims, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked non-null but is null");
        }
        if (deviceCodeConsumer == null) {
            throw new java.lang.NullPointerException("deviceCodeConsumer is marked non-null but is null");
        }
        this.scopes = scopes;
        this.deviceCodeConsumer = deviceCodeConsumer;
        this.claims = claims;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
    }
}
