// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

/**
 * Contains information about outgoing HTTP request. Should be adapted to HTTP request for HTTP
 * client of choice
 */
public class HttpRequest {
    /**
     * {@link HttpMethod}
     */
    private HttpMethod httpMethod;
    /**
     * HTTP request url
     */
    private URL url;
    /**
     * HTTP request headers
     */
    private Map<String, String> headers;
    /**
     * HTTP request body
     */
    private String body;

    HttpRequest(HttpMethod httpMethod, String url) {
        this.httpMethod = httpMethod;
        this.url = createUrlFromString(url);
    }

    HttpRequest(HttpMethod httpMethod, String url, Map<String, String> headers) {
        this.httpMethod = httpMethod;
        this.url = createUrlFromString(url);
        this.headers = headers;
    }

    HttpRequest(HttpMethod httpMethod, String url, String body) {
        this.httpMethod = httpMethod;
        this.url = createUrlFromString(url);
        this.body = body;
    }

    HttpRequest(HttpMethod httpMethod, String url, Map<String, String> headers, String body) {
        this.httpMethod = httpMethod;
        this.url = createUrlFromString(url);
        this.headers = headers;
        this.body = body;
    }

    /**
     * @param headerName Name of HTTP header name
     * @return Value of HTTP header
     */
    public String headerValue(String headerName) {
        if (headerName == null || headers == null) {
            return null;
        }
        return headers.get(headerName);
    }

    private URL createUrlFromString(String stringUrl) {
        URL url;
        try {
            url = new URL(stringUrl);
        } catch (MalformedURLException e) {
            throw new MsalClientException(e);
        }
        return url;
    }

    /**
     * {@link HttpMethod}
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    /**
     * HTTP request url
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public URL url() {
        return this.url;
    }

    /**
     * HTTP request headers
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> headers() {
        return this.headers;
    }

    /**
     * HTTP request body
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String body() {
        return this.body;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof HttpRequest)) return false;
        final HttpRequest other = (HttpRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        final java.lang.Object this$httpMethod = this.httpMethod();
        final java.lang.Object other$httpMethod = other.httpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) return false;
        final java.lang.Object this$url = this.url();
        final java.lang.Object other$url = other.url();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        final java.lang.Object this$headers = this.headers();
        final java.lang.Object other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) return false;
        final java.lang.Object this$body = this.body();
        final java.lang.Object other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof HttpRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $httpMethod = this.httpMethod();
        result = result * PRIME + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        final java.lang.Object $url = this.url();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        final java.lang.Object $headers = this.headers();
        result = result * PRIME + ($headers == null ? 43 : $headers.hashCode());
        final java.lang.Object $body = this.body();
        result = result * PRIME + ($body == null ? 43 : $body.hashCode());
        return result;
    }
}
