/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.spark;

import com.microsoft.sqlserver.jdbc.spark.BulkCopyUtils$;
import com.microsoft.sqlserver.jdbc.spark.ColumnMetadata;
import com.microsoft.sqlserver.jdbc.spark.DataIOStrategy;
import com.microsoft.sqlserver.jdbc.spark.FailureInjection$;
import com.microsoft.sqlserver.jdbc.spark.SQLServerBulkJdbcOptions;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ReliableSingleInstanceStrategy$
extends DataIOStrategy
implements Logging {
    public static final ReliableSingleInstanceStrategy$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ReliableSingleInstanceStrategy$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(Dataset<Row> df, ColumnMetadata[] dfColMetaData, SQLServerBulkJdbcOptions options, String appId) {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "write : reliable write to single instance called";
            }
        });
        Connection conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory((JDBCOptions)options).apply();
        IndexedSeq<String> stagingTableList = this.getStagingTableNames(appId, df.rdd().getNumPartitions());
        this.cleanupStagingTables(conn, stagingTableList, options);
        this.createStagingTables(conn, stagingTableList, options);
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write : Starting Phase 1 - Insert to Staging tables"})).s((Seq)Nil$.MODULE$);
            }
        });
        boolean phase1Success = this.writeToStagingTables(df, dfColMetaData, options, appId);
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write : Starting Phase 2 - Union Staging tables"})).s((Seq)Nil$.MODULE$);
            }
        });
        boolean bl = phase1Success;
        if (bl) {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*** write : Initiating unionStagingTables"})).s((Seq)Nil$.MODULE$);
                }
            });
            if (stagingTableList.length() > 0) {
                this.unionStagingTables(conn, stagingTableList, dfColMetaData, options);
            }
            this.cleanupStagingTables(conn, stagingTableList, options);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write : Finished"})).s((Seq)Nil$.MODULE$);
                }
            });
            return;
        }
        if (!bl) {
            void var6_6;
            void var5_5;
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*** write : Dropping Phase 2 due to Phase 1 failure"})).s((Seq)Nil$.MODULE$);
                }
            });
            this.cleanupStagingTables((Connection)var5_5, (IndexedSeq<String>)var6_6, options);
            throw new SQLException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed dues to non-transient error. No records written "})).s((Seq)Nil$.MODULE$));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private boolean writeToStagingTables(Dataset<Row> df, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options, String appId) {
        Object object;
        boolean allSuccess = true;
        try {
            object = df.rdd().mapPartitionsWithIndex((Function2)new Serializable(dfColMetadata, options, appId){
                public static final long serialVersionUID = 0L;
                private final ColumnMetadata[] dfColMetadata$1;
                private final SQLServerBulkJdbcOptions options$3;
                private final String appId$2;

                public final Iterator<Object> apply(int index, Iterator<Row> iterator) {
                    String table_name = ReliableSingleInstanceStrategy$.MODULE$.com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$getStagingTableName(this.appId$2, index);
                    ReliableSingleInstanceStrategy$.MODULE$.logDebug((Function0<String>)new Serializable(this, table_name, index){
                        public static final long serialVersionUID = 0L;
                        private final String table_name$1;
                        private final int index$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeToStagingTables: Writing partition index ", " to Table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.index$1), this.table_name$1}));
                        }
                        {
                            this.table_name$1 = table_name$1;
                            this.index$1 = index$1;
                        }
                    });
                    SQLServerBulkJdbcOptions newOptions = new SQLServerBulkJdbcOptions((Map<String, String>)this.options$3.parameters().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tableLock"), (Object)"true")));
                    ReliableSingleInstanceStrategy$.MODULE$.com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$idempotentInsertToTable(iterator, table_name, this.dfColMetadata$1, newOptions);
                    ReliableSingleInstanceStrategy$.MODULE$.logInfo((Function0<String>)new Serializable(this, table_name, index){
                        public static final long serialVersionUID = 0L;
                        private final String table_name$1;
                        private final int index$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeToStagingTables: Successfully wrote partition ", " to Table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.index$1), this.table_name$1}));
                        }
                        {
                            this.table_name$1 = table_name$1;
                            this.index$1 = index$1;
                        }
                    });
                    return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
                }
                {
                    this.dfColMetadata$1 = dfColMetadata$1;
                    this.options$3 = options$3;
                    this.appId$2 = appId$2;
                }
            }, df.rdd().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).collect();
        }
        catch (Exception exception) {
            allSuccess = false;
            this.logError((Function0<String>)new Serializable(exception){
                public static final long serialVersionUID = 0L;
                private final Exception ex$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"writeToStagingTables: Executor failed write to table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ex$1.getMessage()}));
                }
                {
                    this.ex$1 = ex$1;
                }
            });
            object = BoxedUnit.UNIT;
        }
        return allSuccess;
    }

    public void com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$idempotentInsertToTable(Iterator<Row> iterator, String tableName, ColumnMetadata[] dfColMetaData, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"idempotentInsertToTable : Started"})).s((Seq)Nil$.MODULE$);
            }
        });
        Connection conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory((JDBCOptions)options).apply();
        try {
            BulkCopyUtils$.MODULE$.mssqlTruncateTable(conn, tableName);
        }
        catch (SQLException sQLException) {
            this.logError((Function0<String>)new Serializable(sQLException){
                public static final long serialVersionUID = 0L;
                private final SQLException ex$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"idempotentInsertToTable : Exception during drop table:"})).s((Seq)Nil$.MODULE$)).append((Object)this.ex$2.getMessage()).toString();
                }
                {
                    this.ex$2 = ex$2;
                }
            });
        }
        BulkCopyUtils$.MODULE$.savePartition(iterator, tableName, dfColMetaData, options);
        FailureInjection$.MODULE$.simulateRandomRestart(options);
    }

    private void unionStagingTables(Connection conn, IndexedSeq<String> stagingTableList, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options) {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "unionStagingTables: insert to final table";
            }
        });
        String insertStmt = this.stmtInsertWithUnion(stagingTableList, dfColMetadata, options);
        Connection conn2 = (Connection)JdbcUtils$.MODULE$.createConnectionFactory((JDBCOptions)options).apply();
        BulkCopyUtils$.MODULE$.executeUpdate(conn2, insertStmt);
    }

    /*
     * WARNING - void declaration
     */
    private IndexedSeq<String> getStagingTableNames(String appId, int nrOfPartitions) {
        void var3_3;
        scala.collection.immutable.IndexedSeq stagingTableList = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nrOfPartitions).map((Function1)new Serializable(appId){
            public static final long serialVersionUID = 0L;
            private final String appId$1;

            public final String apply(int index) {
                return ReliableSingleInstanceStrategy$.MODULE$.com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$getStagingTableName(this.appId$1, index);
            }
            {
                this.appId$1 = appId$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return var3_3;
    }

    public String com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$getStagingTableName(String appId, int index) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"##"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appId}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}))).toString();
    }

    private String stmtInsertWithUnion(IndexedSeq<String> stagingTableList, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options) {
        boolean bl;
        block4: {
            String string;
            block3: {
                String unionStr;
                block2: {
                    this.logDebug((Function0<String>)new Serializable(stagingTableList){
                        public static final long serialVersionUID = 0L;
                        private final IndexedSeq stagingTableList$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stmtInsertWithUnion: Staging tables to union are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stagingTableList$3.mkString(",")}));
                        }
                        {
                            this.stagingTableList$3 = stagingTableList$3;
                        }
                    });
                    unionStr = ((TraversableOnce)stagingTableList.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(String item) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{item}));
                        }
                    }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).mkString(" UNION ALL ");
                    String colStr = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dfColMetadata).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(ColumnMetadata item) {
                            return item.getName();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(",");
                    bl = options.tableLock();
                    if (!bl) break block2;
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " WITH (TABLOCK) ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dbtable(), unionStr}));
                    break block3;
                }
                if (bl) break block4;
                string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT INTO ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{options.dbtable(), unionStr}));
            }
            return string;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private void cleanupStagingTables(Connection conn, IndexedSeq<String> stagingTableList, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(stagingTableList){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq stagingTableList$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cleanupStagingTables: Tables to cleanup are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stagingTableList$1.mkString(",")}));
            }
            {
                this.stagingTableList$1 = stagingTableList$1;
            }
        });
        stagingTableList.map((Function1)new Serializable(conn, options){
            public static final long serialVersionUID = 0L;
            private final Connection conn$1;
            private final SQLServerBulkJdbcOptions options$1;

            public final void apply(String item) {
                try {
                    JdbcUtils$.MODULE$.dropTable(this.conn$1, item, (JDBCOptions)this.options$1);
                }
                catch (SQLException sQLException) {
                    ReliableSingleInstanceStrategy$.MODULE$.logError((Function0<String>)new Serializable(this, sQLException, item){
                        public static final long serialVersionUID = 0L;
                        private final SQLException ex$3;
                        private final String item$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cleanupStagingTables: Exception while dropping table ", " :"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.item$1}))).append((Object)this.ex$3.getMessage()).toString();
                        }
                        {
                            this.ex$3 = ex$3;
                            this.item$1 = item$1;
                        }
                    });
                }
            }
            {
                this.conn$1 = conn$1;
                this.options$1 = options$1;
            }
        }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
    }

    public void com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$createStagingTable(Connection conn, String tableName, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(tableName, options){
            public static final long serialVersionUID = 0L;
            private final String tableName$1;
            private final SQLServerBulkJdbcOptions options$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"createStagingTable : Creating table ", " as schema copy of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, this.options$4.dbtable()}));
            }
            {
                this.tableName$1 = tableName$1;
                this.options$4 = options$4;
            }
        });
        String createTableStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * INTO ", " From ", " WHERE 1=0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, options.dbtable()}));
        BulkCopyUtils$.MODULE$.executeUpdate(conn, createTableStr);
    }

    private void createStagingTables(Connection conn, IndexedSeq<String> stagingTableList, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)new Serializable(stagingTableList){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq stagingTableList$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"createStagingTables: Tables to create are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stagingTableList$2.mkString(",")}));
            }
            {
                this.stagingTableList$2 = stagingTableList$2;
            }
        });
        stagingTableList.map((Function1)new Serializable(conn, options){
            public static final long serialVersionUID = 0L;
            private final Connection conn$2;
            private final SQLServerBulkJdbcOptions options$2;

            public final void apply(String item) {
                try {
                    ReliableSingleInstanceStrategy$.MODULE$.com$microsoft$sqlserver$jdbc$spark$ReliableSingleInstanceStrategy$$createStagingTable(this.conn$2, item, this.options$2);
                    return;
                }
                catch (SQLException sQLException) {
                    ReliableSingleInstanceStrategy$.MODULE$.logError((Function0<String>)new Serializable(this, sQLException, item){
                        public static final long serialVersionUID = 0L;
                        private final SQLException ex$4;
                        private final String item$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"createStagingTables: Exception while creating table ", " : "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.item$2}))).append((Object)this.ex$4.getMessage()).toString();
                        }
                        {
                            this.ex$4 = ex$4;
                            this.item$2 = item$2;
                        }
                    });
                    throw sQLException;
                }
            }
            {
                this.conn$2 = conn$2;
                this.options$2 = options$2;
            }
        }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
    }

    private ReliableSingleInstanceStrategy$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

