/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.spark;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkData;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.spark.ColumnMetadata;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class DataFrameBulkRecord
implements ISQLServerBulkData,
AutoCloseable {
    private Iterator<Row> iterator;
    private ColumnMetadata[] dfColumnMetadata;
    private Set<Integer> columnOrdinals;
    private static final long serialVersionUID = 1L;

    public DataFrameBulkRecord(Iterator<Row> iterator, ColumnMetadata[] dfColumnMetadata) {
        this.iterator = iterator;
        this.dfColumnMetadata = dfColumnMetadata;
        this.columnOrdinals = IntStream.range(1, dfColumnMetadata.length + 1).boxed().collect(Collectors.toSet());
    }

    public Object[] getRowData() throws SQLServerException {
        Row row = (Row)this.iterator.next();
        Object[] rowData = new Object[row.length()];
        for (int idx = 0; idx < this.dfColumnMetadata.length; ++idx) {
            int dfFieldIndex = this.dfColumnMetadata[idx].getDfColIndex();
            rowData[idx] = row.get(dfFieldIndex);
        }
        return rowData;
    }

    public Set<Integer> getColumnOrdinals() {
        return this.columnOrdinals;
    }

    public String getColumnName(int column) {
        return this.dfColumnMetadata[column - 1].getName();
    }

    public int getColumnType(int column) {
        return this.dfColumnMetadata[column - 1].getType();
    }

    public int getPrecision(int column) {
        return this.dfColumnMetadata[column - 1].getPrecision();
    }

    public int getScale(int column) {
        return this.dfColumnMetadata[column - 1].getScale();
    }

    public boolean next() throws SQLServerException {
        return this.iterator.hasNext();
    }

    @Override
    public void close() throws SQLServerException {
    }
}

