/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.spark;

import com.microsoft.sqlserver.jdbc.spark.SQLServerBulkJdbcOptions;
import com.microsoft.sqlserver.jdbc.spark.utils.JdbcUtils$;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;

public final class DataPoolUtils$
implements Logging {
    public static DataPoolUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataPoolUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public List<String> getDataPoolNodeList(SQLServerBulkJdbcOptions options) {
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Searching DMV for data pools \n");
        Statement stmt = JdbcUtils$.MODULE$.createConnection((JDBCOptions)options).createStatement();
        ListBuffer nodeList = new ListBuffer();
        String query = "select address from sys.dm_db_data_pool_nodes";
        try {
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                String dpNode = rs.getString("address");
                nodeList.$plus$eq((Object)dpNode);
            }
        }
        catch (Exception ex) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append("Failed with exception ").append(ex.getMessage()).append(" \n").toString());
        }
        return nodeList.toList();
    }

    public String createDataPoolURL(String hostname, SQLServerBulkJdbcOptions options) {
        String[] tokens = options.url().split(";", 2);
        tokens[0] = new StringBuilder(22).append("jdbc:sqlserver://").append(hostname).append(":1433").toString();
        String url = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).mkString(";");
        return url;
    }

    public boolean isDataPoolScenario(SQLServerBulkJdbcOptions options) {
        return options.dataPoolDataSource() != null && options.dataPoolDataSource().length() > 0;
    }

    private DataPoolUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

