/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.spark;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkData;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopy;
import com.microsoft.sqlserver.jdbc.SQLServerBulkCopyOptions;
import com.microsoft.sqlserver.jdbc.spark.BulkCopyUtils$DataPoolTableType$;
import com.microsoft.sqlserver.jdbc.spark.ColumnMetadata;
import com.microsoft.sqlserver.jdbc.spark.DataFrameBulkRecord;
import com.microsoft.sqlserver.jdbc.spark.DataPoolUtils$;
import com.microsoft.sqlserver.jdbc.spark.SQLServerBulkJdbcOptions;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class BulkCopyUtils$
implements Logging {
    public static BulkCopyUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BulkCopyUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void savePartition(Iterator<Row> iterator, String tableName, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "savePartition:Entered");
        Connection conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory((JDBCOptions)options).apply();
        conn.setAutoCommit(false);
        conn.setTransactionIsolation(options.isolationLevel());
        boolean committed = false;
        try {
            try {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "savePartition: Calling SQL Bulk Copy to write data");
                SQLServerBulkCopy sqlServerBulkCopy = new SQLServerBulkCopy(conn);
                this.bulkWrite(iterator, tableName, sqlServerBulkCopy, dfColMetadata, options);
                conn.commit();
                committed = true;
            }
            catch (SQLException e) {
                this.handleException(e);
                throw e;
            }
        }
        finally {
            if (!committed) {
                conn.rollback();
                conn.close();
            } else {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Transaction succeeded, but closing failed", e);
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "savePartition :Exiting");
            }
        }
    }

    public void bulkWrite(Iterator<Row> iterator, String tableName, SQLServerBulkCopy sqlServerBulkCopy, ColumnMetadata[] dfColMetadata, SQLServerBulkJdbcOptions options) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("bulkWrite: Tablock option is ").append(options.tableLock()).toString());
        SQLServerBulkCopyOptions bulkConfig = this.getBulkCopyOptions(options);
        sqlServerBulkCopy.setBulkCopyOptions(bulkConfig);
        sqlServerBulkCopy.setDestinationTableName(tableName);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), dfColMetadata.length - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (dfColMetadata[i].isAutoIncrement()) break block0;
                sqlServerBulkCopy.addColumnMapping(dfColMetadata[i].getName(), dfColMetadata[i].getName());
            }
        });
        DataFrameBulkRecord bulkRecord = new DataFrameBulkRecord(iterator, dfColMetadata);
        sqlServerBulkCopy.writeToServer((ISQLServerBulkData)bulkRecord);
    }

    public void handleException(SQLException e) {
        block5: {
            SQLException cause = e.getNextException();
            if (cause == null) break block5;
            Throwable throwable = e.getCause();
            SQLException sQLException = cause;
            if (throwable == null ? sQLException != null : !throwable.equals(sQLException)) {
                if (e.getCause() == null) {
                    try {
                        e.initCause(cause);
                    }
                    catch (IllegalStateException illegalStateException) {
                        e.addSuppressed(cause);
                    }
                } else {
                    e.addSuppressed(cause);
                }
            }
        }
    }

    public void checkIsolationLevel(Connection conn, SQLServerBulkJdbcOptions options) {
        if (!conn.getMetaData().supportsTransactionIsolationLevel(options.isolationLevel())) {
            conn.close();
            throw new SQLException(new StringBuilder(44).append("Isolation level ").append(options.isolationLevel()).append(" not supported by SQL Server").toString());
        }
    }

    public Dataset<Row> repartitionDataFrame(Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        int n;
        boolean bl = false;
        Some some = null;
        Option option = options.numPartitions();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            int n2 = BoxesRunTime.unboxToInt((Object)some.value());
            if (n2 <= 0) {
                throw new IllegalArgumentException(new StringBuilder(113).append("Invalid value '").append(n2).append("' for parameter 'numPartitions'\n                in table writing via JDBC. The minimum value is 1.").toString());
            }
        }
        Dataset dataset = bl && (n = BoxesRunTime.unboxToInt((Object)some.value())) < df.rdd().getNumPartitions() ? df.coalesce(n) : df;
        return dataset;
    }

    public ResultSet getEmptyResultSet(Connection conn, String table) {
        String queryStr = new StringBuilder(25).append("SELECT * FROM ").append(table).append(" WHERE 1=0;").toString();
        return conn.createStatement().executeQuery(queryStr);
    }

    public List<String> getComputedCols(Connection conn, String table) {
        String queryStr = new StringBuilder(70).append("SELECT name FROM sys.computed_columns WHERE object_id = OBJECT_ID('").append(table).append("');").toString();
        ResultSet computedColRs = conn.createStatement().executeQuery(queryStr);
        ListBuffer computedCols = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (computedColRs.next()) {
            String colName = computedColRs.getString("name");
            computedCols.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{colName}));
        }
        return computedCols.toList();
    }

    public int dfComputedColCount(List<String> dfColNames, List<String> computedCols, Map<String, String> dfColCaseMap, boolean isCaseSensitive) {
        IntRef dfComputedColCt = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), computedCols.length() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            block0: {
                if ((!isCaseSensitive || !dfColNames.contains(computedCols.apply(j))) && (isCaseSensitive || !dfColCaseMap.contains((Object)((String)computedCols.apply(j)).toLowerCase()) || !BoxesRunTime.equals((Object)dfColCaseMap.apply((Object)((String)computedCols.apply(j)).toLowerCase()), (Object)computedCols.apply(j)))) break block0;
                ++dfComputedColCt$1.elem;
            }
        });
        return dfComputedColCt.elem;
    }

    /*
     * WARNING - void declaration
     */
    public ColumnMetadata[] defaultColMetadataMap(ResultSetMetaData metadata) {
        void var2_2;
        ColumnMetadata[] result = new ColumnMetadata[metadata.getColumnCount()];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), metadata.getColumnCount() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            result$1[idx] = new ColumnMetadata(metadata.getColumnName(idx + 1), metadata.getColumnType(idx + 1), metadata.getPrecision(idx + 1), metadata.getScale(idx + 1), metadata.isAutoIncrement(idx + 1), idx);
        });
        return var2_2;
    }

    public ColumnMetadata[] getColMetaData(Dataset<Row> df, Connection conn, SQLContext sqlContext, SQLServerBulkJdbcOptions options, boolean checkSchema) {
        ColumnMetadata[] columnMetadataArray;
        boolean isCaseSensitive = new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf("spark.sql.caseSensitive"))).toBoolean();
        ResultSet rs = this.getEmptyResultSet(conn, options.dbtable());
        if (checkSchema) {
            this.checkExTableType(conn, options);
            columnMetadataArray = this.matchSchemas(conn, options.dbtable(), df, rs, options.url(), isCaseSensitive, options.schemaCheckEnabled());
        } else {
            columnMetadataArray = this.defaultColMetadataMap(rs.getMetaData());
        }
        ColumnMetadata[] colMetaData = columnMetadataArray;
        return colMetaData;
    }

    public ColumnMetadata[] matchSchemas(Connection conn, String dbtable, Dataset<Row> df, ResultSet rs, String url, boolean isCaseSensitive, boolean strictSchemaCheck) {
        Map dfColCaseMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).map((Function1 & Serializable & scala.Serializable)item -> item.toLowerCase(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).zip((GenIterable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).toList(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        StructType dfCols = df.schema();
        StructType tableCols = JdbcUtils$.MODULE$.getSchema(rs, JdbcDialects$.MODULE$.get(url), JdbcUtils$.MODULE$.getSchema$default$3());
        List<String> computedCols = this.getComputedCols(conn, dbtable);
        String prefix = "Spark Dataframe and SQL Server table have differing";
        if (computedCols.length() == 0) {
            this.assertIfCheckEnabled(dfCols.length() == tableCols.length(), strictSchemaCheck, new StringBuilder(19).append(prefix).append(" numbers of columns").toString());
        } else if (strictSchemaCheck) {
            List dfColNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).toList();
            int dfComputedColCt = this.dfComputedColCount((List<String>)dfColNames, computedCols, (Map<String, String>)dfColCaseMap, isCaseSensitive);
            this.assertIfCheckEnabled(dfCols.length() - dfComputedColCt == tableCols.length() - computedCols.length(), strictSchemaCheck, new StringBuilder(19).append(prefix).append(" numbers of columns").toString());
        }
        ColumnMetadata[] result = new ColumnMetadata[tableCols.length()];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), tableCols.length() - 1).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> BulkCopyUtils$.$anonfun$matchSchemas$2(tableCols, computedCols, isCaseSensitive, dfCols, strictSchemaCheck, prefix, dfColCaseMap, result, rs, arg_0)));
        return result;
    }

    public Tuple3<String, String, String> get3PartName(SQLServerBulkJdbcOptions options) {
        Tuple3 tuple3;
        String defaultSchema = "dbo";
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString(options.dbtable())).split('.');
        int n = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).size();
        switch (n) {
            case 3: {
                tuple3 = new Tuple3((Object)tokens[0], (Object)tokens[1], (Object)tokens[2]);
                break;
            }
            case 2: {
                tuple3 = new Tuple3((Object)"", (Object)tokens[0], (Object)tokens[1]);
                break;
            }
            case 1: {
                tuple3 = new Tuple3((Object)"", (Object)defaultSchema, (Object)tokens[0]);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        return tuple3;
    }

    private void checkExTableType(Connection conn, SQLServerBulkJdbcOptions options) {
        if (DataPoolUtils$.MODULE$.isDataPoolScenario(options)) {
            Tuple3<String, String, String> tuple3 = this.get3PartName(options);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String schemaName = (String)tuple3._2();
            String tableName = (String)tuple3._3();
            Tuple2 tuple2 = new Tuple2((Object)schemaName, (Object)tableName);
            Tuple2 tuple22 = tuple2;
            String schemaName2 = (String)tuple22._1();
            String tableName2 = (String)tuple22._2();
            int tableType = this.getExternalTableType(conn, schemaName2, tableName2);
            String string = options.dataPoolDistPolicy();
            if ("REPLICATED".equals(string)) {
                this.assertCondition(tableType == BulkCopyUtils$DataPoolTableType$.MODULE$.REPLICATED_TABLES(), "External table is not of the type REPLICATED");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("ROUND_ROBIN".equals(string)) {
                this.assertCondition(tableType == BulkCopyUtils$DataPoolTableType$.MODULE$.ROUND_ROBIN_TABLES(), "External table is not of the type ROUND_ROBIN");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new SQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append(" Invalid value in dataPoolDistPolicy ").append(options.dataPoolDistPolicy()).append("  .\n                           | Internal feature usage error:").toString())).stripMargin());
            }
        }
    }

    public int getExternalTableType(Connection conn, String schemaName, String tableName) {
        Statement stmt = conn.createStatement();
        String queryStr = new StringBuilder(93).append("select distribution_type FROM sys.external_tables where ").append("schema_name(schema_id)='").append(schemaName).append("' and name='").append(tableName).append("'").toString();
        ResultSet rs = stmt.executeQuery(queryStr);
        rs.next();
        int tableType = rs.getInt("distribution_type");
        return tableType;
    }

    public void executeUpdate(Connection conn, String updateString) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("execute update ").append(updateString).toString());
        try (Statement stmt = conn.createStatement();){
            try {
                stmt.executeUpdate(updateString);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "execute update success");
            }
            catch (Throwable ex) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("execute update failed with error ").append(ex.getMessage()).toString());
                throw ex;
            }
        }
    }

    public void mssqlTruncateTable(Connection conn, String dbtable) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Truncating table ").append(dbtable).toString());
        String truncateTableStr = new StringBuilder(15).append("TRUNCATE TABLE ").append(dbtable).toString();
        this.executeUpdate(conn, truncateTableStr);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Truncating table succeeded");
    }

    public void mssqlCreateTable(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating table");
        String strSchema = JdbcUtils$.MODULE$.schemaString(df, options.url(), options.createTableColumnTypes());
        String createTableStr = new StringBuilder(17).append("CREATE TABLE ").append(options.dbtable()).append(" (").append(strSchema).append(") ").append(options.createTableOptions()).toString();
        this.executeUpdate(conn, createTableStr);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating table succeeded");
    }

    public void mssqlCreateExTable(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Creating external table ").append(options.dbtable()).toString());
        String strSchema = JdbcUtils$.MODULE$.schemaString(df, "jdbc:sqlserver", JdbcUtils$.MODULE$.schemaString$default$3());
        String createExTableStr = new StringBuilder(61).append("CREATE EXTERNAL TABLE ").append(options.dbtable()).append(" (").append(strSchema).append(") ").append("WITH (DATA_SOURCE=").append(options.dataPoolDataSource()).append(", DISTRIBUTION=").append(options.dataPoolDistPolicy()).append(");").toString();
        this.executeUpdate(conn, createExTableStr);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating external table succeeded");
    }

    public void mssqlCreateDataSource(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Creating datasource ").append(options.dataPoolDataSource()).toString());
        String externalDataPool = "sqldatapool://controller-svc/default";
        String createDSStr = new StringBuilder(50).append("CREATE EXTERNAL DATA SOURCE ").append(options.dataPoolDataSource()).append(" ").append("WITH (LOCATION = '").append(externalDataPool).append("');").toString();
        this.executeUpdate(conn, createDSStr);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating datasource succeeded");
    }

    public boolean mssqlcheckDataSourceExists(Connection conn, Dataset<Row> df, SQLServerBulkJdbcOptions options) {
        boolean bl;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Check if datasource exists");
        ObjectRef queryStr = ObjectRef.create((Object)new StringBuilder(55).append("SELECT 1 FROM sys.external_data_sources WHERE name = '").append(options.dataPoolDataSource()).append("'").toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("queryString is ").append((String)queryStr$1.elem).toString());
        try (Statement stmt = conn.createStatement();){
            try {
                boolean isDataSrcPresent;
                ResultSet result = stmt.executeQuery((String)queryStr.elem);
                bl = isDataSrcPresent = result.next();
            }
            catch (Throwable ex) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Check data source failed with error ").append(ex.getMessage()).toString());
                throw ex;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private SQLServerBulkCopyOptions getBulkCopyOptions(SQLServerBulkJdbcOptions options) {
        void var2_2;
        SQLServerBulkCopyOptions bulkCopyOptions = new SQLServerBulkCopyOptions();
        bulkCopyOptions.setBatchSize(options.batchSize());
        bulkCopyOptions.setBulkCopyTimeout(options.queryTimeout());
        bulkCopyOptions.setCheckConstraints(options.checkConstraints());
        bulkCopyOptions.setFireTriggers(options.fireTriggers());
        bulkCopyOptions.setKeepIdentity(options.keepIdentity());
        bulkCopyOptions.setKeepNulls(options.keepNulls());
        bulkCopyOptions.setTableLock(options.tableLock());
        bulkCopyOptions.setAllowEncryptedValueModifications(options.allowEncryptedValueModifications());
        return var2_2;
    }

    public String getDBNameFromURL(String url) {
        String token_sep = ";";
        int dbname_index = 1;
        String dbstring = url.split(token_sep)[dbname_index];
        String dbname = dbstring.split("=")[1];
        return dbname;
    }

    private void assertCondition(boolean cond, String msg) {
        try {
            Predef$.MODULE$.assert(cond);
        }
        catch (AssertionError e) {
            throw new SQLException(msg);
        }
    }

    private void assertIfCheckEnabled(boolean cond, boolean checkEnabled, String msg) {
        if (checkEnabled) {
            this.assertCondition(cond, msg);
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
        }
    }

    public static final /* synthetic */ String $anonfun$matchSchemas$3(int i$1, String tableColName$1, IntRef dfFieldIndex$1) {
        return new StringBuilder(52).append("skipping computed col index ").append(i$1).append(" col name ").append(tableColName$1).append(" dfFieldIndex ").append(dfFieldIndex$1.elem).toString();
    }

    public static final /* synthetic */ String $anonfun$matchSchemas$4(IntRef dfFieldIndex$1, StructType dfCols$1, int i$1, StructType tableCols$1) {
        return new StringBuilder(65).append("matching Df column index ").append(dfFieldIndex$1.elem).append(" datatype ").append(dfCols$1.apply(dfFieldIndex$1.elem).dataType()).append(" ").append("to table col index ").append(i$1).append(" datatype ").append(tableCols$1.apply(i$1).dataType()).toString();
    }

    public static final /* synthetic */ String $anonfun$matchSchemas$5() {
        return "Passing valid translation of ByteType to ShortType";
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$matchSchemas$2(StructType tableCols$1, List computedCols$2, boolean isCaseSensitive$2, StructType dfCols$1, boolean strictSchemaCheck$1, String prefix$1, Map dfColCaseMap$2, ColumnMetadata[] result$2, ResultSet rs$1, int i) {
        block5: {
            block4: {
                tableColName = tableCols$1.apply(i).name();
                dfFieldIndex = IntRef.create((int)-1);
                isAutoIncrement = false;
                if (!computedCols$2.contains((Object)tableColName)) break block4;
                isAutoIncrement = true;
                BulkCopyUtils$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$matchSchemas$3(int java.lang.String scala.runtime.IntRef ), ()Ljava/lang/String;)((int)i, (String)tableColName, (IntRef)dfFieldIndex));
                break block5;
            }
            dfColName = "";
            if (isCaseSensitive$2) {
                dfFieldIndex.elem = dfCols$1.fieldIndex(tableColName);
                dfColName = dfCols$1.apply(dfFieldIndex.elem).name();
                v0 = tableColName;
                var14_14 = dfColName;
                BulkCopyUtils$.MODULE$.assertIfCheckEnabled(!(v0 != null ? v0.equals(var14_14) == false : var14_14 != null), strictSchemaCheck$1, new StringBuilder(81).append(prefix$1).append(" column names '").append(tableColName).append("' and\n                        '").append(dfColName).append("' at column index ").append(i).append(" (case sensitive)").toString());
            } else {
                dfFieldIndex.elem = dfCols$1.fieldIndex((String)dfColCaseMap$2.apply((Object)tableColName.toLowerCase()));
                dfColName = dfCols$1.apply(dfFieldIndex.elem).name();
                v1 = tableColName.toLowerCase();
                var15_15 = dfColName.toLowerCase();
                BulkCopyUtils$.MODULE$.assertIfCheckEnabled(!(v1 != null ? v1.equals(var15_15) == false : var15_15 != null), strictSchemaCheck$1, new StringBuilder(83).append(prefix$1).append(" column names '").append(tableColName).append("' and\n                        '").append(dfColName).append("' at column index ").append(i).append(" (case insensitive)").toString());
            }
            BulkCopyUtils$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$matchSchemas$4(scala.runtime.IntRef org.apache.spark.sql.types.StructType int org.apache.spark.sql.types.StructType ), ()Ljava/lang/String;)((IntRef)dfFieldIndex, (StructType)dfCols$1, (int)i, (StructType)tableCols$1));
            v2 = dfCols$1.apply(dfFieldIndex.elem).dataType();
            var16_16 = ByteType$.MODULE$;
            if (v2 != null ? v2.equals(var16_16) == false : var16_16 != null) ** GOTO lbl-1000
            v3 = tableCols$1.apply(i).dataType();
            var17_17 = ShortType$.MODULE$;
            if (!(v3 != null ? v3.equals(var17_17) == false : var17_17 != null)) {
                BulkCopyUtils$.MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$matchSchemas$5(), ()Ljava/lang/String;)());
            } else lbl-1000:
            // 2 sources

            {
                v4 = dfCols$1.apply(dfFieldIndex.elem).dataType();
                var18_18 = tableCols$1.apply(i).dataType();
                BulkCopyUtils$.MODULE$.assertIfCheckEnabled(!(v4 != null ? v4.equals(var18_18) == false : var18_18 != null), strictSchemaCheck$1, new StringBuilder(77).append(prefix$1).append(" column data types at column index ").append(i).append(".").append(" DF col ").append(dfColName).append(" dataType ").append(dfCols$1.apply(dfFieldIndex.elem).dataType()).append(" ").append(" Table col ").append(tableColName).append(" dataType ").append(tableCols$1.apply(i).dataType()).append(" ").toString());
            }
            BulkCopyUtils$.MODULE$.assertIfCheckEnabled(dfCols$1.apply(dfFieldIndex.elem).nullable() == tableCols$1.apply(i).nullable(), strictSchemaCheck$1, new StringBuilder(108).append(prefix$1).append(" column nullable configurations at column index ").append(i).append(" DF col ").append(dfColName).append(" nullable config is ").append(dfCols$1.apply(dfFieldIndex.elem).nullable()).append(" ").append(" Table col ").append(tableColName).append(" nullable config is ").append(tableCols$1.apply(i).nullable()).toString());
        }
        result$2[i] = new ColumnMetadata(rs$1.getMetaData().getColumnName(i + 1), rs$1.getMetaData().getColumnType(i + 1), rs$1.getMetaData().getPrecision(i + 1), rs$1.getMetaData().getScale(i + 1), isAutoIncrement, dfFieldIndex.elem);
    }

    private BulkCopyUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

