/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc.spark;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.spark.ColumnMetadata;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.sql.Row;
import scala.collection.Iterator;

public class DataFrameBulkRecord
implements ISQLServerBulkRecord,
AutoCloseable {
    private Iterator<Row> iterator;
    private ColumnMetadata[] dfColumnMetadata;
    private Set<Integer> columnOrdinals;

    public DataFrameBulkRecord(Iterator<Row> iterator, ColumnMetadata[] dfColumnMetadata) {
        this.iterator = iterator;
        this.dfColumnMetadata = dfColumnMetadata;
        this.columnOrdinals = IntStream.range(1, dfColumnMetadata.length + 1).boxed().collect(Collectors.toSet());
    }

    public Object[] getRowData() throws SQLServerException {
        Row row = (Row)this.iterator.next();
        Object[] rowData = new Object[row.length()];
        for (int idx = 0; idx < this.dfColumnMetadata.length; ++idx) {
            int dfFieldIndex = this.dfColumnMetadata[idx].getDfColIndex();
            if (this.dfColumnMetadata[idx].isAutoIncrement()) continue;
            rowData[idx] = row.get(dfFieldIndex);
        }
        return rowData;
    }

    public Set<Integer> getColumnOrdinals() {
        return this.columnOrdinals;
    }

    public String getColumnName(int column) {
        return this.dfColumnMetadata[column - 1].getName();
    }

    public int getColumnType(int column) {
        return this.dfColumnMetadata[column - 1].getType();
    }

    public int getPrecision(int column) {
        return this.dfColumnMetadata[column - 1].getPrecision();
    }

    public int getScale(int column) {
        return this.dfColumnMetadata[column - 1].getScale();
    }

    public boolean isAutoIncrement(int column) {
        return this.dfColumnMetadata[column - 1].isAutoIncrement();
    }

    public boolean next() throws SQLServerException {
        return this.iterator.hasNext();
    }

    @Override
    public void close() throws SQLServerException {
    }

    public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale) {
    }

    public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) {
    }

    public DateTimeFormatter getColumnDateTimeFormatter(int column) {
        return null;
    }

    public void setTimestampWithTimezoneFormat(String dateTimeFormat) {
    }

    public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
    }

    public void setTimeWithTimezoneFormat(String timeFormat) {
    }

    public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
    }
}

