/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.context.core.impl;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.spring.cloud.context.core.api.ResourceManager;
import com.microsoft.azure.spring.cloud.context.core.config.AzureProperties;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public abstract class AzureManager<T, K>
implements ResourceManager<T, K> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureManager.class);
    protected final AzureProperties azureProperties;
    protected final Azure azure;

    public AzureManager(@NonNull Azure azure, @NonNull AzureProperties azureProperties) {
        this.azure = azure;
        this.azureProperties = azureProperties;
    }

    @Override
    public boolean exists(K key) {
        return this.get(key) != null;
    }

    @Override
    public T get(K key) {
        T t;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String name = this.getResourceName(key);
        try {
            LOGGER.info("Fetching {} with name '{}' ...", (Object)this.getResourceType(), (Object)name);
            t = this.internalGet(key);
        }
        catch (CloudException e) {
            try {
                String errorMessage = String.join((CharSequence)", ", e.getMessage(), e.body().code(), e.body().message());
                String message = String.format("Fetching %s with name '%s' failed due to: %s", this.getResourceType(), name, errorMessage);
                LOGGER.error(message);
                throw new RuntimeException(message);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.info("Fetching {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTime() / 1000L});
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.info("Fetching {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTime() / 1000L});
        return t;
    }

    @Override
    public T create(K key) {
        T t;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String name = this.getResourceName(key);
        try {
            LOGGER.info("Creating {} with name '{}' ...", (Object)this.getResourceType(), (Object)name);
            t = this.internalCreate(key);
        }
        catch (CloudException e) {
            try {
                String errorMessage = String.join((CharSequence)", ", e.getMessage(), e.body().code(), e.body().message());
                String message = String.format("Creating %s with name '%s' failed due to: %s", this.getResourceType(), name, errorMessage);
                LOGGER.error(message);
                throw new RuntimeException(message);
            }
            catch (Throwable throwable) {
                stopWatch.stop();
                LOGGER.info("Creating {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTime() / 1000L});
                throw throwable;
            }
        }
        stopWatch.stop();
        LOGGER.info("Creating {} with name '{}' finished in {} seconds", new Object[]{this.getResourceType(), name, stopWatch.getTime() / 1000L});
        return t;
    }

    @Override
    public T getOrCreate(K key) {
        T result = this.get(key);
        if (result != null) {
            return result;
        }
        if (!this.azureProperties.isAutoCreateResources()) {
            String message = String.format("%s with name '%s' not existed.", this.getResourceType(), this.getResourceName(key));
            LOGGER.warn(message);
            String enable = "If you want to enable automatic resource creation. Please set spring.cloud.azure.auto-create-resources=true";
            throw new IllegalArgumentException(message + enable);
        }
        return this.create(key);
    }

    abstract String getResourceName(K var1);

    abstract String getResourceType();

    abstract T internalGet(K var1);

    abstract T internalCreate(K var1);
}

