/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.context.core.util;

import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Memoizer {
    public static <T, R> Function<T, R> memoize(Function<T, R> fn) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.computeIfAbsent(t, fn);
    }

    public static <T, R> Function<T, R> memoize(Map<T, R> map, Function<T, R> fn) {
        return t -> map.computeIfAbsent(t, fn);
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(BiFunction<T, U, R> biFunction) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return (t, u) -> map.computeIfAbsent(Tuple.of(t, u), k -> biFunction.apply(k.getFirst(), k.getSecond()));
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(Map<Tuple<T, U>, R> map, BiFunction<T, U, R> biFunction) {
        return (t, u) -> map.computeIfAbsent(Tuple.of(t, u), k -> biFunction.apply(k.getFirst(), k.getSecond()));
    }
}

