/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.telemetry;

import com.microsoft.azure.spring.cloud.telemetry.MacAddressHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;

public final class TelemetryCollector {
    private static final String PROJECT_VERSION = TelemetryCollector.class.getPackage().getImplementationVersion();
    private static final String PROJECT_INFO = "spring-cloud-azure/" + PROJECT_VERSION;
    private static final String VERSION = "version";
    private static final String INSTALLATION_ID = "installationId";
    private static final String SUBSCRIPTION_ID = "subscriptionId";
    private static final String SERVICE_NAME = "serviceName";
    private static final TelemetryCollector INSTANCE = new TelemetryCollector();
    private final String name = "spring-cloud-azure";
    private final Map<String, String> commonProperties = new HashMap<String, String>();
    private final Map<String, Map<String, String>> propertiesByService = new HashMap<String, Map<String, String>>();
    private final Set<String> propertiesNeedHash = new HashSet<String>(Arrays.asList("Namespace", "AccountName"));

    private TelemetryCollector() {
        this.buildProperties();
    }

    public static TelemetryCollector getInstance() {
        return INSTANCE;
    }

    public void addService(String service) {
        this.propertiesByService.putIfAbsent(service, new HashMap());
        this.propertiesByService.get(service).put(SERVICE_NAME, service);
    }

    public void setSubscription(String subscriptionId) {
        this.commonProperties.put(SUBSCRIPTION_ID, subscriptionId);
    }

    public void addProperty(String service, String key, String value) {
        this.propertiesByService.putIfAbsent(service, new HashMap());
        this.propertiesByService.get(service).put(key, value);
        if (this.propertiesNeedHash.contains(key)) {
            this.propertiesByService.get(service).put("hashed" + key, DigestUtils.sha256Hex((String)value));
        }
    }

    public Collection<Map<String, String>> getProperties() {
        LinkedList<Map<String, String>> metrics = new LinkedList<Map<String, String>>();
        for (Map<String, String> serviceProperty : this.propertiesByService.values()) {
            HashMap<String, String> properties = new HashMap<String, String>(this.commonProperties);
            properties.putAll(serviceProperty);
            metrics.add(properties);
        }
        return metrics;
    }

    private void buildProperties() {
        this.commonProperties.put(VERSION, PROJECT_INFO);
        this.commonProperties.put(INSTALLATION_ID, MacAddressHelper.getHashedMacAddress());
    }

    public String getName() {
        return this.name;
    }
}

