/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.telemetry;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class TelemetryEventData {
    private static final String NAME = "Microsoft.ApplicationInsights.Event";
    @JsonProperty(value="iKey")
    private final String instrumentationKey;
    private final Tags tags = new Tags();
    private final EventData data = new EventData();
    private final String time = Instant.now().toString();

    public TelemetryEventData(String eventName, @NonNull Map<String, String> properties, String instrumentationKey) {
        Assert.hasText((String)eventName, (String)"Event name should contain text.");
        Assert.hasText((String)instrumentationKey, (String)"Instrumentation key should contain text.");
        this.instrumentationKey = instrumentationKey;
        this.data.getBaseData().setName(eventName);
        this.data.getBaseData().setProperties(properties);
    }

    public String getName() {
        return NAME;
    }

    public String getInstrumentationKey() {
        return this.instrumentationKey;
    }

    public Tags getTags() {
        return this.tags;
    }

    public EventData getData() {
        return this.data;
    }

    public String getTime() {
        return this.time;
    }

    private static class EventData {
        private static final String BASE_TYPE = "EventData";
        private final CustomData baseData = new CustomData();

        private EventData() {
        }

        public CustomData getBaseData() {
            return this.baseData;
        }

        public String getBaseType() {
            return BASE_TYPE;
        }

        private static class CustomData {
            private static final Integer VER = 2;
            private String name;
            private Map<String, String> properties;

            private CustomData() {
            }

            public Integer getVer() {
                return VER;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, String> getProperties() {
                return this.properties;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setProperties(Map<String, String> properties) {
                this.properties = properties;
            }
        }
    }

    private static class Tags {
        private static final String AI_CLOUD_ROLE_INSTANCE = "Spring-on-azure";
        private static final String AI_INTERNAL_SDK_VERSION = "Java-maven-plugin";

        private Tags() {
        }

        @JsonProperty(value="ai.cloud.roleInstance")
        public String getAiCloudRoleInstance() {
            return AI_CLOUD_ROLE_INSTANCE;
        }

        @JsonProperty(value="ai.internal.sdkVersion")
        public String getAiInternalSdkVersion() {
            return AI_INTERNAL_SDK_VERSION;
        }
    }
}

