/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.azure.data.cosmos.AccessCondition;
import com.azure.data.cosmos.AccessConditionType;
import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.CosmosItemResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.SqlQuerySpec;
import com.microsoft.azure.spring.data.cosmosdb.CosmosDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.common.CosmosdbUtils;
import com.microsoft.azure.spring.data.cosmosdb.common.Memoizer;
import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.ResponseDiagnosticsProcessor;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingCosmosConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.CountQueryGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.FindQuerySpecGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CosmosPageImpl;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CosmosPageRequest;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.exception.CosmosDBExceptionUtils;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosEntityInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosTemplate
implements CosmosOperations,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CosmosTemplate.class);
    private static final String COUNT_VALUE_KEY = "_aggregate";
    private final MappingCosmosConverter mappingCosmosConverter;
    private final String databaseName;
    private final ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
    private final boolean isPopulateQueryMetrics;
    private final CosmosClient cosmosClient;
    private Function<Class<?>, CosmosEntityInformation<?, ?>> entityInfoCreator = Memoizer.memoize(this::getCosmosEntityInformation);

    public CosmosTemplate(CosmosDbFactory cosmosDbFactory, MappingCosmosConverter mappingCosmosConverter, String dbName) {
        Assert.notNull((Object)cosmosDbFactory, (String)"CosmosDbFactory must not be null!");
        Assert.notNull((Object)mappingCosmosConverter, (String)"MappingCosmosConverter must not be null!");
        this.mappingCosmosConverter = mappingCosmosConverter;
        this.databaseName = dbName;
        this.cosmosClient = cosmosDbFactory.getCosmosClient();
        this.responseDiagnosticsProcessor = cosmosDbFactory.getConfig().getResponseDiagnosticsProcessor();
        this.isPopulateQueryMetrics = cosmosDbFactory.getConfig().isPopulateQueryMetrics();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public <T> T insert(T objectToSave, PartitionKey partitionKey) {
        Assert.notNull(objectToSave, (String)"domainType should not be null");
        return this.insert(this.getContainerName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    @Override
    public <T> T insert(String containerName, T objectToSave, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(objectToSave);
        log.debug("execute createItem in database {} container {}", (Object)this.databaseName, (Object)containerName);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        Class<?> domainType = objectToSave.getClass();
        CosmosItemResponse response = (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).createItem((Object)originalItem, options).doOnNext(cosmosItemResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to insert item", throwable)).block();
        assert (response != null);
        return (T)this.mappingCosmosConverter.read(domainType, response.properties());
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.findById(this.getContainerName(domainType), id, domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType, PartitionKey partitionKey) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        this.assertValidId(id);
        String containerName = this.getContainerName(domainType);
        return (T)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(id.toString(), (Object)partitionKey).read().flatMap(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return Mono.justOrEmpty(this.toDomainObject(domainType, cosmosItemResponse.properties()));
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable)).block();
    }

    @Override
    public <T> T findById(String containerName, Object id, Class<T> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(domainType, (String)"domainType should not be null");
        this.assertValidId(id);
        String query = String.format("select * from root where root.id = '%s'", id.toString());
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(true));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (T)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(query, options).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Mono.justOrEmpty(cosmosItemFeedResponse.results().stream().map(cosmosItem -> this.mappingCosmosConverter.read(domainType, (CosmosItemProperties)cosmosItem)).findFirst());
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable)).blockFirst();
    }

    @Override
    public <T> void upsert(T object, PartitionKey partitionKey) {
        Assert.notNull(object, (String)"Upsert object should not be null");
        this.upsert(this.getContainerName(object.getClass()), object, partitionKey);
    }

    @Override
    public <T> void upsert(String containerName, T object, PartitionKey partitionKey) {
        this.upsertAndReturnEntity(containerName, object, partitionKey);
    }

    @Override
    public <T> T upsertAndReturnEntity(String containerName, T object, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(object, (String)"Upsert object should not be null");
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(object);
        log.debug("execute upsert item in database {} container {}", (Object)this.databaseName, (Object)containerName);
        Class<?> domainType = object.getClass();
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        this.applyVersioning(domainType, originalItem, options);
        CosmosItemResponse cosmosItemResponse = (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).upsertItem((Object)originalItem, options).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to upsert item", throwable)).block();
        assert (cosmosItemResponse != null);
        return (T)this.mappingCosmosConverter.read(domainType, cosmosItemResponse.properties());
    }

    @Override
    public <T> List<T> findAll(Class<T> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.findAll(this.getContainerName(domainType), domainType);
    }

    @Override
    public <T> List<T> findAll(String containerName, Class<T> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull(domainType, (String)"domainType should not be null");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        List<CosmosItemProperties> items = this.findItems(query, domainType, containerName);
        return items.stream().map(d -> this.getConverter().read(domainType, (CosmosItemProperties)d)).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> findAll(PartitionKey partitionKey, Class<T> domainType) {
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        Assert.notNull(domainType, (String)"domainType should not be null");
        String containerName = this.getContainerName(domainType);
        FeedOptions feedOptions = new FeedOptions();
        feedOptions.partitionKey(partitionKey);
        feedOptions.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (List)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).readAllItems(feedOptions).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.results());
        }).map(cosmosItemProperties -> this.toDomainObject(domainType, (CosmosItemProperties)cosmosItemProperties)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to find items", throwable)).collectList().block();
    }

    @Override
    public void deleteAll(@NonNull String containerName, @NonNull Class<?> domainType) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        this.delete(query, domainType, containerName);
    }

    @Override
    public void deleteCollection(@NonNull String containerName) {
        this.deleteContainer(containerName);
    }

    @Override
    public void deleteContainer(@NonNull String containerName) {
        Assert.hasText((String)containerName, (String)"containerName should have text.");
        this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).delete().doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete container", throwable)).block();
    }

    @Override
    public String getCollectionName(Class<?> domainType) {
        return this.getContainerName(domainType);
    }

    @Override
    public String getContainerName(Class<?> domainType) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        return this.entityInfoCreator.apply(domainType).getContainerName();
    }

    @Override
    public CosmosContainerProperties createCollectionIfNotExists(@NonNull CosmosEntityInformation<?, ?> information) {
        return this.createContainerIfNotExists(information);
    }

    @Override
    public CosmosContainerProperties createContainerIfNotExists(CosmosEntityInformation<?, ?> information) {
        CosmosContainerResponse response = (CosmosContainerResponse)this.cosmosClient.createDatabaseIfNotExists(this.databaseName).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to create database", throwable)).flatMap(cosmosDatabaseResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosDatabaseResponse, null);
            return cosmosDatabaseResponse.database().createContainerIfNotExists(information.getContainerName(), "/" + information.getPartitionKeyFieldName(), information.getRequestUnit().intValue()).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to create container", throwable)).doOnNext(cosmosContainerResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse, null));
        }).block();
        assert (response != null);
        return response.properties();
    }

    @Override
    public void deleteById(String containerName, Object id, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        this.assertValidId(id);
        log.debug("execute deleteById in database {} container {}", (Object)this.databaseName, (Object)containerName);
        if (partitionKey == null) {
            partitionKey = PartitionKey.None;
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(id.toString(), (Object)partitionKey).delete(options).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete item", throwable)).block();
    }

    @Override
    public <T, ID> List<T> findByIds(Iterable<ID> ids, Class<T> domainType, String containerName) {
        Assert.notNull(ids, (String)"Id list should not be null");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.IN, "id", Collections.singletonList(ids)));
        return this.find(query, domainType, containerName);
    }

    @Override
    public <T> List<T> find(@NonNull DocumentQuery query, @NonNull Class<T> domainType, String containerName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        return this.findItems(query, domainType, containerName).stream().map(cosmosItemProperties -> this.toDomainObject(domainType, (CosmosItemProperties)cosmosItemProperties)).collect(Collectors.toList());
    }

    @Override
    public <T> Boolean exists(@NonNull DocumentQuery query, @NonNull Class<T> domainType, String containerName) {
        return this.find(query, domainType, containerName).size() > 0;
    }

    @Override
    public <T> List<T> delete(@NonNull DocumentQuery query, @NonNull Class<T> domainType, @NonNull String containerName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainType, (String)"domainType should not be null.");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        List<CosmosItemProperties> results = this.findItems(query, domainType, containerName);
        List<String> partitionKeyName = this.getPartitionKeyNames(domainType);
        return results.stream().map(cosmosItemProperties -> {
            CosmosItemResponse cosmosItemResponse = this.deleteItem((CosmosItemProperties)cosmosItemProperties, partitionKeyName, containerName, domainType);
            return this.getConverter().read(domainType, cosmosItemResponse.properties());
        }).collect(Collectors.toList());
    }

    @Override
    public <T> Page<T> findAll(Pageable pageable, Class<T> domainType, String containerName) {
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(pageable);
        if (pageable.getSort().isSorted()) {
            query.with(pageable.getSort());
        }
        return this.paginationQuery(query, domainType, containerName);
    }

    @Override
    public <T> Page<T> paginationQuery(DocumentQuery query, Class<T> domainType, String containerName) {
        Assert.isTrue((query.getPageable().getPageSize() > 0 ? 1 : 0) != 0, (String)"pageable should have page size larger than 0");
        Assert.hasText((String)containerName, (String)"container should not be null, empty or only whitespaces");
        Pageable pageable = query.getPageable();
        FeedOptions feedOptions = new FeedOptions();
        if (pageable instanceof CosmosPageRequest) {
            feedOptions.requestContinuation(((CosmosPageRequest)pageable).getRequestContinuation());
        }
        feedOptions.maxItemCount(Integer.valueOf(pageable.getPageSize()));
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(query.isCrossPartitionQuery(this.getPartitionKeyNames(domainType))));
        feedOptions.populateQueryMetrics(this.isPopulateQueryMetrics);
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        FeedResponse feedResponse = (FeedResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, feedOptions).doOnNext(propertiesFeedResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, propertiesFeedResponse)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to query items", throwable)).next().block();
        assert (feedResponse != null);
        Iterator it = feedResponse.results().iterator();
        ArrayList<T> result = new ArrayList<T>();
        for (int index = 0; it.hasNext() && index < pageable.getPageSize(); ++index) {
            CosmosItemProperties cosmosItemProperties = (CosmosItemProperties)it.next();
            if (cosmosItemProperties == null) continue;
            T entity = this.mappingCosmosConverter.read(domainType, cosmosItemProperties);
            result.add(entity);
        }
        long total = this.count(query, domainType, containerName);
        int contentSize = result.size();
        int pageSize = contentSize < pageable.getPageSize() && contentSize > 0 ? contentSize : pageable.getPageSize();
        CosmosPageRequest pageRequest = CosmosPageRequest.of(pageable.getOffset(), pageable.getPageNumber(), pageSize, feedResponse.continuationToken(), query.getSort());
        return new CosmosPageImpl(result, (Pageable)pageRequest, total);
    }

    @Override
    public long count(String containerName) {
        Assert.hasText((String)containerName, (String)"container name should not be empty");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        Long count = this.getCountValue(query, true, containerName);
        assert (count != null);
        return count;
    }

    @Override
    public <T> long count(DocumentQuery query, Class<T> domainType, String containerName) {
        Assert.notNull(domainType, (String)"domainType should not be null");
        Assert.hasText((String)containerName, (String)"container name should not be empty");
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainType));
        Long count = this.getCountValue(query, isCrossPartitionQuery, containerName);
        assert (count != null);
        return count;
    }

    @Override
    public MappingCosmosConverter getConverter() {
        return this.mappingCosmosConverter;
    }

    private Long getCountValue(DocumentQuery query, boolean isCrossPartitionQuery, String containerName) {
        SqlQuerySpec querySpec = new CountQueryGenerator().generateCosmos(query);
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (Long)this.executeQuery(querySpec, containerName, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to get count value", throwable)).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, response)).next().map(r -> ((CosmosItemProperties)r.results().get(0)).getLong(COUNT_VALUE_KEY)).block();
    }

    private Flux<FeedResponse<CosmosItemProperties>> executeQuery(SqlQuerySpec sqlQuerySpec, String containerName, FeedOptions options) {
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to execute query", throwable));
    }

    private List<String> getPartitionKeyNames(Class<?> domainType) {
        CosmosEntityInformation<?, ?> entityInfo = this.entityInfoCreator.apply(domainType);
        if (entityInfo.getPartitionKeyFieldName() == null) {
            return new ArrayList<String>();
        }
        return Collections.singletonList(entityInfo.getPartitionKeyFieldName());
    }

    private void assertValidId(Object id) {
        Assert.notNull((Object)id, (String)"id should not be null");
        if (id instanceof String) {
            Assert.hasText((String)id.toString(), (String)"id should not be empty or only whitespaces.");
        }
    }

    private List<CosmosItemProperties> findItems(@NonNull DocumentQuery query, @NonNull Class<?> domainType, @NonNull String containerName) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainType));
        FeedOptions feedOptions = new FeedOptions();
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        feedOptions.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (List)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, feedOptions).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.results());
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to find items", throwable)).collectList().block();
    }

    private CosmosItemResponse deleteItem(@NonNull CosmosItemProperties cosmosItemProperties, @NonNull List<String> partitionKeyNames, String containerName, @NonNull Class<?> domainType) {
        Assert.isTrue((partitionKeyNames.size() <= 1 ? 1 : 0) != 0, (String)"Only one Partition is supported.");
        PartitionKey partitionKey = null;
        if (!partitionKeyNames.isEmpty() && StringUtils.hasText((String)partitionKeyNames.get(0))) {
            partitionKey = new PartitionKey(cosmosItemProperties.get(partitionKeyNames.get(0)));
        }
        if (partitionKey == null) {
            partitionKey = PartitionKey.None;
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions((Object)partitionKey);
        this.applyVersioning(domainType, cosmosItemProperties, options);
        return (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(cosmosItemProperties.id(), (Object)partitionKey).delete(options).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete item", throwable)).block();
    }

    private <T> T toDomainObject(@NonNull Class<T> domainType, CosmosItemProperties cosmosItemProperties) {
        return this.mappingCosmosConverter.read(domainType, cosmosItemProperties);
    }

    private void applyVersioning(Class<?> domainType, CosmosItemProperties cosmosItemProperties, CosmosItemRequestOptions options) {
        if (this.entityInfoCreator.apply(domainType).isVersioned()) {
            AccessCondition accessCondition = new AccessCondition();
            accessCondition.type(AccessConditionType.IF_MATCH);
            accessCondition.condition(cosmosItemProperties.etag());
            options.accessCondition(accessCondition);
        }
    }

    private CosmosEntityInformation<?, ?> getCosmosEntityInformation(Class<?> domainType) {
        return new CosmosEntityInformation(domainType);
    }
}

