/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.core;

import com.microsoft.azure.spring.integration.core.api.SubscribeByGroupOperation;
import com.microsoft.azure.spring.integration.core.api.SubscribeOperation;
import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractInboundChannelAdapter
extends MessageProducerSupport {
    private final String destination;
    protected String consumerGroup = null;
    protected SubscribeOperation subscribeOperation = null;
    protected SubscribeByGroupOperation subscribeByGroupOperation = null;

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public SubscribeOperation getSubscribeOperation() {
        return this.subscribeOperation;
    }

    public void setSubscribeOperation(SubscribeOperation subscribeOperation) {
        this.subscribeOperation = subscribeOperation;
    }

    public SubscribeByGroupOperation getSubscribeByGroupOperation() {
        return this.subscribeByGroupOperation;
    }

    public void setSubscribeByGroupOperation(SubscribeByGroupOperation subscribeByGroupOperation) {
        this.subscribeByGroupOperation = subscribeByGroupOperation;
    }

    protected AbstractInboundChannelAdapter(String destination) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        this.destination = destination;
    }

    public void doStart() {
        super.doStart();
        if (this.useGroupOperation()) {
            this.subscribeByGroupOperation.subscribe(this.destination, this.consumerGroup, this::receiveMessage);
        } else {
            this.subscribeOperation.subscribe(this.destination, this::receiveMessage);
        }
    }

    public void receiveMessage(Message<?> message) {
        this.sendMessage(message);
    }

    protected void doStop() {
        if (this.useGroupOperation()) {
            this.subscribeByGroupOperation.unsubscribe(this.destination, this.consumerGroup);
        } else {
            this.subscribeOperation.unsubscribe(this.destination);
        }
        super.doStop();
    }

    private boolean useGroupOperation() {
        return this.subscribeByGroupOperation != null && StringUtils.hasText((String)this.consumerGroup);
    }

    protected Map<String, Object> buildPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("consumerGroup", this.consumerGroup);
        properties.put("destination", this.destination);
        return properties;
    }
}

