/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.core.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.spring.integration.core.converter.AzureMessageConverter;
import com.microsoft.azure.spring.integration.core.converter.ConversionException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;

public abstract class AbstractAzureMessageConverter<T>
implements AzureMessageConverter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAzureMessageConverter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    protected static byte[] toPayload(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to write JSON: " + object, e);
        }
    }

    private static <U> U fromPayload(byte[] payload, Class<U> payloadType) {
        try {
            return (U)OBJECT_MAPPER.readerFor(payloadType).readValue(payload);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to read JSON: " + Arrays.toString(payload), e);
        }
    }

    @Override
    public T fromMessage(@NonNull Message<?> message, @NonNull Class<T> targetClass) {
        T azureMessage = this.internalFromMessage(message, targetClass);
        this.setCustomHeaders(message.getHeaders(), azureMessage);
        return azureMessage;
    }

    @Override
    public <U> Message<U> toMessage(@NonNull T azureMessage, Map<String, Object> headers, @NonNull Class<U> targetPayloadClass) {
        HashMap<String, Object> mergedHeaders = new HashMap<String, Object>();
        mergedHeaders.putAll(this.buildCustomHeaders(azureMessage));
        mergedHeaders.putAll(headers);
        return this.internalToMessage(azureMessage, mergedHeaders, targetPayloadClass);
    }

    protected abstract byte[] getPayload(T var1);

    protected abstract T fromString(String var1);

    protected abstract T fromByte(byte[] var1);

    protected void setCustomHeaders(MessageHeaders headers, T azureMessage) {
    }

    protected Map<String, Object> buildCustomHeaders(T azureMessage) {
        return new HashMap<String, Object>();
    }

    private T internalFromMessage(Message<?> message, Class<T> targetClass) {
        Object payload = message.getPayload();
        if (targetClass.isInstance(payload)) {
            return targetClass.cast(payload);
        }
        if (payload instanceof String) {
            return this.fromString((String)payload);
        }
        if (payload instanceof byte[]) {
            return this.fromByte((byte[])payload);
        }
        return this.fromByte(AbstractAzureMessageConverter.toPayload(payload));
    }

    private <U> Message<?> internalToMessage(T azureMessage, Map<String, Object> headers, Class<U> targetPayloadClass) {
        byte[] payload = this.getPayload(azureMessage);
        Assert.isTrue((payload != null && payload.length > 0 ? 1 : 0) != 0, (String)"payload must not be null");
        if (targetPayloadClass.isInstance(azureMessage)) {
            return MessageBuilder.withPayload(azureMessage).copyHeaders(headers).build();
        }
        if (targetPayloadClass == String.class) {
            return MessageBuilder.withPayload((Object)new String(payload, StandardCharsets.UTF_8)).copyHeaders(headers).build();
        }
        if (targetPayloadClass == byte[].class) {
            return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
        return MessageBuilder.withPayload(AbstractAzureMessageConverter.fromPayload(payload, targetPayloadClass)).copyHeaders(headers).build();
    }

    protected <M> M readValue(String value, Class<M> targetType) {
        try {
            return (M)OBJECT_MAPPER.readValue(value, targetType);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to read JSON: " + value, e);
        }
    }

    protected boolean isValidJson(Object value) {
        try {
            if (value instanceof String) {
                OBJECT_MAPPER.readTree((String)value);
                return true;
            }
            LOG.warn("Not a valid json string: " + value);
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected String toJson(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new ConversionException("Failed to convert to JSON: " + value.toString(), e);
        }
    }
}

