/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.servicebus;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.MessageHandlerOptions;
import com.microsoft.azure.servicebus.SessionHandlerOptions;
import com.microsoft.azure.spring.integration.core.api.CheckpointConfig;
import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import com.microsoft.azure.spring.integration.core.api.PartitionSupplier;
import com.microsoft.azure.spring.integration.core.api.SendOperation;
import com.microsoft.azure.spring.integration.servicebus.ServiceBusClientConfig;
import com.microsoft.azure.spring.integration.servicebus.converter.ServiceBusMessageConverter;
import com.microsoft.azure.spring.integration.servicebus.factory.ServiceBusSenderFactory;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ServiceBusTemplate<T extends ServiceBusSenderFactory>
implements SendOperation {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceBusTemplate.class);
    protected final T senderFactory;
    protected ServiceBusClientConfig clientConfig = ServiceBusClientConfig.builder().build();
    protected CheckpointConfig checkpointConfig = CheckpointConfig.builder().checkpointMode(CheckpointMode.RECORD).build();
    protected ServiceBusMessageConverter messageConverter = new ServiceBusMessageConverter();

    public ServiceBusTemplate(@NonNull T senderFactory) {
        this.senderFactory = senderFactory;
        LOG.info("Started ServiceBusTemplate with properties: {}", (Object)this.checkpointConfig);
    }

    private static boolean isValidCheckpointConfig(CheckpointConfig checkpointConfig) {
        return checkpointConfig.getCheckpointMode() == CheckpointMode.MANUAL || checkpointConfig.getCheckpointMode() == CheckpointMode.RECORD;
    }

    public <U> CompletableFuture<Void> sendAsync(String destination, @NonNull Message<U> message, PartitionSupplier partitionSupplier) {
        Assert.hasText((String)destination, (String)"destination can't be null or empty");
        String partitionKey = this.getPartitionKey(partitionSupplier);
        IMessage serviceBusMessage = (IMessage)this.messageConverter.fromMessage(message, IMessage.class);
        if (StringUtils.hasText((String)partitionKey)) {
            serviceBusMessage.setPartitionKey(partitionKey);
        }
        return this.senderFactory.getOrCreateSender(destination).sendAsync(serviceBusMessage);
    }

    protected MessageHandlerOptions buildHandlerOptions() {
        return new MessageHandlerOptions(this.clientConfig.getConcurrency(), false, Duration.ofMinutes(5L));
    }

    protected SessionHandlerOptions buildSessionHandlerOptions() {
        return new SessionHandlerOptions(this.clientConfig.getConcurrency(), false, Duration.ofMinutes(5L));
    }

    protected ExecutorService buildHandlerExecutors(String threadPrefix) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadPrefix + "-%d").build();
        return Executors.newFixedThreadPool(this.clientConfig.getConcurrency(), threadFactory);
    }

    private String getPartitionKey(PartitionSupplier partitionSupplier) {
        if (partitionSupplier == null) {
            return "";
        }
        if (StringUtils.hasText((String)partitionSupplier.getPartitionKey())) {
            return partitionSupplier.getPartitionKey();
        }
        if (StringUtils.hasText((String)partitionSupplier.getPartitionId())) {
            return partitionSupplier.getPartitionId();
        }
        return "";
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        Assert.state((boolean)ServiceBusTemplate.isValidCheckpointConfig(checkpointConfig), (String)"Only MANUAL or RECORD checkpoint mode is supported in ServiceBusTemplate");
        this.checkpointConfig = checkpointConfig;
        LOG.info("ServiceBusTemplate checkpoint config becomes: {}", (Object)this.checkpointConfig);
    }

    public ServiceBusMessageConverter getMessageConverter() {
        return this.messageConverter;
    }
}

