/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.servicebus.factory;

import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.management.servicebus.Topic;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.ISubscriptionClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.SubscriptionClient;
import com.microsoft.azure.servicebus.TopicClient;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.spring.cloud.context.core.util.Memoizer;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import com.microsoft.azure.spring.integration.servicebus.ServiceBusRuntimeException;
import com.microsoft.azure.spring.integration.servicebus.factory.AbstractServiceBusSenderFactory;
import com.microsoft.azure.spring.integration.servicebus.factory.ServiceBusTopicClientFactory;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public class DefaultServiceBusTopicClientFactory
extends AbstractServiceBusSenderFactory
implements ServiceBusTopicClientFactory {
    private static final String SUBSCRIPTION_PATH = "%s/subscriptions/%s";
    private final BiFunction<String, String, ISubscriptionClient> subscriptionClientCreator = Memoizer.memoize(this::createSubscriptionClient);
    private final Function<String, ? extends IMessageSender> sendCreator = Memoizer.memoize(this::createTopicClient);

    public DefaultServiceBusTopicClientFactory(String connectionString) {
        super(connectionString);
    }

    private ISubscriptionClient createSubscriptionClient(String topicName, String subscription) {
        if (this.resourceManagerProvider != null && StringUtils.hasText((String)this.namespace)) {
            ServiceBusNamespace serviceBusNamespace = (ServiceBusNamespace)this.resourceManagerProvider.getServiceBusNamespaceManager().getOrCreate((Object)this.namespace);
            Topic topic = (Topic)this.resourceManagerProvider.getServiceBusTopicManager().getOrCreate((Object)Tuple.of((Object)serviceBusNamespace, (Object)topicName));
            this.resourceManagerProvider.getServiceBusTopicSubscriptionManager().getOrCreate((Object)Tuple.of((Object)topic, (Object)subscription));
        }
        String subscriptionPath = String.format(SUBSCRIPTION_PATH, topicName, subscription);
        try {
            return new SubscriptionClient(new ConnectionStringBuilder(this.connectionString, subscriptionPath), ReceiveMode.PEEKLOCK);
        }
        catch (ServiceBusException | InterruptedException e) {
            throw new ServiceBusRuntimeException("Failed to create service bus subscription client", e);
        }
    }

    private IMessageSender createTopicClient(String topicName) {
        if (this.resourceManagerProvider != null && StringUtils.hasText((String)this.namespace)) {
            ServiceBusNamespace serviceBusNamespace = (ServiceBusNamespace)this.resourceManagerProvider.getServiceBusNamespaceManager().getOrCreate((Object)this.namespace);
            this.resourceManagerProvider.getServiceBusTopicManager().getOrCreate((Object)Tuple.of((Object)serviceBusNamespace, (Object)topicName));
        }
        try {
            return new TopicClient(new ConnectionStringBuilder(this.connectionString, topicName));
        }
        catch (ServiceBusException | InterruptedException e) {
            throw new ServiceBusRuntimeException("Failed to create service bus topic client", e);
        }
    }

    @Override
    public ISubscriptionClient getOrCreateSubscriptionClient(String topic, String subscription) {
        return this.subscriptionClientCreator.apply(topic, subscription);
    }

    @Override
    public IMessageSender getOrCreateSender(String name) {
        return this.sendCreator.apply(name);
    }
}

