/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.Device;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceCollectionReferenceRequest;
import java.util.List;

public class DeviceCollectionReferenceRequest
extends BaseCollectionRequest<DeviceCollectionResponse, IDeviceCollectionPage>
implements IDeviceCollectionReferenceRequest {
    public DeviceCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceCollectionResponse.class, IDeviceCollectionPage.class);
    }

    @Override
    public void post(Device newDevice, ICallback<? super Device> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/devices/" + newDevice.id);
        new DeviceWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDevice, body, callback);
    }

    @Override
    public Device post(Device newDevice) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/devices/" + newDevice.id);
        return new DeviceWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDevice, body);
    }

    public IDeviceCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDeviceCollectionReferenceRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDeviceCollectionReferenceRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDeviceCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

