/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.GroupSettingTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.GroupSettingTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.GroupSettingTemplateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupSettingTemplateCollectionResponse;
import com.microsoft.graph.requests.extensions.GroupSettingTemplateRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupSettingTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.IGroupSettingTemplateCollectionRequest;
import java.util.List;

public class GroupSettingTemplateCollectionRequest
extends BaseCollectionRequest<GroupSettingTemplateCollectionResponse, IGroupSettingTemplateCollectionPage>
implements IGroupSettingTemplateCollectionRequest {
    public GroupSettingTemplateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupSettingTemplateCollectionResponse.class, IGroupSettingTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IGroupSettingTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupSettingTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupSettingTemplateCollectionPage get() throws ClientException {
        GroupSettingTemplateCollectionResponse response = (GroupSettingTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupSettingTemplate newGroupSettingTemplate, ICallback<? super GroupSettingTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupSettingTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupSettingTemplate, callback);
    }

    @Override
    public GroupSettingTemplate post(GroupSettingTemplate newGroupSettingTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupSettingTemplate);
    }

    @Override
    public IGroupSettingTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IGroupSettingTemplateCollectionPage buildFromResponse(GroupSettingTemplateCollectionResponse response) {
        GroupSettingTemplateCollectionRequestBuilder builder = response.nextLink != null ? new GroupSettingTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupSettingTemplateCollectionPage page = new GroupSettingTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

