/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionPage;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionResponse;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionWithReferencesRequestBuilder;
import java.util.List;

public class ServicePrincipalCollectionWithReferencesRequest
extends BaseCollectionRequest<ServicePrincipalCollectionResponse, IServicePrincipalCollectionPage>
implements IServicePrincipalCollectionWithReferencesRequest {
    public ServicePrincipalCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipalCollectionResponse.class, IServicePrincipalCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IServicePrincipalCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ServicePrincipalCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IServicePrincipalCollectionWithReferencesPage get() throws ClientException {
        ServicePrincipalCollectionResponse response = (ServicePrincipalCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IServicePrincipalCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IServicePrincipalCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IServicePrincipalCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IServicePrincipalCollectionWithReferencesPage buildFromResponse(ServicePrincipalCollectionResponse response) {
        ServicePrincipalCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new ServicePrincipalCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ServicePrincipalCollectionWithReferencesPage page = new ServicePrincipalCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

